/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JArrayLength;
import com.google.gwt.dev.jjs.ast.JArrayRef;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JLocalRef;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNewArray;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JParameterRef;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JRunAsync;
import com.google.gwt.dev.jjs.ast.JStringLiteral;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JUnsafeTypeCoercion;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.ast.JVariableRef;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JsniFieldRef;
import com.google.gwt.dev.jjs.ast.js.JsniMethodBody;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.thirdparty.guava.common.collect.ArrayListMultimap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMultimap;
import com.google.gwt.thirdparty.guava.common.collect.ListMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.List;
import java.util.Set;

public class ControlFlowAnalyzer {
    private ListMultimap<JParameter, JExpression> argumentsToRescueIfParameterRead;
    private final JMethod asyncFragmentOnLoad;
    private Set<JReferenceType> classLiteralsToBeRescuedIfGetClassIsLive = Sets.newHashSet();
    private DependencyRecorder dependencyRecorder;
    private Set<JField> fieldsWritten = Sets.newLinkedHashSet();
    private Set<JReferenceType> instantiatedTypes = Sets.newLinkedHashSet();
    private Set<JNode> liveFieldsAndMethods = Sets.newLinkedHashSet();
    private Set<String> liveStrings = Sets.newLinkedHashSet();
    private Set<JNode> membersToRescueIfTypeIsInstantiated = Sets.newHashSet();
    private final JField getClassField;
    private final JMethod getClassMethod;
    private final JProgram program;
    private Set<JReferenceType> referencedTypes = Sets.newHashSet();
    private final RescueVisitor rescuer;
    private final JMethod runAsyncOnSuccess;
    private JMethod stringValueOfChar = null;
    private final Multimap<JType, JDeclaredType> representedAsNativeTypesBySupertype;

    private boolean isTypeInstantiatedOrJso(JDeclaredType type) {
        if (type == null) {
            return false;
        }
        return type.isJsoType() || this.instantiatedTypes.contains(type);
    }

    public ControlFlowAnalyzer(ControlFlowAnalyzer cfa) {
        this.program = cfa.program;
        this.asyncFragmentOnLoad = cfa.asyncFragmentOnLoad;
        this.runAsyncOnSuccess = cfa.runAsyncOnSuccess;
        this.getClassField = cfa.getClassField;
        this.getClassMethod = cfa.getClassMethod;
        this.fieldsWritten = Sets.newHashSet(cfa.fieldsWritten);
        this.instantiatedTypes = Sets.newHashSet(cfa.instantiatedTypes);
        this.liveFieldsAndMethods = Sets.newHashSet(cfa.liveFieldsAndMethods);
        this.referencedTypes = Sets.newHashSet(cfa.referencedTypes);
        this.stringValueOfChar = cfa.stringValueOfChar;
        this.liveStrings = Sets.newHashSet(cfa.liveStrings);
        this.membersToRescueIfTypeIsInstantiated = Sets.newHashSet(cfa.membersToRescueIfTypeIsInstantiated);
        if (cfa.argumentsToRescueIfParameterRead != null) {
            this.argumentsToRescueIfParameterRead = ArrayListMultimap.create(cfa.argumentsToRescueIfParameterRead);
        }
        this.rescuer = new RescueVisitor();
        this.representedAsNativeTypesBySupertype = cfa.representedAsNativeTypesBySupertype;
    }

    public ControlFlowAnalyzer(JProgram program) {
        this.program = program;
        this.asyncFragmentOnLoad = program.getIndexedMethod("AsyncFragmentLoader.onLoad");
        this.runAsyncOnSuccess = program.getIndexedMethod("RunAsyncCallback.onSuccess");
        this.getClassField = program.getIndexedField("Object.___clazz");
        this.getClassMethod = program.getIndexedMethod("Object.getClass");
        this.rescuer = new RescueVisitor();
        ImmutableMultimap.Builder<JDeclaredType, JDeclaredType> representedAsNativeTypeBySuperTypeBuilder = ImmutableMultimap.builder();
        for (JDeclaredType jDeclaredType : program.getRepresentedAsNativeTypes()) {
            representedAsNativeTypeBySuperTypeBuilder.put(jDeclaredType, jDeclaredType);
            for (JDeclaredType superType : JjsUtils.getSupertypes(jDeclaredType)) {
                representedAsNativeTypeBySuperTypeBuilder.put(superType, jDeclaredType);
            }
        }
        this.representedAsNativeTypesBySupertype = representedAsNativeTypeBySuperTypeBuilder.build();
    }

    public Set<JField> getFieldsWritten() {
        return this.fieldsWritten;
    }

    public Set<JReferenceType> getInstantiatedTypes() {
        return this.instantiatedTypes;
    }

    public Set<? extends JNode> getLiveFieldsAndMethods() {
        return this.liveFieldsAndMethods;
    }

    public Set<String> getLiveStrings() {
        return this.liveStrings;
    }

    public Set<? extends JReferenceType> getReferencedTypes() {
        return this.referencedTypes;
    }

    public void setDependencyRecorder(DependencyRecorder dr) {
        if (this.dependencyRecorder != null && dr != null) {
            throw new IllegalArgumentException("Attempting to set multiple dependency recorders");
        }
        this.dependencyRecorder = dr;
    }

    public void setForPruning() {
        assert (this.argumentsToRescueIfParameterRead == null);
        this.argumentsToRescueIfParameterRead = ArrayListMultimap.create();
    }

    public void traverseEntryMethods() {
        for (JMethod method : this.program.getEntryMethods()) {
            this.traverseFrom(method);
        }
        List<JDeclaredType> declaredTypes = this.program.getDeclaredTypes();
        for (JDeclaredType type : declaredTypes) {
            if (type.canBeImplementedExternally()) {
                this.rescuer.rescue(type, true);
            }
            for (JMethod method : type.getMethods()) {
                if (!method.isJsInteropEntryPoint() && !method.canBeImplementedExternally()) continue;
                this.rescuer.rescue(method.getEnclosingType(), true);
                this.traverseFrom(method);
            }
            for (JField field : type.getFields()) {
                if (!field.isJsInteropEntryPoint() && !field.canBeImplementedExternally()) continue;
                this.rescuer.rescue(field.getEnclosingType(), true);
                this.rescuer.rescue(field);
            }
        }
        for (JArrayType arrayType : this.program.getAllArrayTypes()) {
            if (!arrayType.canBeImplementedExternally()) continue;
            this.rescuer.rescue(arrayType, true);
        }
        if (this.program.getRunAsyncs().size() > 0) {
            this.traverseFrom(this.asyncFragmentOnLoad);
        }
    }

    public void traverseEverything() {
        this.traverseEntryMethods();
        this.traverseFromRunAsyncs();
        this.liveFieldsAndMethods.add(this.runAsyncOnSuccess);
    }

    public void traverseFrom(JMethod method) {
        this.rescuer.rescue(method);
    }

    public void traverseFromInstantiationOf(JDeclaredType type) {
        this.rescuer.rescue(type, true);
    }

    public void traverseFromReferenceTo(JDeclaredType type) {
        this.rescuer.rescue(type, false);
    }

    public void traverseFromRunAsync(JRunAsync runAsync) {
        runAsync.traverseOnSuccess(this.rescuer);
    }

    public void traverseFromRunAsyncs() {
        for (JRunAsync runAsync : this.program.getRunAsyncs()) {
            this.traverseFromRunAsync(runAsync);
        }
    }

    private class RescueVisitor
    extends JVisitor {
        private final List<JMethod> curMethodStack = Lists.newArrayList();

        private RescueVisitor() {
        }

        @Override
        public boolean visit(JArrayRef arrayRef, Context ctx) {
            this.maybeRescueJsTypeArray(arrayRef.getInstance().getType());
            return true;
        }

        @Override
        public boolean visit(JArrayLength arrayLength, Context ctx) {
            this.maybeRescueJsTypeArray(arrayLength.getInstance().getType());
            return true;
        }

        @Override
        public boolean visit(JArrayType type, Context ctx) {
            assert (ControlFlowAnalyzer.this.referencedTypes.contains(type));
            boolean isInstantiated = ControlFlowAnalyzer.this.instantiatedTypes.contains(type);
            JType leafType = type.getLeafType();
            int dims = type.getDims();
            boolean didSuperType = false;
            if (leafType instanceof JClassType) {
                JClassType superClass = ((JClassType)leafType).getSuperClass();
                if (superClass != null) {
                    this.rescue(ControlFlowAnalyzer.this.program.getOrCreateArrayType(superClass, dims), isInstantiated);
                    didSuperType = true;
                }
            } else if (leafType instanceof JInterfaceType) {
                this.rescue(ControlFlowAnalyzer.this.program.getOrCreateArrayType(ControlFlowAnalyzer.this.program.getTypeJavaLangObject(), dims), isInstantiated);
                didSuperType = true;
            }
            if (!didSuperType) {
                if (dims > 1) {
                    this.rescue(ControlFlowAnalyzer.this.program.getOrCreateArrayType(ControlFlowAnalyzer.this.program.getTypeJavaLangObject(), dims - 1), isInstantiated);
                } else {
                    this.rescue(ControlFlowAnalyzer.this.program.getTypeJavaLangObject(), isInstantiated);
                }
            }
            if (leafType instanceof JDeclaredType) {
                JDeclaredType dLeafType = (JDeclaredType)leafType;
                for (JInterfaceType intfType : dLeafType.getImplements()) {
                    JArrayType intfArray = ControlFlowAnalyzer.this.program.getOrCreateArrayType(intfType, dims);
                    this.rescue(intfArray, isInstantiated);
                }
            }
            return false;
        }

        @Override
        public boolean visit(JBinaryOperation x, Context ctx) {
            if (x.isAssignment() && x.getLhs() instanceof JFieldRef) {
                ControlFlowAnalyzer.this.fieldsWritten.add(((JFieldRef)x.getLhs()).getField());
            }
            if (x.getOp() == JBinaryOperator.CONCAT || x.getOp() == JBinaryOperator.ASG_CONCAT) {
                this.rescueByConcat(x.getLhs().getType());
                this.rescueByConcat(x.getRhs().getType());
            }
            JExpression lhs = x.getLhs();
            if (x.getOp() != JBinaryOperator.ASG || lhs.hasSideEffects() || this.isVolatileField(lhs)) {
                return true;
            }
            if (lhs instanceof JLocalRef || lhs instanceof JParameterRef) {
                this.accept(x.getRhs());
                return false;
            }
            if (lhs instanceof JFieldRef) {
                JFieldRef fieldRef = (JFieldRef)lhs;
                JField field = fieldRef.getField();
                if (field.canBeImplementedExternally()) {
                    return true;
                }
                JExpression instance = fieldRef.getInstance();
                if (instance != null) {
                    this.accept(instance);
                }
                this.accept(x.getRhs());
                return false;
            }
            return true;
        }

        @Override
        public boolean visit(JCastOperation x, Context ctx) {
            this.rescueByTypeCoercion(x.getCastType(), x.getExpr().getType());
            return true;
        }

        @Override
        public boolean visit(JClassLiteral x, Context ctx) {
            JField field = x.getField();
            assert (field != null);
            this.rescue(field);
            return true;
        }

        @Override
        public boolean visit(JClassType type, Context ctx) {
            assert (ControlFlowAnalyzer.this.referencedTypes.contains(type));
            boolean isInstantiated = ControlFlowAnalyzer.this.instantiatedTypes.contains(type);
            this.rescue(type.getSuperClass(), isInstantiated);
            if (type.hasClinit()) {
                this.rescue(type.getClinitMethod());
            }
            if (isInstantiated) {
                this.rescueMembersAndInstantiateSuperInterfaces(type);
            }
            return false;
        }

        @Override
        public boolean visit(JDeclarationStatement x, Context ctx) {
            JFieldRef fieldRef;
            JExpression instance;
            JVariableRef variableRef;
            if (x.getInitializer() != null && !this.isStaticFieldInitializedToLiteral(x.getVariableRef().getTarget())) {
                this.accept(x.getInitializer());
                if (x.getVariableRef().getTarget() instanceof JField) {
                    ControlFlowAnalyzer.this.fieldsWritten.add((JField)x.getVariableRef().getTarget());
                }
            }
            if ((variableRef = x.getVariableRef()) instanceof JFieldRef && (instance = (fieldRef = (JFieldRef)variableRef).getInstance()) != null) {
                this.accept(instance);
            }
            return false;
        }

        @Override
        public boolean visit(JFieldRef ref, Context ctx) {
            JField target = ref.getField();
            if (target.isStatic()) {
                this.rescue(target.getEnclosingType(), false);
            }
            if (target.isStatic() || ControlFlowAnalyzer.this.instantiatedTypes.contains(target.getEnclosingType())) {
                this.rescue(target);
            } else if (!ControlFlowAnalyzer.this.liveFieldsAndMethods.contains(target)) {
                ControlFlowAnalyzer.this.membersToRescueIfTypeIsInstantiated.add(target);
            }
            return true;
        }

        @Override
        public boolean visit(JInterfaceType type, Context ctx) {
            boolean isReferenced = ControlFlowAnalyzer.this.referencedTypes.contains(type);
            boolean isInstantiated = ControlFlowAnalyzer.this.instantiatedTypes.contains(type);
            assert (isReferenced || isInstantiated);
            if (type.hasClinit()) {
                this.rescue(type.getClinitMethod());
            }
            if (isInstantiated) {
                this.rescueMembersAndInstantiateSuperInterfaces(type);
            }
            return false;
        }

        @Override
        public boolean visit(JLocalRef ref, Context ctx) {
            JLocal target = ref.getLocal();
            this.rescue(target);
            return true;
        }

        @Override
        public boolean visit(final JMethod x, Context ctx) {
            JDeclaredType enclosingType = x.getEnclosingType();
            if (enclosingType.isJsoType()) {
                boolean instance = !x.isStatic() || ControlFlowAnalyzer.this.program.isStaticImpl(x);
                this.rescue(enclosingType, instance);
            } else if (x.isStatic()) {
                this.rescue(enclosingType, false);
            }
            if (x.isJsniMethod()) {
                JsniMethodBody body = (JsniMethodBody)x.getBody();
                final JsFunction func = body.getFunc();
                new JsVisitor(){

                    @Override
                    public void endVisit(JsNameRef nameRef, JsContext ctx) {
                        int index;
                        JsName ident = nameRef.getName();
                        if (ident != null && (index = func.getParameters().indexOf(ident.getStaticRef())) != -1) {
                            RescueVisitor.this.rescue(x.getParams().get(index));
                        }
                    }
                }.accept(func);
            }
            return true;
        }

        @Override
        public boolean visit(JMethodCall call, Context ctx) {
            JMethod method = call.getTarget();
            if (call.isVolatile() && method == ControlFlowAnalyzer.this.runAsyncOnSuccess) {
                return true;
            }
            if (method.isStatic() || ControlFlowAnalyzer.this.isTypeInstantiatedOrJso(method.getEnclosingType())) {
                this.rescue(method);
            } else if (!ControlFlowAnalyzer.this.liveFieldsAndMethods.contains(method)) {
                ControlFlowAnalyzer.this.membersToRescueIfTypeIsInstantiated.add(method);
            }
            if (ControlFlowAnalyzer.this.argumentsToRescueIfParameterRead == null || method.canBePolymorphic() || call instanceof JsniMethodRef) {
                return true;
            }
            if (ControlFlowAnalyzer.this.program.instanceMethodForStaticImpl(method) != null) {
                return true;
            }
            if (call.getInstance() != null) {
                this.accept(call.getInstance());
            }
            this.rescueArgumentsIfParametersCanBeRead(call);
            return false;
        }

        @Override
        public boolean visit(JNewArray newArray, Context ctx) {
            JArrayType arrayType = newArray.getArrayType();
            if (newArray.getDimensionExpressions() != null) {
                int arrayDimensions = arrayType.getDims();
                int initializedDimensions = newArray.getDimensionExpressions().size();
                JType leafType = arrayType.getLeafType();
                assert (initializedDimensions <= arrayDimensions);
                for (int i = 0; i < initializedDimensions; ++i) {
                    this.rescue(ControlFlowAnalyzer.this.program.getOrCreateArrayType(leafType, arrayDimensions - i), true);
                }
            } else {
                this.rescue(arrayType, true);
            }
            return true;
        }

        @Override
        public boolean visit(JNewInstance x, Context ctx) {
            this.rescue(x.getClassType(), true);
            return super.visit(x, ctx);
        }

        @Override
        public boolean visit(JParameterRef x, Context ctx) {
            this.rescue(x.getParameter());
            return true;
        }

        @Override
        public boolean visit(JsniFieldRef x, Context ctx) {
            if (x.isLvalue()) {
                this.maybeRescueJavaScriptObjectPassingIntoJava(x.getField().getType());
            }
            return this.visit((JFieldRef)x, ctx);
        }

        @Override
        public boolean visit(JsniMethodBody body, Context ctx) {
            ControlFlowAnalyzer.this.liveStrings.addAll(body.getUsedStrings());
            return true;
        }

        @Override
        public boolean visit(JsniMethodRef x, Context ctx) {
            for (JParameter param : x.getTarget().getParams()) {
                this.maybeRescueJavaScriptObjectPassingIntoJava(param.getType());
                this.rescue(param);
            }
            if (x.getTarget() instanceof JConstructor) {
                JConstructor ctor = (JConstructor)x.getTarget();
                this.rescue(ctor.getEnclosingType(), true);
            }
            return this.visit((JMethodCall)x, ctx);
        }

        @Override
        public boolean visit(JStringLiteral literal, Context ctx) {
            ControlFlowAnalyzer.this.liveStrings.add(literal.getValue());
            this.rescue(ControlFlowAnalyzer.this.program.getTypeJavaLangString(), true);
            return true;
        }

        @Override
        public boolean visit(JUnsafeTypeCoercion x, Context ctx) {
            this.rescueByTypeCoercion(x.getCoercionType(), x.getExpression().getType());
            return true;
        }

        private void rescueByTypeCoercion(JType targetType, JType expressionType) {
            if (!this.canBeInstantiatedInJavaScript(targetType)) {
                return;
            }
            this.rescue((JReferenceType)targetType, true);
            if (((ControlFlowAnalyzer)ControlFlowAnalyzer.this).program.typeOracle.isSingleJsoImpl(targetType) && (ControlFlowAnalyzer.this.program.getTypeJavaLangObject() == expressionType || ((ControlFlowAnalyzer)ControlFlowAnalyzer.this).program.typeOracle.canBeJavaScriptObject(expressionType))) {
                JClassType jsoImplementor = ((ControlFlowAnalyzer)ControlFlowAnalyzer.this).program.typeOracle.getSingleJsoImpl((JReferenceType)targetType);
                this.rescue(jsoImplementor, true);
            }
        }

        private boolean canBeInstantiatedInJavaScript(JType type) {
            if (((ControlFlowAnalyzer)ControlFlowAnalyzer.this).program.typeOracle.canBeJavaScriptObject(type) || ControlFlowAnalyzer.this.representedAsNativeTypesBySupertype.containsKey(type.getUnderlyingType())) {
                return true;
            }
            return type instanceof JArrayType;
        }

        private JMethod getStringValueOfCharMethod() {
            JPrimitiveType charType = ControlFlowAnalyzer.this.program.getTypePrimitiveChar();
            JClassType stringType = ControlFlowAnalyzer.this.program.getTypeJavaLangString();
            if (ControlFlowAnalyzer.this.stringValueOfChar != null) {
                return ControlFlowAnalyzer.this.stringValueOfChar;
            }
            for (JMethod method : stringType.getMethods()) {
                if (!method.getName().equals("valueOf") || method.getOriginalParamTypes().size() != 1 || method.getOriginalParamTypes().get(0) != charType) continue;
                ControlFlowAnalyzer.this.stringValueOfChar = method;
                return ControlFlowAnalyzer.this.stringValueOfChar;
            }
            assert (false);
            return null;
        }

        private boolean isStaticFieldInitializedToLiteral(JVariable var) {
            if (!(var instanceof JField)) {
                return false;
            }
            JField field = (JField)var;
            return field.isStatic() && field.getLiteralInitializer() != null;
        }

        private boolean isVolatileField(JExpression x) {
            if (!(x instanceof JFieldRef)) {
                return false;
            }
            JFieldRef xFieldRef = (JFieldRef)x;
            return xFieldRef.getField().isVolatile();
        }

        private void maybeRescueClassLiteral(JReferenceType type) {
            if (ControlFlowAnalyzer.this.liveFieldsAndMethods.contains(ControlFlowAnalyzer.this.getClassMethod) || ControlFlowAnalyzer.this.liveFieldsAndMethods.contains(ControlFlowAnalyzer.this.getClassField)) {
                this.rescue(ControlFlowAnalyzer.this.program.getClassLiteralField(type));
            } else {
                ControlFlowAnalyzer.this.classLiteralsToBeRescuedIfGetClassIsLive.add(type);
            }
        }

        private void maybeRescueJavaScriptObjectPassingIntoJava(JType type) {
            if (!this.canBeInstantiatedInJavaScript(type)) {
                return;
            }
            JReferenceType underlyingType = (JReferenceType)type.getUnderlyingType();
            for (JReferenceType representedAsNativeType : ControlFlowAnalyzer.this.representedAsNativeTypesBySupertype.get(underlyingType)) {
                this.rescue(representedAsNativeType, true);
            }
            this.rescue(underlyingType, true);
            if (((ControlFlowAnalyzer)ControlFlowAnalyzer.this).program.typeOracle.isSingleJsoImpl(type)) {
                JClassType singleJsoImpl = ((ControlFlowAnalyzer)ControlFlowAnalyzer.this).program.typeOracle.getSingleJsoImpl(underlyingType);
                this.rescue(singleJsoImpl, true);
            }
        }

        private void rescue(JMethod method) {
            if (method == null) {
                return;
            }
            if (ControlFlowAnalyzer.this.liveFieldsAndMethods.add(method)) {
                ControlFlowAnalyzer.this.membersToRescueIfTypeIsInstantiated.remove(method);
                if (ControlFlowAnalyzer.this.dependencyRecorder != null) {
                    this.curMethodStack.add(method);
                    ControlFlowAnalyzer.this.dependencyRecorder.methodIsLiveBecause(method, this.curMethodStack);
                }
                this.accept(method);
                if (ControlFlowAnalyzer.this.dependencyRecorder != null) {
                    this.curMethodStack.remove(this.curMethodStack.size() - 1);
                }
                if (method.isJsniMethod() || method.canBeImplementedExternally()) {
                    this.maybeRescueJavaScriptObjectPassingIntoJava(method.getType());
                }
                if (method.canBeReferencedExternally() || method.canBeImplementedExternally()) {
                    for (JParameter param : method.getParams()) {
                        if (method.canBeReferencedExternally()) {
                            this.maybeRescueJavaScriptObjectPassingIntoJava(param.getType());
                        }
                        this.rescue(param);
                        if (!param.isVarargs()) continue;
                        assert (method.isJsMethodVarargs());
                        JArrayType paramType = (JArrayType)param.getType().getUnderlyingType();
                        this.rescue(paramType, true);
                        this.rescue(ControlFlowAnalyzer.this.program.getClassLiteralField(paramType.getLeafType()));
                    }
                }
                this.rescueOverridingMethods(method);
                if (method == ControlFlowAnalyzer.this.getClassMethod) {
                    this.rescueClassLiteralsIfGetClassIsLive();
                }
                if (method.getSpecialization() != null) {
                    this.rescue(method.getSpecialization().getTargetMethod());
                }
            }
        }

        private void maybeRescueJsTypeArray(JType type) {
            if (!(type instanceof JArrayType)) {
                return;
            }
            JArrayType arrayType = (JArrayType)type;
            if (arrayType.canBeImplementedExternally()) {
                this.rescue(arrayType, true);
                this.maybeRescueJsTypeArray(arrayType.getElementType());
            }
        }

        private void rescue(JReferenceType type, boolean isInstantiated) {
            if (type == null) {
                return;
            }
            type = type.getUnderlyingType();
            boolean doVisit = false;
            if (isInstantiated && ControlFlowAnalyzer.this.instantiatedTypes.add(type)) {
                this.maybeRescueClassLiteral(type);
                doVisit = true;
            }
            if (ControlFlowAnalyzer.this.referencedTypes.add(type)) {
                doVisit = true;
            }
            if (!doVisit) {
                return;
            }
            this.accept(type);
            if (!(type instanceof JDeclaredType)) {
                return;
            }
            JDeclaredType declaredType = (JDeclaredType)type;
            for (JMethod method : declaredType.getMethods()) {
                if (!method.canBeReferencedExternally() && (!declaredType.isJsNative() || !method.isJsConstructor())) continue;
                this.rescue(method);
            }
            for (JField field : declaredType.getFields()) {
                if (!field.canBeReferencedExternally()) continue;
                this.rescue(field);
            }
        }

        private void rescue(JVariable var) {
            block8: {
                block6: {
                    JField field;
                    block7: {
                        if (var == null) {
                            return;
                        }
                        if (!ControlFlowAnalyzer.this.liveFieldsAndMethods.add(var)) {
                            return;
                        }
                        if (!(var instanceof JField)) break block6;
                        field = (JField)var;
                        ControlFlowAnalyzer.this.membersToRescueIfTypeIsInstantiated.remove(field);
                        if (field.canBeReferencedExternally() || field.canBeImplementedExternally()) {
                            this.maybeRescueJavaScriptObjectPassingIntoJava(field.getType());
                        }
                        if (field == ControlFlowAnalyzer.this.getClassField) {
                            this.rescueClassLiteralsIfGetClassIsLive();
                        }
                        if (!this.isStaticFieldInitializedToLiteral(field)) break block7;
                        this.accept(field.getLiteralInitializer());
                        break block8;
                    }
                    if (!ControlFlowAnalyzer.this.program.getTypeClassLiteralHolder().equals(field.getEnclosingType())) break block8;
                    this.accept(field.getInitializer());
                    ControlFlowAnalyzer.this.referencedTypes.add(field.getEnclosingType());
                    ControlFlowAnalyzer.this.liveFieldsAndMethods.add(field.getEnclosingType().getClinitMethod());
                    break block8;
                }
                if (var instanceof JParameter && ControlFlowAnalyzer.this.argumentsToRescueIfParameterRead != null) {
                    for (JExpression arg : ControlFlowAnalyzer.this.argumentsToRescueIfParameterRead.removeAll(var)) {
                        this.accept(arg);
                    }
                }
            }
        }

        private void rescueArgumentsIfParametersCanBeRead(JMethodCall call) {
            int i;
            JMethod method = call.getTarget();
            assert (!method.canBePolymorphic());
            List<JExpression> args = call.getArgs();
            List<JParameter> params = method.getParams();
            int c = params.size();
            for (i = 0; i < c; ++i) {
                JExpression arg = args.get(i);
                JParameter param = params.get(i);
                if (arg.hasSideEffects() || ControlFlowAnalyzer.this.liveFieldsAndMethods.contains(param)) {
                    this.accept(arg);
                    continue;
                }
                ControlFlowAnalyzer.this.argumentsToRescueIfParameterRead.put(param, arg);
            }
            c = args.size();
            while (i < c) {
                this.accept(args.get(i));
                ++i;
            }
        }

        private void rescueByConcat(JType type) {
            JPrimitiveType charType = ControlFlowAnalyzer.this.program.getTypePrimitiveChar();
            JClassType stringType = ControlFlowAnalyzer.this.program.getTypeJavaLangString();
            if (type instanceof JReferenceType && !((ControlFlowAnalyzer)ControlFlowAnalyzer.this).program.typeOracle.castSucceedsTrivially((JReferenceType)type, (JReferenceType)stringType) && !type.isNullType()) {
                JMethod toStringMethod = ControlFlowAnalyzer.this.program.getIndexedMethod("Object.toString");
                this.rescue(toStringMethod);
            } else if (type == charType) {
                this.rescue(this.getStringValueOfCharMethod());
            }
        }

        private void rescueClassLiteralsIfGetClassIsLive() {
            if (ControlFlowAnalyzer.this.classLiteralsToBeRescuedIfGetClassIsLive != null) {
                Set toRescue = ControlFlowAnalyzer.this.classLiteralsToBeRescuedIfGetClassIsLive;
                ControlFlowAnalyzer.this.classLiteralsToBeRescuedIfGetClassIsLive = null;
                for (JReferenceType classLit : toRescue) {
                    this.maybeRescueClassLiteral(classLit);
                }
            }
        }

        private void rescueMembersAndInstantiateSuperInterfaces(JDeclaredType type) {
            for (JInterfaceType intfType : type.getImplements()) {
                this.rescue(intfType, true);
            }
            this.rescueMembers(type);
        }

        private void rescueMembers(JDeclaredType type) {
            assert (ControlFlowAnalyzer.this.instantiatedTypes.contains(type));
            for (JMethod method : type.getMethods()) {
                if (method.isStatic() || !ControlFlowAnalyzer.this.membersToRescueIfTypeIsInstantiated.contains(method)) continue;
                this.rescue(method);
            }
            for (JField field : type.getFields()) {
                if (field.isStatic() || !ControlFlowAnalyzer.this.membersToRescueIfTypeIsInstantiated.contains(field)) continue;
                this.rescue(field);
            }
        }

        private void rescueOverridingMethods(JMethod method) {
            if (method.isStatic()) {
                return;
            }
            for (JMethod overridingMethod : method.getOverridingMethods()) {
                if (ControlFlowAnalyzer.this.liveFieldsAndMethods.contains(overridingMethod)) continue;
                if (ControlFlowAnalyzer.this.instantiatedTypes.contains(overridingMethod.getEnclosingType())) {
                    this.rescue(overridingMethod);
                    continue;
                }
                ControlFlowAnalyzer.this.membersToRescueIfTypeIsInstantiated.add(overridingMethod);
            }
        }
    }

    public static interface DependencyRecorder {
        public void methodIsLiveBecause(JMethod var1, List<JMethod> var2);
    }
}

