/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JParameterRef;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JThisRef;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.Set;

public class ComputePotentiallyObservableUninitializedValues {
    private static final String NAME = ComputePotentiallyObservableUninitializedValues.class.getSimpleName();
    private final JProgram program;
    private final Set<JType> classesWhoseFieldsCanBeObservedUninitialized = Sets.newHashSet();

    private ComputePotentiallyObservableUninitializedValues(JProgram program) {
        this.program = program;
    }

    public static Predicate<JField> analyze(JProgram program) {
        return new ComputePotentiallyObservableUninitializedValues(program).analyzeImpl();
    }

    private Predicate<JField> analyzeImpl() {
        SpeedTracerLogger.Event optimizeEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE, "optimizer", NAME);
        CanObserveSubclassUninitializedFieldsVisitor visitor = new CanObserveSubclassUninitializedFieldsVisitor();
        visitor.accept(this.program);
        Set classesThatCanPotentiallyObserveUninitializedSubclassFields = visitor.classesThatCanPotentiallyObserveUninitializedSubclassFields;
        for (JType type : classesThatCanPotentiallyObserveUninitializedSubclassFields) {
            if (this.classesWhoseFieldsCanBeObservedUninitialized.contains(type)) continue;
            this.classesWhoseFieldsCanBeObservedUninitialized.addAll(this.program.getSubclasses(type));
        }
        optimizeEvent.end(new String[0]);
        return new Predicate<JField>(){

            @Override
            public boolean apply(JField field) {
                return ComputePotentiallyObservableUninitializedValues.this.isUninitializedValueObservable(field);
            }
        };
    }

    private boolean isUninitializedValueObservable(JField x) {
        if (x.getLiteralInitializer() != null && (x.isFinal() || x.isStatic())) {
            return false;
        }
        if (x.isStatic()) {
            return true;
        }
        return this.classesWhoseFieldsCanBeObservedUninitialized.contains(x.getEnclosingType());
    }

    private class CanObserveSubclassUninitializedFieldsVisitor
    extends JVisitor {
        private JClassType currentClass;
        private JParameter devirtualizedThis;
        private Set<JType> classesThatCanPotentiallyObserveUninitializedSubclassFields = Sets.newHashSet();

        private CanObserveSubclassUninitializedFieldsVisitor() {
        }

        @Override
        public void endVisit(JClassType x, Context ctx) {
            assert (this.currentClass == x);
            this.currentClass = null;
        }

        @Override
        public void endVisit(JConstructor x, Context ctx) {
            assert (this.currentClass == x.getEnclosingType());
            assert (this.devirtualizedThis == null);
        }

        @Override
        public void endVisit(JMethod x, Context ctx) {
            assert (this.currentClass == x.getEnclosingType());
            this.devirtualizedThis = null;
        }

        @Override
        public void endVisit(JThisRef x, Context ctx) {
            this.classesThatCanPotentiallyObserveUninitializedSubclassFields.add(this.currentClass);
        }

        @Override
        public void endVisit(JParameterRef x, Context ctx) {
            if (x.getParameter() == this.devirtualizedThis) {
                this.classesThatCanPotentiallyObserveUninitializedSubclassFields.add(this.currentClass);
            }
        }

        @Override
        public boolean visit(JClassType x, Context ctx) {
            assert (this.currentClass == null);
            this.currentClass = x;
            return true;
        }

        @Override
        public boolean visit(JConstructor x, Context ctx) {
            assert (this.currentClass == x.getEnclosingType());
            return true;
        }

        @Override
        public boolean visit(JFieldRef x, Context ctx) {
            return !this.isFieldReferenceThroughThis(x) || !this.isFieldDeclaredInCurrentClassOrSuper(x);
        }

        @Override
        public boolean visit(JInterfaceType x, Context ctx) {
            return false;
        }

        @Override
        public boolean visit(JMethod x, Context ctx) {
            assert (this.currentClass == x.getEnclosingType());
            if (this.isInitMethod(x)) {
                return true;
            }
            if (this.isDevirtualizedInitMethod(x) && x.getParams().size() > 0 && x.getParams().get(0).getType() == this.currentClass) {
                this.devirtualizedThis = x.getParams().get(0);
            }
            return false;
        }

        @Override
        public boolean visit(JMethodCall x, Context ctx) {
            assert (this.currentClass != null);
            if (x.getTarget().isConstructor() && x.getInstance() instanceof JThisRef || this.isInitMethod(x.getTarget())) {
                this.accept(x.getArgs());
                return false;
            }
            if (this.isDevirtualizedInitMethod(x.getTarget()) && x.getArgs().size() > 0 && x.getArgs().get(0) instanceof JThisRef) {
                this.accept(x.getArgs().subList(1, x.getArgs().size()));
                return false;
            }
            if (!x.getTarget().isStatic() && !x.getTarget().isFinal() && x.getInstance() instanceof JThisRef) {
                this.classesThatCanPotentiallyObserveUninitializedSubclassFields.add(this.currentClass);
                return false;
            }
            return true;
        }

        private boolean isDevirtualizedInitMethod(JMethod method) {
            return method.isStatic() && method.getName().equals("$$init") && method.getEnclosingType() == this.currentClass;
        }

        private boolean isInitMethod(JMethod method) {
            return !method.isStatic() && method.getName().equals("$init") && method.getEnclosingType() == this.currentClass;
        }

        private boolean isFieldReferenceThroughThis(JFieldRef x) {
            return x.getInstance() instanceof JThisRef || x.getInstance() instanceof JParameterRef && ((JParameterRef)x.getInstance()).getParameter() == this.devirtualizedThis;
        }

        private boolean isFieldDeclaredInCurrentClassOrSuper(JFieldRef x) {
            JClassType enclosingClass = (JClassType)x.getField().getEnclosingType();
            return this.currentClass == enclosingClass || ((ComputePotentiallyObservableUninitializedValues)ComputePotentiallyObservableUninitializedValues.this).program.typeOracle.isSuperClass(enclosingClass, this.currentClass);
        }
    }
}

