/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.base.Predicates;
import com.google.gwt.thirdparty.guava.common.collect.FluentIterable;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.LinkedHashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class ComputeOverridesAndImplementDefaultMethods {
    private final Map<JType, Map<String, JMethod>> polymorphicMethodsByExtendedSignatureByType = Maps.newLinkedHashMap();
    private final Map<JMethod, JMethod> defaultMethodsByForwardingMethod = Maps.newHashMap();
    private final List<JMethod> newStubMethods = Lists.newArrayList();

    public List<JMethod> exec(JProgram program) {
        for (JDeclaredType type : program.getDeclaredTypes()) {
            this.computeOverrides(type);
        }
        return this.newStubMethods;
    }

    private void computeOverrides(JDeclaredType type) {
        if (type == null || this.polymorphicMethodsByExtendedSignatureByType.containsKey(type)) {
            return;
        }
        JClassType superClass = type.getSuperClass();
        this.computeOverrides(superClass);
        for (JInterfaceType jInterfaceType : type.getImplements()) {
            this.computeOverrides(jInterfaceType);
        }
        LinkedHashMap<String, JMethod> polymorphicMethodsByExtendedSignature = Maps.newLinkedHashMap();
        this.polymorphicMethodsByExtendedSignatureByType.put(type, polymorphicMethodsByExtendedSignature);
        if (this.polymorphicMethodsByExtendedSignatureByType.containsKey(type.getSuperClass())) {
            polymorphicMethodsByExtendedSignature.putAll(this.polymorphicMethodsByExtendedSignatureByType.get(type.getSuperClass()));
        }
        for (JMethod method : type.getMethods()) {
            String extendedSignature = ComputeOverridesAndImplementDefaultMethods.computeExtendedSignature(method);
            if (extendedSignature == null) continue;
            JMethod overriddenMethod = (JMethod)polymorphicMethodsByExtendedSignature.get(extendedSignature);
            if (overriddenMethod == null) {
                this.maybeAddPublicOverrideToPackagePrivateMethod(method);
            } else {
                ComputeOverridesAndImplementDefaultMethods.addOverridingMethod(overriddenMethod, method);
            }
            polymorphicMethodsByExtendedSignature.put(extendedSignature, method);
        }
        Multimap<String, JMethod> multimap = this.collectMostSpecificSuperInterfaceMethodsBySignature(type);
        for (String signature : multimap.keySet()) {
            Collection<JMethod> interfaceMethods = multimap.get(signature);
            JMethod implementingMethod = (JMethod)polymorphicMethodsByExtendedSignature.get(signature);
            if (implementingMethod == null) {
                implementingMethod = (JMethod)polymorphicMethodsByExtendedSignature.get(ComputeOverridesAndImplementDefaultMethods.computePackagePrivateSignature(type.getPackageName(), signature));
            }
            if (implementingMethod == null || implementingMethod.getEnclosingType() != type) {
                if ((implementingMethod = this.maybeAddSyntheticOverride(type, implementingMethod, interfaceMethods)) == null) {
                    assert (type instanceof JInterfaceType);
                    assert (interfaceMethods.size() == 1);
                    polymorphicMethodsByExtendedSignature.put(signature, interfaceMethods.iterator().next());
                    continue;
                }
                this.newStubMethods.add(implementingMethod);
            }
            if (implementingMethod.getEnclosingType() != type) continue;
            for (JMethod interfaceMethod : interfaceMethods) {
                ComputeOverridesAndImplementDefaultMethods.addOverridingMethod(interfaceMethod, implementingMethod);
            }
        }
    }

    private void maybeAddPublicOverrideToPackagePrivateMethod(JMethod method) {
        String packagePrivateSignature;
        if (method.isPackagePrivate()) {
            return;
        }
        Map<String, JMethod> polymorphicMethodsByExtendedSignature = this.polymorphicMethodsByExtendedSignatureByType.get(method.getEnclosingType());
        JMethod packagePrivateOverriddenMethod = polymorphicMethodsByExtendedSignature.get(packagePrivateSignature = ComputeOverridesAndImplementDefaultMethods.computePackagePrivateSignature(method));
        if (packagePrivateOverriddenMethod != null) {
            ComputeOverridesAndImplementDefaultMethods.addOverridingMethod(packagePrivateOverriddenMethod, method);
            polymorphicMethodsByExtendedSignature.put(packagePrivateSignature, method);
        }
    }

    private static void addOverridingMethod(JMethod overriddenMethod, JMethod overridingMethod) {
        assert (overriddenMethod != overridingMethod) : overriddenMethod + " can not override itself";
        overridingMethod.addOverriddenMethod(overriddenMethod);
        overriddenMethod.addOverridingMethod(overridingMethod);
        for (JMethod transitivelyOverriddenMethod : overriddenMethod.getOverriddenMethods()) {
            overridingMethod.addOverriddenMethod(transitivelyOverriddenMethod);
            transitivelyOverriddenMethod.addOverridingMethod(overridingMethod);
        }
    }

    private static String computeExtendedSignature(JMethod method) {
        if (!method.canBePolymorphic()) {
            return null;
        }
        if (method.isPackagePrivate()) {
            return ComputeOverridesAndImplementDefaultMethods.computePackagePrivateSignature(method);
        }
        return method.getSignature();
    }

    private static String computePackagePrivateSignature(JMethod method) {
        String packageName = method.getEnclosingType().getPackageName();
        return ComputeOverridesAndImplementDefaultMethods.computePackagePrivateSignature(packageName, method.getSignature());
    }

    private static String computePackagePrivateSignature(String packageName, String publicSignature) {
        return StringInterner.get().intern(packageName + "." + publicSignature);
    }

    private JMethod maybeAddSyntheticOverride(JDeclaredType type, JMethod superMethod, Collection<JMethod> interfaceMethods) {
        JMethod interfaceMethod = interfaceMethods.iterator().next();
        assert (!interfaceMethod.isStatic());
        JMethod implementingMethod = superMethod;
        if (this.needsDefaultImplementationStubMethod(type, superMethod, interfaceMethod)) {
            assert (FluentIterable.from(interfaceMethods).filter(new Predicate<JMethod>(){

                @Override
                public boolean apply(JMethod jMethod) {
                    return jMethod.isDefaultMethod();
                }
            }).size() == 1) : "Ambiguous default method resolution for class " + type.getName() + " conflicting methods " + Iterables.toString(FluentIterable.from(interfaceMethods).filter(new Predicate<JMethod>(){

                @Override
                public boolean apply(JMethod jMethod) {
                    return jMethod.isDefaultMethod();
                }
            }));
            implementingMethod = JjsUtils.createForwardingMethod(type, interfaceMethod);
            this.defaultMethodsByForwardingMethod.put(implementingMethod, interfaceMethod);
        } else if (superMethod == null && interfaceMethod.isAbstract() && (type instanceof JClassType || interfaceMethods.size() > 1)) {
            implementingMethod = JjsUtils.createSyntheticAbstractStub(type, interfaceMethod);
        } else if (type instanceof JClassType && superMethod.getEnclosingType() != type && !FluentIterable.from(interfaceMethods).allMatch(Predicates.in(superMethod.getOverriddenMethods()))) {
            if (superMethod.isAbstract()) {
                implementingMethod = JjsUtils.createSyntheticAbstractStub(type, interfaceMethod);
            } else {
                implementingMethod = JjsUtils.createForwardingMethod(type, superMethod);
                implementingMethod.setSyntheticAccidentalOverride();
                if (superMethod.isFinal()) {
                    superMethod.setFinal(false);
                }
            }
        }
        if (implementingMethod != null) {
            this.polymorphicMethodsByExtendedSignatureByType.get(type).put(implementingMethod.getSignature(), implementingMethod);
            if (superMethod != null && superMethod != implementingMethod) {
                ComputeOverridesAndImplementDefaultMethods.addOverridingMethod(superMethod, implementingMethod);
            }
        }
        return implementingMethod;
    }

    private boolean needsDefaultImplementationStubMethod(JDeclaredType type, JMethod superMethod, JMethod interfaceMethod) {
        if (!interfaceMethod.isDefaultMethod() || type instanceof JInterfaceType) {
            return false;
        }
        if (superMethod == null || superMethod.isAbstract() && superMethod.isSynthetic()) {
            return true;
        }
        JMethod superForwardingMethod = this.defaultMethodsByForwardingMethod.get(superMethod);
        return superForwardingMethod != null && superForwardingMethod.isDefaultMethod() && superForwardingMethod != interfaceMethod;
    }

    private Multimap<String, JMethod> collectMostSpecificSuperInterfaceMethodsBySignature(JDeclaredType type) {
        LinkedHashMultimap<String, JMethod> interfaceMethodsBySignature = LinkedHashMultimap.create();
        this.collectAllSuperInterfaceMethodsBySignature(type, interfaceMethodsBySignature);
        ArrayList<String> signatures = Lists.newArrayList(interfaceMethodsBySignature.keySet());
        for (String signature : signatures) {
            Collection allMethods = interfaceMethodsBySignature.get(signature);
            AbstractSet notOverriddenMethods = Sets.newLinkedHashSet(allMethods);
            for (JMethod method : allMethods) {
                notOverriddenMethods = Sets.difference(notOverriddenMethods, method.getOverriddenMethods());
            }
            ImmutableSet<JMethod> defaultMethods = FluentIterable.from(notOverriddenMethods).filter(new Predicate<JMethod>(){

                @Override
                public boolean apply(JMethod method) {
                    return method.isDefaultMethod();
                }
            }).toSet();
            LinkedHashSet<JMethod> leafMethods = Sets.newLinkedHashSet(defaultMethods);
            leafMethods.addAll(notOverriddenMethods);
            interfaceMethodsBySignature.replaceValues(signature, leafMethods);
        }
        return interfaceMethodsBySignature;
    }

    private void collectAllSuperInterfaceMethodsBySignature(JDeclaredType type, Multimap<String, JMethod> methodsBySignature) {
        for (JDeclaredType jDeclaredType : type.getImplements()) {
            for (JMethod method : this.polymorphicMethodsByExtendedSignatureByType.get(jDeclaredType).values()) {
                methodsBySignature.put(ComputeOverridesAndImplementDefaultMethods.computeExtendedSignature(method), method);
            }
        }
    }
}

