/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JCastMap;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.util.Map;

public class ComputeExhaustiveCastabilityInformation {
    private final Map<JReferenceType, JCastMap> castMaps = Maps.newIdentityHashMap();
    private final JProgram program;

    public static void exec(JProgram program) {
        new ComputeExhaustiveCastabilityInformation(program).execImpl();
    }

    private ComputeExhaustiveCastabilityInformation(JProgram program) {
        this.program = program;
    }

    private void createCompleteCastMap(JReferenceType sourceType) {
        this.castMaps.put(sourceType, new JCastMap(SourceOrigin.UNKNOWN, this.program.getTypeJavaLangObject(), this.program.typeOracle.getCastableDestinationTypes(sourceType)));
    }

    private void execImpl() {
        for (JDeclaredType declaredType : this.program.getModuleDeclaredTypes()) {
            this.createCompleteCastMap(declaredType);
        }
        for (JArrayType arrayType : this.program.getAllArrayTypes()) {
            if (!this.program.typeOracle.isInstantiatedType(arrayType)) continue;
            this.createCompleteCastMap(arrayType);
        }
        this.program.initTypeInfo(this.castMaps);
    }
}

