/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.HasName;
import com.google.gwt.dev.jjs.ast.JArrayRef;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JCastMap;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JInstanceOf;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JTypeOracle;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.thirdparty.guava.common.collect.HashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ComputeCastabilityInformation {
    private final boolean recordTrivialCasts;
    private final JProgram program;
    private final JTypeOracle typeOracle;

    public static void exec(JProgram program, boolean recordTrivialCasts) {
        new ComputeCastabilityInformation(program, recordTrivialCasts).execImpl();
    }

    public static void exec(JProgram program) {
        new ComputeCastabilityInformation(program, false).execImpl();
    }

    private ComputeCastabilityInformation(JProgram program, boolean recordTrivialCasts) {
        this.program = program;
        this.typeOracle = program.typeOracle;
        this.recordTrivialCasts = recordTrivialCasts;
    }

    private void execImpl() {
        AssignTypeCastabilityVisitor assigner = new AssignTypeCastabilityVisitor();
        assigner.accept(this.program);
        assigner.computeTypeCastabilityMaps();
    }

    private class AssignTypeCastabilityVisitor
    extends JVisitor {
        private final Set<JReferenceType> alreadyRan = Sets.newHashSet();
        private final Map<JReferenceType, JCastMap> castableTypesMap = Maps.newIdentityHashMap();
        private final List<JArrayType> instantiatedArrayTypes = Lists.newArrayList();
        private final Multimap<JReferenceType, JReferenceType> castSourceTypesPerCastTargetType = HashMultimap.create();

        private AssignTypeCastabilityVisitor() {
            for (JArrayType arrayType : ComputeCastabilityInformation.this.program.getAllArrayTypes()) {
                if (!ComputeCastabilityInformation.this.typeOracle.isInstantiatedType(arrayType)) continue;
                this.instantiatedArrayTypes.add(arrayType);
            }
            this.recordCastInternal(ComputeCastabilityInformation.this.program.getTypeJavaLangObject(), ComputeCastabilityInformation.this.program.getTypeJavaLangObject());
            this.recordCastInternal(ComputeCastabilityInformation.this.program.getTypeJavaLangString(), ComputeCastabilityInformation.this.program.getTypeJavaLangObject());
            this.recordCastInternal(ComputeCastabilityInformation.this.program.getIndexedType("Serializable"), ComputeCastabilityInformation.this.program.getTypeJavaLangObject());
            this.recordCastInternal(ComputeCastabilityInformation.this.program.getIndexedType("CharSequence"), ComputeCastabilityInformation.this.program.getTypeJavaLangObject());
            this.recordCastInternal(ComputeCastabilityInformation.this.program.getIndexedType("Comparable"), ComputeCastabilityInformation.this.program.getTypeJavaLangObject());
        }

        public void computeTypeCastabilityMaps() {
            this.computeCastMap(ComputeCastabilityInformation.this.program.getTypeJavaLangString());
            assert (this.castableTypesMap.size() == 2);
            for (JReferenceType jReferenceType : ComputeCastabilityInformation.this.program.getDeclaredTypes()) {
                if (!(jReferenceType instanceof JClassType)) continue;
                this.computeCastMap(jReferenceType);
            }
            for (JArrayType jArrayType : this.instantiatedArrayTypes) {
                this.computeCastMap(jArrayType);
            }
            ComputeCastabilityInformation.this.program.initTypeInfo(this.castableTypesMap);
        }

        @Override
        public void endVisit(JBinaryOperation x, Context ctx) {
            if (!x.getOp().isAssignment() || !(x.getLhs() instanceof JArrayRef)) {
                return;
            }
            JArrayRef lhsArrayRef = (JArrayRef)x.getLhs();
            JType elementType = lhsArrayRef.getType();
            if (elementType.isNullType()) {
                return;
            }
            if (!(elementType instanceof JReferenceType)) {
                return;
            }
            if (!lhsArrayRef.getInstance().getType().canBeSubclass()) {
                return;
            }
            JType rhsType = x.getRhs().getType();
            assert (rhsType instanceof JReferenceType);
            JArrayType lhsArrayType = lhsArrayRef.getArrayType();
            for (JArrayType arrayType : this.instantiatedArrayTypes) {
                JType itElementType;
                if (ComputeCastabilityInformation.this.typeOracle.castFailsTrivially(arrayType, lhsArrayType) || !((itElementType = arrayType.getElementType()) instanceof JReferenceType)) continue;
                this.recordCast(itElementType, x.getRhs());
            }
        }

        @Override
        public void endVisit(JCastOperation x, Context ctx) {
            if (x.getCastType().isNullType()) {
                return;
            }
            this.recordCast(x.getCastType(), x.getExpr());
        }

        @Override
        public void endVisit(JInstanceOf x, Context ctx) {
            assert (!x.getTestType().isNullType());
            this.recordCast(x.getTestType(), x.getExpr());
        }

        private boolean castSucceedsTriviallyJsoSemantics(JReferenceType fromType, JReferenceType toType) {
            fromType = fromType.getUnderlyingType();
            toType = toType.getUnderlyingType();
            if (ComputeCastabilityInformation.this.typeOracle.castSucceedsTrivially(fromType, toType)) {
                return true;
            }
            if (toType.isJsNative()) {
                return true;
            }
            if (fromType instanceof JArrayType && toType instanceof JArrayType) {
                JArrayType fromArrayType = (JArrayType)fromType;
                JArrayType toArrayType = (JArrayType)toType;
                return fromArrayType.getLeafType().isJsoType() && toArrayType.getLeafType().isJsoType();
            }
            return fromType.isJsoType() && toType.isJsoType();
        }

        private void computeCastMap(JReferenceType type) {
            if (type == null || this.alreadyRan.contains(type)) {
                return;
            }
            assert (type == type.getUnderlyingType());
            this.alreadyRan.add(type);
            if (type instanceof JClassType) {
                this.computeCastMap(((JClassType)type).getSuperClass());
            }
            if (!ComputeCastabilityInformation.this.typeOracle.isInstantiatedType(type) || type.isJsoType() || type.isJsNative()) {
                return;
            }
            TreeSet<HasName> castableTypes = Sets.newTreeSet(HasName.BY_NAME_COMPARATOR);
            block0: for (JReferenceType castTargetType : this.castSourceTypesPerCastTargetType.keySet()) {
                if (!this.castSucceedsTriviallyJsoSemantics(type, castTargetType)) continue;
                Collection<JReferenceType> castSourceTypes = this.castSourceTypesPerCastTargetType.get(castTargetType);
                for (JReferenceType castSourceType : castSourceTypes) {
                    boolean isTrivialCast;
                    if (!this.castSucceedsTriviallyJsoSemantics(type, castSourceType)) continue;
                    boolean bl = isTrivialCast = castTargetType == ComputeCastabilityInformation.this.program.getTypeJavaLangObject() || castTargetType == ComputeCastabilityInformation.this.program.getJavaScriptObject();
                    if (!ComputeCastabilityInformation.this.recordTrivialCasts && isTrivialCast) continue block0;
                    castableTypes.add(castTargetType);
                    continue block0;
                }
            }
            if (castableTypes.isEmpty() && type != ComputeCastabilityInformation.this.program.getTypeJavaLangObject() && type != ComputeCastabilityInformation.this.program.getTypeJavaLangString()) {
                return;
            }
            this.castableTypesMap.put(type, new JCastMap(SourceOrigin.UNKNOWN, ComputeCastabilityInformation.this.program.getTypeJavaLangObject(), Collections.unmodifiableSet(castableTypes)));
        }

        private void recordCast(JType targetType, JExpression rhs) {
            if (!(targetType instanceof JReferenceType) || targetType.isJsNative()) {
                return;
            }
            targetType = targetType.getUnderlyingType();
            assert (rhs.getType() instanceof JReferenceType);
            JReferenceType rhsType = (JReferenceType)rhs.getType().getUnderlyingType();
            if (!ComputeCastabilityInformation.this.recordTrivialCasts && ComputeCastabilityInformation.this.typeOracle.castSucceedsTrivially(rhsType, (JReferenceType)targetType)) {
                return;
            }
            if (!ComputeCastabilityInformation.this.recordTrivialCasts && targetType.isJsoType()) {
                return;
            }
            this.recordCastInternal((JReferenceType)targetType, rhsType);
        }

        private void recordCastInternal(JReferenceType toType, JReferenceType rhsType) {
            toType = toType.getUnderlyingType();
            rhsType = rhsType.getUnderlyingType();
            if (toType instanceof JArrayType) {
                toType = (JReferenceType)ComputeCastabilityInformation.this.program.normalizeJsoType(toType);
            }
            this.castSourceTypesPerCastTargetType.put(toType, rhsType);
        }
    }
}

