/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JArrayRef;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JIntLiteral;
import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JLocalRef;
import com.google.gwt.dev.jjs.ast.JLongLiteral;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JParameterRef;
import com.google.gwt.dev.jjs.ast.JPostfixOperation;
import com.google.gwt.dev.jjs.ast.JPrefixOperation;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JThisRef;
import com.google.gwt.dev.jjs.ast.JUnaryOperator;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.js.JMultiExpression;
import com.google.gwt.dev.jjs.impl.CloneExpressionVisitor;
import com.google.gwt.dev.jjs.impl.JModVisitorWithTemporaryVariableCreation;
import com.google.gwt.dev.jjs.impl.OptimizerContext;

public abstract class CompoundAssignmentNormalizer {
    private final CloneExpressionVisitor cloner = new CloneExpressionVisitor();
    private static final String TEMP_LOCAL_NAME = "$tmp";

    public void accept(JNode node) {
        BreakupAssignOpsVisitor breaker = new BreakupAssignOpsVisitor(OptimizerContext.NULL_OPTIMIZATION_CONTEXT);
        breaker.accept(node);
    }

    protected JExpression expressionToReturn(JExpression lhs) {
        return lhs;
    }

    protected JExpression modifyResultOperation(JBinaryOperation op) {
        return op;
    }

    protected abstract boolean shouldBreakUp(JBinaryOperation var1);

    protected abstract boolean shouldBreakUp(JPostfixOperation var1);

    protected abstract boolean shouldBreakUp(JPrefixOperation var1);

    private class BreakupAssignOpsVisitor
    extends JModVisitorWithTemporaryVariableCreation {
        public BreakupAssignOpsVisitor(OptimizerContext optimizerCtx) {
            super(optimizerCtx);
        }

        @Override
        public void endVisit(JBinaryOperation x, Context ctx) {
            JBinaryOperator op = x.getOp();
            if (op.getNonAssignmentOf() == null) {
                return;
            }
            if (!CompoundAssignmentNormalizer.this.shouldBreakUp(x)) {
                return;
            }
            ReplaceSideEffectsInLvalue replacer = new ReplaceSideEffectsInLvalue(new JMultiExpression(x.getSourceInfo(), new JExpression[0]));
            JExpression newLhs = replacer.accept(x.getLhs());
            JExpression operation = new JBinaryOperation(x.getSourceInfo(), newLhs.getType(), op.getNonAssignmentOf(), newLhs, x.getRhs());
            operation = CompoundAssignmentNormalizer.this.modifyResultOperation((JBinaryOperation)operation);
            JBinaryOperation asg = new JBinaryOperation(x.getSourceInfo(), newLhs.getType(), JBinaryOperator.ASG, CompoundAssignmentNormalizer.this.cloner.cloneExpression(newLhs), operation);
            JMultiExpression multiExpr = replacer.getMultiExpr();
            if (multiExpr.isEmpty()) {
                ctx.replaceMe(asg);
            } else {
                multiExpr.addExpressions(asg);
                ctx.replaceMe(multiExpr);
            }
        }

        @Override
        public void endVisit(JPostfixOperation x, Context ctx) {
            JUnaryOperator op = x.getOp();
            if (!op.isModifying()) {
                return;
            }
            if (!CompoundAssignmentNormalizer.this.shouldBreakUp(x)) {
                return;
            }
            JMultiExpression multi = new JMultiExpression(x.getSourceInfo(), new JExpression[0]);
            ReplaceSideEffectsInLvalue replacer = new ReplaceSideEffectsInLvalue(multi);
            JExpression newArg = replacer.accept(x.getArg());
            JExpression expressionReturn = CompoundAssignmentNormalizer.this.expressionToReturn(newArg);
            JLocal tempLocal = this.createTempLocal(x.getSourceInfo(), expressionReturn.getType(), CompoundAssignmentNormalizer.TEMP_LOCAL_NAME);
            JLocalRef tempRef = tempLocal.makeRef(x.getSourceInfo());
            JBinaryOperation asg = new JBinaryOperation(x.getSourceInfo(), x.getType(), JBinaryOperator.ASG, tempRef, expressionReturn);
            multi.addExpressions(asg);
            asg = this.createAsgOpFromUnary(newArg, op);
            multi.addExpressions(this.accept(asg));
            tempRef = tempLocal.makeRef(x.getSourceInfo());
            multi.addExpressions(tempRef);
            ctx.replaceMe(multi);
        }

        @Override
        public void endVisit(JPrefixOperation x, Context ctx) {
            JUnaryOperator op = x.getOp();
            if (!op.isModifying()) {
                return;
            }
            if (!CompoundAssignmentNormalizer.this.shouldBreakUp(x)) {
                return;
            }
            JBinaryOperation asg = this.createAsgOpFromUnary(x.getArg(), op);
            ctx.replaceMe(this.accept(asg));
        }

        private JBinaryOperation createAsgOpFromUnary(JExpression arg, JUnaryOperator op) {
            JBinaryOperator newOp;
            if (op == JUnaryOperator.INC) {
                newOp = JBinaryOperator.ASG_ADD;
            } else if (op == JUnaryOperator.DEC) {
                newOp = JBinaryOperator.ASG_SUB;
            } else {
                throw new InternalCompilerException("Unexpected modifying unary operator: " + String.valueOf(op.getSymbol()));
            }
            JValueLiteral one = arg.getType() == JPrimitiveType.LONG ? JLongLiteral.get(1L) : JIntLiteral.get(1);
            JBinaryOperation asg = new JBinaryOperation(arg.getSourceInfo(), arg.getType(), newOp, CompoundAssignmentNormalizer.this.cloner.cloneExpression(arg), one);
            return asg;
        }

        private class ReplaceSideEffectsInLvalue
        extends JModVisitor {
            private final JMultiExpression multi;

            ReplaceSideEffectsInLvalue(JMultiExpression multi) {
                this.multi = multi;
            }

            public JMultiExpression getMultiExpr() {
                return this.multi;
            }

            @Override
            public boolean visit(JArrayRef x, Context ctx) {
                JExpression newInstance = this.possiblyReplace(x.getInstance());
                JExpression newIndexExpr = this.possiblyReplace(x.getIndexExpr());
                if (newInstance != x.getInstance() || newIndexExpr != x.getIndexExpr()) {
                    JArrayRef newExpr = new JArrayRef(x.getSourceInfo(), newInstance, newIndexExpr);
                    ctx.replaceMe(newExpr);
                }
                return false;
            }

            @Override
            public boolean visit(JFieldRef x, Context ctx) {
                JExpression newInstance;
                if (x.getInstance() != null && (newInstance = this.possiblyReplace(x.getInstance())) != x.getInstance()) {
                    JFieldRef newExpr = new JFieldRef(x.getSourceInfo(), newInstance, x.getField(), x.getEnclosingType());
                    ctx.replaceMe(newExpr);
                }
                return false;
            }

            @Override
            public boolean visit(JLocalRef x, Context ctx) {
                return false;
            }

            @Override
            public boolean visit(JParameterRef x, Context ctx) {
                return false;
            }

            @Override
            public boolean visit(JThisRef x, Context ctx) {
                return false;
            }

            private JExpression possiblyReplace(JExpression x) {
                if (!x.hasSideEffects()) {
                    return x;
                }
                JLocal tempLocal = BreakupAssignOpsVisitor.this.createTempLocal(x.getSourceInfo(), x.getType(), CompoundAssignmentNormalizer.TEMP_LOCAL_NAME);
                JLocalRef tempRef = tempLocal.makeRef(x.getSourceInfo());
                JBinaryOperation asg = new JBinaryOperation(x.getSourceInfo(), x.getType(), JBinaryOperator.ASG, tempRef, x);
                this.multi.addExpressions(asg);
                return CompoundAssignmentNormalizer.this.cloner.cloneExpression(tempRef);
            }
        }
    }
}

