/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.impl.CloneExpressionVisitor;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import java.util.Map;

public class CompileTimeConstantsReplacer {
    public static void exec(JProgram program) {
        new CompileTimeConstantsReplacingVisitor(program).accept(program);
    }

    private static class CompileTimeConstantsReplacingVisitor
    extends JModVisitor {
        private final Map<JField, JExpression> resolveValuesByField = Maps.newIdentityHashMap();
        private final JProgram program;

        @Override
        public void endVisit(JFieldRef x, Context ctx) {
            JField field = x.getField();
            if (field.isCompileTimeConstant() && !ctx.isLvalue()) {
                ctx.replaceMe(this.resolveFieldValue(field));
            }
        }

        private JExpression resolveFieldValue(JField field) {
            JExpression value = this.resolveValuesByField.get(field);
            if (value != null) {
                return new CloneExpressionVisitor().cloneExpression(value);
            }
            value = this.accept(new CloneExpressionVisitor().cloneExpression(field.getInitializer()));
            JType fieldType = field.getType().getUnderlyingType();
            assert (fieldType.isPrimitiveType() || fieldType == this.program.getTypeJavaLangString()) : fieldType.getName() + " is not a primitive nor String";
            if (fieldType != value.getType()) {
                value = new JCastOperation(value.getSourceInfo(), fieldType, value);
            }
            this.resolveValuesByField.put(field, value);
            return value;
        }

        private CompileTimeConstantsReplacingVisitor(JProgram program) {
            this.program = program;
        }
    }
}

