/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.javac.JsInteropUtil;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.HasName;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JMember;
import com.google.gwt.dev.jjs.impl.JsInteropExportsGenerator;
import com.google.gwt.dev.js.JsUtils;
import com.google.gwt.dev.js.ast.JsExpression;
import com.google.gwt.dev.js.ast.JsInvocation;
import com.google.gwt.dev.js.ast.JsName;
import com.google.gwt.dev.js.ast.JsNameRef;
import com.google.gwt.dev.js.ast.JsStatement;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.thirdparty.guava.common.base.Joiner;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class ClosureJsInteropExportsGenerator
implements JsInteropExportsGenerator {
    private final List<JsStatement> exportStmts;
    private final Map<HasName, JsName> names;
    private final Set<String> providedNamespaces = new HashSet<String>();

    public ClosureJsInteropExportsGenerator(List<JsStatement> exportStmts, Map<HasName, JsName> names) {
        this.exportStmts = exportStmts;
        this.names = names;
    }

    @Override
    public void exportType(JDeclaredType x) {
        assert (!x.isJsNative() && !x.isJsFunction());
        this.generateExport(x.getQualifiedJsName(), x.getQualifiedJsName(), this.names.get(x).makeRef(x.getSourceInfo()), x.getSourceInfo());
    }

    @Override
    public void exportMember(JMember member, JsExpression bridgeMethodOrAlias) {
        this.generateExport(member.getJsNamespace(), member.getQualifiedJsName(), bridgeMethodOrAlias, member.getSourceInfo());
    }

    private void generateExport(String exportNamespace, String qualifiedExportName, JsExpression bridgeOrAlias, SourceInfo sourceInfo) {
        assert (!JsInteropUtil.isWindow(exportNamespace));
        this.ensureGoogProvide(exportNamespace, sourceInfo);
        this.generateAssignment(bridgeOrAlias, qualifiedExportName, sourceInfo);
    }

    private void ensureGoogProvide(String namespace, SourceInfo info) {
        if (JsInteropUtil.isGlobal(namespace) || !this.providedNamespaces.add(namespace)) {
            return;
        }
        JsNameRef provideFuncRef = JsUtils.createQualifiedNameRef("goog.provide", info);
        JsInvocation provideCall = new JsInvocation(info);
        provideCall.setQualifier(provideFuncRef);
        provideCall.getArguments().add(new JsStringLiteral(info, namespace));
        this.exportStmts.add(provideCall.makeStmt());
    }

    private void generateAssignment(JsExpression rhs, String exportName, SourceInfo sourceInfo) {
        JsExpression lhs = ClosureJsInteropExportsGenerator.createExportQualifier(exportName, sourceInfo);
        this.exportStmts.add(JsUtils.createAssignment(lhs, rhs).makeStmt());
    }

    private static JsExpression createExportQualifier(String namespace, SourceInfo sourceInfo) {
        Object[] components = namespace.split("\\.");
        if (JsInteropUtil.isGlobal(components[0])) {
            assert (components.length != 0);
            components[0] = null;
        }
        return JsUtils.createQualifiedNameRef(Joiner.on(".").skipNulls().join(components), sourceInfo);
    }
}

