/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JArrayLength;
import com.google.gwt.dev.jjs.ast.JArrayRef;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBooleanLiteral;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JCharLiteral;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConditional;
import com.google.gwt.dev.jjs.ast.JDoubleLiteral;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JFloatLiteral;
import com.google.gwt.dev.jjs.ast.JInstanceOf;
import com.google.gwt.dev.jjs.ast.JIntLiteral;
import com.google.gwt.dev.jjs.ast.JLocalRef;
import com.google.gwt.dev.jjs.ast.JLongLiteral;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNameOf;
import com.google.gwt.dev.jjs.ast.JNewArray;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JNullLiteral;
import com.google.gwt.dev.jjs.ast.JNumericEntry;
import com.google.gwt.dev.jjs.ast.JParameterRef;
import com.google.gwt.dev.jjs.ast.JPermutationDependentValue;
import com.google.gwt.dev.jjs.ast.JPostfixOperation;
import com.google.gwt.dev.jjs.ast.JPrefixOperation;
import com.google.gwt.dev.jjs.ast.JRunAsync;
import com.google.gwt.dev.jjs.ast.JStringLiteral;
import com.google.gwt.dev.jjs.ast.JSwitchExpression;
import com.google.gwt.dev.jjs.ast.JThisRef;
import com.google.gwt.dev.jjs.ast.JUnsafeTypeCoercion;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JMultiExpression;
import com.google.gwt.dev.jjs.ast.js.JsniFieldRef;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import java.util.ArrayList;
import java.util.List;

public class CloneExpressionVisitor
extends JVisitor {
    private JExpression expression;

    public <T extends JExpression> T cloneExpression(T expr) {
        if (expr == null) {
            return null;
        }
        this.expression = null;
        this.accept(expr);
        if (this.expression == null) {
            throw new InternalCompilerException(expr, "Unable to clone expression", null);
        }
        Class<?> originalClass = expr.getClass();
        return (T)((JExpression)originalClass.cast(this.expression));
    }

    public ArrayList<JExpression> cloneExpressions(List<JExpression> exprs) {
        if (exprs == null) {
            return null;
        }
        ArrayList<JExpression> result = new ArrayList<JExpression>();
        for (JExpression expr : exprs) {
            result.add(this.cloneExpression(expr));
        }
        return result;
    }

    @Override
    public boolean visit(JArrayLength x, Context ctx) {
        this.expression = new JArrayLength(x.getSourceInfo(), this.cloneExpression(x.getInstance()));
        return false;
    }

    @Override
    public boolean visit(JArrayRef x, Context ctx) {
        this.expression = new JArrayRef(x.getSourceInfo(), this.cloneExpression(x.getInstance()), this.cloneExpression(x.getIndexExpr()));
        return false;
    }

    @Override
    public boolean visit(JBinaryOperation x, Context ctx) {
        this.expression = new JBinaryOperation(x.getSourceInfo(), x.getType(), x.getOp(), this.cloneExpression(x.getLhs()), this.cloneExpression(x.getRhs()));
        return false;
    }

    @Override
    public boolean visit(JBooleanLiteral x, Context ctx) {
        this.expression = x;
        return false;
    }

    @Override
    public boolean visit(JCastOperation x, Context ctx) {
        this.expression = new JCastOperation(x.getSourceInfo(), x.getCastType(), this.cloneExpression(x.getExpr()));
        return false;
    }

    @Override
    public boolean visit(JCharLiteral x, Context ctx) {
        this.expression = x;
        return false;
    }

    @Override
    public boolean visit(JClassLiteral x, Context ctx) {
        this.expression = x;
        return false;
    }

    @Override
    public boolean visit(JConditional x, Context ctx) {
        this.expression = new JConditional(x.getSourceInfo(), x.getType(), this.cloneExpression(x.getIfTest()), this.cloneExpression(x.getThenExpr()), this.cloneExpression(x.getElseExpr()));
        return false;
    }

    @Override
    public boolean visit(JDoubleLiteral x, Context ctx) {
        this.expression = x;
        return false;
    }

    @Override
    public boolean visit(JFieldRef x, Context ctx) {
        this.expression = new JFieldRef(x.getSourceInfo(), this.cloneExpression(x.getInstance()), x.getField(), x.getEnclosingType());
        return false;
    }

    @Override
    public boolean visit(JFloatLiteral x, Context ctx) {
        this.expression = x;
        return false;
    }

    @Override
    public boolean visit(JInstanceOf x, Context ctx) {
        this.expression = new JInstanceOf(x.getSourceInfo(), x.getTestType(), this.cloneExpression(x.getExpr()));
        return false;
    }

    @Override
    public boolean visit(JIntLiteral x, Context ctx) {
        this.expression = x;
        return false;
    }

    @Override
    public boolean visit(JLocalRef x, Context ctx) {
        this.expression = x.getLocal().makeRef(x.getSourceInfo());
        return false;
    }

    @Override
    public boolean visit(JLongLiteral x, Context ctx) {
        this.expression = x;
        return false;
    }

    @Override
    public boolean visit(JMethodCall x, Context ctx) {
        JMethodCall newMethodCall = new JMethodCall(x, this.cloneExpression(x.getInstance()), new JExpression[0]);
        newMethodCall.addArgs(this.cloneExpressions(x.getArgs()));
        this.expression = newMethodCall;
        return false;
    }

    @Override
    public boolean visit(JMultiExpression x, Context ctx) {
        this.expression = new JMultiExpression(x.getSourceInfo(), this.cloneExpressions(x.getExpressions()));
        return false;
    }

    @Override
    public boolean visit(JNameOf x, Context ctx) {
        this.expression = new JNameOf(x.getSourceInfo(), (JClassType)x.getType().getUnderlyingType(), x.getNode());
        return false;
    }

    @Override
    public boolean visit(JNewArray x, Context ctx) {
        this.expression = new JNewArray(x.getSourceInfo(), x.getArrayType(), this.cloneExpressions(x.getDimensionExpressions()), this.cloneExpressions(x.getInitializers()), this.cloneExpression(x.getLeafTypeClassLiteral()));
        return false;
    }

    @Override
    public boolean visit(JNewInstance x, Context ctx) {
        JNewInstance newInstance = new JNewInstance(x);
        newInstance.addArgs(this.cloneExpressions(x.getArgs()));
        this.expression = newInstance;
        return false;
    }

    @Override
    public boolean visit(JNumericEntry x, Context ctx) {
        this.expression = new JNumericEntry(x.getSourceInfo(), x.getKey(), x.getValue());
        return false;
    }

    @Override
    public boolean visit(JNullLiteral x, Context ctx) {
        this.expression = x;
        return false;
    }

    @Override
    public boolean visit(JParameterRef x, Context ctx) {
        this.expression = x.getParameter().makeRef(x.getSourceInfo());
        return false;
    }

    @Override
    public void endVisit(JPermutationDependentValue x, Context ctx) {
        throw new IllegalStateException("AST should not contain permutation dependent values at this point but contains " + x);
    }

    @Override
    public boolean visit(JSwitchExpression x, Context ctx) {
        throw new UnsupportedOperationException("switch expression cannot be cloned");
    }

    @Override
    public boolean visit(JPostfixOperation x, Context ctx) {
        this.expression = new JPostfixOperation(x.getSourceInfo(), x.getOp(), this.cloneExpression(x.getArg()));
        return false;
    }

    @Override
    public boolean visit(JPrefixOperation x, Context ctx) {
        this.expression = new JPrefixOperation(x.getSourceInfo(), x.getOp(), this.cloneExpression(x.getArg()));
        return false;
    }

    @Override
    public boolean visit(JRunAsync x, Context ctx) {
        JExpression runAsyncCall = this.cloneExpression(x.getRunAsyncCall());
        this.expression = new JRunAsync(x.getSourceInfo(), x.getRunAsyncId(), x.getName(), x.hasExplicitClassLiteral(), runAsyncCall, x.getOnSuccessCall());
        return false;
    }

    @Override
    public boolean visit(JsniFieldRef x, Context ctx) {
        this.expression = x;
        return false;
    }

    @Override
    public boolean visit(JsniMethodRef x, Context ctx) {
        this.expression = x;
        return false;
    }

    @Override
    public boolean visit(JStringLiteral x, Context ctx) {
        this.expression = x;
        return false;
    }

    @Override
    public boolean visit(JThisRef x, Context ctx) {
        this.expression = new JThisRef(x.getSourceInfo(), x.getClassType());
        return false;
    }

    @Override
    public boolean visit(JUnsafeTypeCoercion x, Context ctx) {
        this.expression = new JUnsafeTypeCoercion(x.getSourceInfo(), x.getCoercionType(), this.cloneExpression(x.getExpression()));
        return false;
    }
}

