/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JIfStatement;
import com.google.gwt.dev.jjs.ast.JInstanceOf;
import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JLocalRef;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JThrowStatement;
import com.google.gwt.dev.jjs.ast.JTryStatement;
import com.google.gwt.dev.jjs.ast.JType;
import java.util.ArrayList;
import java.util.List;

public class CatchBlockNormalizer {
    private JMethodBody currentMethodBody;
    private int catchVariableIndex;
    private final JProgram program;

    public static void exec(JProgram program) {
        new CatchBlockNormalizer(program).execImpl();
    }

    private CatchBlockNormalizer(JProgram program) {
        this.program = program;
    }

    private void clearLocals() {
        this.catchVariableIndex = 0;
    }

    private void execImpl() {
        CollapseCatchBlocks collapser = new CollapseCatchBlocks();
        collapser.accept(this.program);
        UnwrapThrowableVisitor unwrapper = new UnwrapThrowableVisitor();
        unwrapper.accept(this.program);
    }

    private JLocal newExceptionVariable(SourceInfo sourceInfo) {
        return JProgram.createLocal(sourceInfo, "$e" + this.catchVariableIndex++, this.program.getTypeJavaLangObject(), false, this.currentMethodBody);
    }

    private class UnwrapThrowableVisitor
    extends JModVisitor {
        JMethod unwrapMethod;

        private UnwrapThrowableVisitor() {
            this.unwrapMethod = CatchBlockNormalizer.this.program.getIndexedMethod("Exceptions.toJs");
        }

        @Override
        public void endVisit(JThrowStatement x, Context ctx) {
            ctx.replaceMe(this.createUnwrappedThrow(x));
        }

        private JThrowStatement createUnwrappedThrow(JThrowStatement x) {
            JMethodCall call = new JMethodCall(x.getSourceInfo(), null, this.unwrapMethod, new JExpression[0]);
            call.addArg(x.getExpr());
            return new JThrowStatement(x.getSourceInfo(), call);
        }
    }

    private class CollapseCatchBlocks
    extends JModVisitor {
        JMethod wrapMethod;

        private CollapseCatchBlocks() {
            this.wrapMethod = CatchBlockNormalizer.this.program.getIndexedMethod("Exceptions.toJava");
        }

        @Override
        public void endVisit(JMethodBody x, Context ctx) {
            CatchBlockNormalizer.this.clearLocals();
            CatchBlockNormalizer.this.currentMethodBody = null;
        }

        @Override
        public void endVisit(JTryStatement x, Context ctx) {
            if (x.getCatchClauses().isEmpty() && (x.getFinallyBlock() == null || x.getFinallyBlock().isEmpty())) {
                ctx.replaceMe(x.getTryBlock());
            }
            if (x.getCatchClauses().isEmpty()) {
                return;
            }
            SourceInfo catchInfo = x.getCatchClauses().get(0).getBlock().getSourceInfo();
            JLocal exceptionVariable = CatchBlockNormalizer.this.newExceptionVariable(x.getSourceInfo());
            JBlock newCatchBlock = new JBlock(catchInfo, new JStatement[0]);
            JMethodCall call = new JMethodCall(catchInfo, null, this.wrapMethod, exceptionVariable.makeRef(catchInfo));
            newCatchBlock.addStmt(JProgram.createAssignmentStmt(catchInfo, exceptionVariable.makeRef(catchInfo), call));
            JStatement cur = new JThrowStatement(catchInfo, exceptionVariable.makeRef(catchInfo));
            for (int i = x.getCatchClauses().size() - 1; i >= 0; --i) {
                JTryStatement.CatchClause clause = x.getCatchClauses().get(i);
                JBlock block = clause.getBlock();
                JLocalRef arg = clause.getArg();
                List<JType> exceptionsTypes = clause.getTypes();
                catchInfo = block.getSourceInfo();
                JExpression ifTest = new JInstanceOf(catchInfo, (JReferenceType)exceptionsTypes.get(0), exceptionVariable.makeRef(catchInfo));
                for (int j = 1; j < exceptionsTypes.size(); ++j) {
                    JInstanceOf orExp = new JInstanceOf(catchInfo, (JReferenceType)exceptionsTypes.get(j), exceptionVariable.makeRef(catchInfo));
                    ifTest = new JBinaryOperation(catchInfo, JPrimitiveType.BOOLEAN, JBinaryOperator.OR, ifTest, orExp);
                }
                JDeclarationStatement declaration = new JDeclarationStatement(catchInfo, arg, exceptionVariable.makeRef(catchInfo));
                block.addStmt(0, declaration);
                cur = new JIfStatement(catchInfo, ifTest, block, cur);
            }
            newCatchBlock.addStmt(cur);
            x.getCatchClauses().clear();
            ArrayList<JType> newCatchTypes = new ArrayList<JType>(1);
            newCatchTypes.add(exceptionVariable.getType());
            x.getCatchClauses().add(new JTryStatement.CatchClause(newCatchTypes, exceptionVariable.makeRef(catchInfo), newCatchBlock));
        }

        @Override
        public boolean visit(JMethodBody x, Context ctx) {
            CatchBlockNormalizer.this.currentMethodBody = x;
            CatchBlockNormalizer.this.clearLocals();
            return true;
        }
    }
}

