/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.thirdparty.guava.common.collect.LinkedHashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;

public class CallGraph {
    private LinkedHashMultimap<JMethod, JMethod> calleeCallersPairs = LinkedHashMultimap.create();
    private LinkedHashMultimap<JMethod, JMethod> callerCalleesPairs = LinkedHashMultimap.create();

    public void addCallerMethod(JMethod callerMethod, Collection<JMethod> calleeMethods) {
        this.callerCalleesPairs.putAll((Object)callerMethod, calleeMethods);
        for (JMethod calleeMethod : calleeMethods) {
            this.calleeCallersPairs.put((Object)calleeMethod, (Object)callerMethod);
        }
    }

    public void buildCallGraph(JProgram program) {
        this.resetCallGraph();
        BuildCallGraphVisitor buildCallGraphVisitor = new BuildCallGraphVisitor();
        buildCallGraphVisitor.accept(program);
    }

    public Set<JMethod> getAllCallees() {
        return this.calleeCallersPairs.keySet();
    }

    public Set<JMethod> getCallees(Collection<JMethod> callerMethods) {
        assert (callerMethods != null);
        LinkedHashSet<JMethod> calleeMethods = Sets.newLinkedHashSet();
        for (JMethod callerMethod : callerMethods) {
            calleeMethods.addAll(this.callerCalleesPairs.get((Object)callerMethod));
        }
        return calleeMethods;
    }

    public Set<JMethod> getCallers(Collection<JMethod> calleeMethods) {
        assert (calleeMethods != null);
        LinkedHashSet<JMethod> callerMethods = Sets.newLinkedHashSet();
        for (JMethod calleeMethod : calleeMethods) {
            callerMethods.addAll(this.calleeCallersPairs.get((Object)calleeMethod));
        }
        return callerMethods;
    }

    public Set<JMethod> removeCalleeMethod(JMethod calleeMethod) {
        Set callerMethods = this.calleeCallersPairs.removeAll(calleeMethod);
        for (JMethod callerMethod : callerMethods) {
            this.callerCalleesPairs.remove(callerMethod, calleeMethod);
        }
        return callerMethods;
    }

    public Set<JMethod> removeCallerMethod(JMethod callerMethod) {
        Set calleeMethods = this.callerCalleesPairs.removeAll(callerMethod);
        for (JMethod calleeMethod : calleeMethods) {
            this.calleeCallersPairs.remove(calleeMethod, callerMethod);
        }
        return calleeMethods;
    }

    public void resetCallGraph() {
        this.calleeCallersPairs.clear();
        this.callerCalleesPairs.clear();
    }

    public void updateCallGraphOfMethod(JMethod method, CallGraph deletedSubCallGraph, CallGraph addedSubCallGraph) {
        Set<JMethod> calleeMethods = this.removeCallerMethod(method);
        BuildCallGraphVisitor callSiteVisitor = new BuildCallGraphVisitor();
        callSiteVisitor.accept(method);
        deletedSubCallGraph.addCallerMethod(method, Sets.difference(calleeMethods, this.callerCalleesPairs.get((Object)method)));
        addedSubCallGraph.addCallerMethod(method, Sets.difference(this.callerCalleesPairs.get((Object)method), calleeMethods));
    }

    private class BuildCallGraphVisitor
    extends JVisitor {
        private JMethod currentMethod;

        private BuildCallGraphVisitor() {
        }

        @Override
        public void endVisit(JMethod x, Context ctx) {
            assert (this.currentMethod == x);
            this.currentMethod = null;
        }

        @Override
        public void endVisit(JMethodCall x, Context ctx) {
            JMethod calleeMethod = x.getTarget();
            assert (this.currentMethod != null);
            CallGraph.this.calleeCallersPairs.put(calleeMethod, this.currentMethod);
            CallGraph.this.callerCalleesPairs.put(this.currentMethod, calleeMethod);
        }

        @Override
        public boolean visit(JMethod x, Context ctx) {
            assert (this.currentMethod == null);
            this.currentMethod = x;
            return true;
        }
    }
}

