/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class AutoboxUtils {
    private static final JPrimitiveType[] TYPES = new JPrimitiveType[]{JPrimitiveType.BOOLEAN, JPrimitiveType.BYTE, JPrimitiveType.CHAR, JPrimitiveType.SHORT, JPrimitiveType.INT, JPrimitiveType.LONG, JPrimitiveType.FLOAT, JPrimitiveType.DOUBLE};
    private final Map<JPrimitiveType, JMethod> boxMethods = new LinkedHashMap<JPrimitiveType, JMethod>();
    private final Map<JDeclaredType, JMethod> unboxMethods = new LinkedHashMap<JDeclaredType, JMethod>();

    public AutoboxUtils(JProgram program) {
        for (JPrimitiveType primType : TYPES) {
            JDeclaredType wrapperType = program.getFromTypeMap(primType.getWrapperTypeName());
            String boxSig = "valueOf(" + primType.getJsniSignatureName() + ")" + wrapperType.getJsniSignatureName();
            String unboxSig = primType.getName() + "Value()" + primType.getJsniSignatureName();
            for (JMethod method : wrapperType.getMethods()) {
                if (method.isStatic()) {
                    if (!method.getSignature().equals(boxSig)) continue;
                    this.boxMethods.put(primType, method);
                    continue;
                }
                if (!method.getSignature().equals(unboxSig)) continue;
                this.unboxMethods.put(wrapperType, method);
            }
        }
        assert (this.boxMethods.size() == TYPES.length);
        assert (this.unboxMethods.size() == TYPES.length);
    }

    public JExpression box(JExpression toBox, JPrimitiveType primitiveType) {
        if (toBox.getType() != primitiveType) {
            toBox = new JCastOperation(toBox.getSourceInfo(), primitiveType, toBox);
        }
        JMethod method = this.boxMethods.get(primitiveType);
        assert (method != null);
        JMethodCall call = new JMethodCall(toBox.getSourceInfo(), null, method, new JExpression[0]);
        call.addArg(toBox);
        return call;
    }

    public Collection<JMethod> getBoxMethods() {
        return this.boxMethods.values();
    }

    public Collection<JMethod> getUnboxMethods() {
        return this.unboxMethods.values();
    }

    public JExpression undoUnbox(JExpression arg) {
        if (arg instanceof JMethodCall) {
            JMethodCall argMethodCall = (JMethodCall)arg;
            assert (this.unboxMethods.values().contains(argMethodCall.getTarget()));
            return argMethodCall.getInstance();
        }
        return null;
    }
}

