/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.impl.SourceGenerationVisitor;
import com.google.gwt.dev.util.AbstractTextOutput;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class AstDumper {
    private static int autoVersionNumber = 0;

    public static void maybeDumpAST(JProgram jprogram) {
        AstDumper.maybeDumpAST(jprogram, null, true);
    }

    public static void maybeDumpAST(JProgram jprogram, boolean autoIncrementVersion) {
        if (!autoIncrementVersion) {
            AstDumper.maybeDumpAST(jprogram);
        } else {
            AstDumper.maybeDumpAST(jprogram, autoVersionNumber++);
        }
    }

    public static void maybeDumpAST(JProgram jprogram, int versionNumber) {
        String fileExtension = "." + versionNumber;
        AstDumper.maybeDumpAST(jprogram, fileExtension, false);
    }

    public static void maybeDumpAST(JProgram jprogram, String versionString) {
        String fileExtension = "." + versionString;
        AstDumper.maybeDumpAST(jprogram, fileExtension, false);
    }

    private static void maybeDumpAST(JProgram jprogram, String fileExtension, boolean append) {
        String dumpFile = System.getProperty("gwt.jjs.dumpAst");
        if (dumpFile != null) {
            if (fileExtension != null) {
                dumpFile = dumpFile + fileExtension;
            }
            try {
                FileOutputStream os = new FileOutputStream(dumpFile, append);
                final PrintWriter pw = new PrintWriter(os);
                AbstractTextOutput out = new AbstractTextOutput(false){
                    {
                        super(compact);
                        this.setPrintWriter(pw);
                    }
                };
                SourceGenerationVisitor v = new SourceGenerationVisitor(out);
                v.accept(jprogram);
                pw.close();
            }
            catch (IOException e) {
                System.out.println("Could not dump AST");
                e.printStackTrace();
            }
        }
    }
}

