/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JAssertStatement;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;

public class AssertionRemover {
    private final JProgram program;

    public static void exec(JProgram program) {
        SpeedTracerLogger.Event assertionRemoverEvent = SpeedTracerLogger.start(CompilerEventType.ASSERTION_REMOVER, new String[0]);
        new AssertionRemover(program).execImpl();
        assertionRemoverEvent.end(new String[0]);
    }

    public AssertionRemover(JProgram program) {
        this.program = program;
    }

    private void execImpl() {
        AssertRemoveVisitor assertRemover = new AssertRemoveVisitor();
        assertRemover.accept(this.program);
    }

    private static class AssertRemoveVisitor
    extends JModVisitor {
        private AssertRemoveVisitor() {
        }

        @Override
        public void endVisit(JAssertStatement x, Context ctx) {
            this.removeMe(x, ctx);
        }

        private void removeMe(JStatement stmt, Context ctx) {
            if (ctx.canRemove()) {
                ctx.removeMe();
            } else {
                ctx.replaceMe(new JBlock(stmt.getSourceInfo(), new JStatement[0]));
            }
        }
    }
}

