/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JAssertStatement;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JIfStatement;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JPrefixOperation;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JThrowStatement;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JUnaryOperator;
import com.google.gwt.dev.jjs.ast.js.JDebuggerStatement;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;

public class AssertionNormalizer {
    private final JProgram program;

    public static void exec(JProgram program) {
        SpeedTracerLogger.Event assertionNormalizerEvent = SpeedTracerLogger.start(CompilerEventType.ASSERTION_NORMALIZER, new String[0]);
        new AssertionNormalizer(program).execImpl();
        assertionNormalizerEvent.end(new String[0]);
    }

    private static String getAssertMethodSuffix(JExpression arg) {
        if (arg == null) {
            return "";
        }
        JType argType = arg.getType();
        if (argType instanceof JReferenceType) {
            return "_Object";
        }
        assert (argType.isPrimitiveType());
        return "_" + argType.getName();
    }

    public AssertionNormalizer(JProgram program) {
        this.program = program;
    }

    private void execImpl() {
        AssertNormalizeVisitor assertNormalizer = new AssertNormalizeVisitor();
        assertNormalizer.accept(this.program);
    }

    private class AssertNormalizeVisitor
    extends JModVisitor {
        private AssertNormalizeVisitor() {
        }

        @Override
        public void endVisit(JAssertStatement x, Context ctx) {
            JBlock then = new JBlock(x.getSourceInfo(), new JStatement[0]);
            then.addStmt(new JDebuggerStatement(x.getSourceInfo()));
            String methodName = "Exceptions.makeAssertionError" + AssertionNormalizer.getAssertMethodSuffix(x.getArg());
            JMethod method = AssertionNormalizer.this.program.getIndexedMethod(methodName);
            JMethodCall call = new JMethodCall(x.getSourceInfo(), null, method, new JExpression[0]);
            if (x.getArg() != null) {
                call.addArg(x.getArg());
            }
            then.addStmt(new JThrowStatement(x.getSourceInfo(), call));
            JPrefixOperation notX = new JPrefixOperation(x.getSourceInfo(), JUnaryOperator.NOT, x.getTestExpr());
            JIfStatement cond = new JIfStatement(x.getSourceInfo(), notX, then, null);
            ctx.replaceMe(cond);
        }
    }
}

