/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JArrayRef;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JCastMap;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JIntLiteral;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JModVisitor;
import com.google.gwt.dev.jjs.ast.JNewArray;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JRuntimeTypeReference;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.js.JsonArray;
import com.google.gwt.dev.jjs.impl.TypeCategory;
import java.util.Collections;
import java.util.List;

public class ArrayNormalizer {
    private final JMethod initializeUnidimensionalArrayMethod;
    private final JMethod initializeMultidimensionalArrayMethod;
    private final JMethod stampJavaTypeInfoMethod;
    private final JMethod setCheckMethod;
    private final JProgram program;

    private JArrayRef needsSetCheck(JBinaryOperation x) {
        if (x.getOp() != JBinaryOperator.ASG || !(x.getLhs() instanceof JArrayRef)) {
            return null;
        }
        JArrayRef arrayRef = (JArrayRef)x.getLhs();
        JType elementType = arrayRef.getType();
        JExpression arrayInstance = arrayRef.getInstance();
        if (elementType.isNullType()) {
            return null;
        }
        if (!(elementType instanceof JReferenceType)) {
            return null;
        }
        if (!arrayInstance.getType().canBeSubclass() && this.program.typeOracle.castSucceedsTrivially((JReferenceType)x.getRhs().getType(), (JReferenceType)elementType)) {
            return null;
        }
        return arrayRef;
    }

    public static JsonArray getInitializerArray(JNewArray x) {
        return new JsonArray(x.getSourceInfo(), (JType)x.getType(), x.getInitializers());
    }

    public static void exec(JProgram program) {
        new ArrayNormalizer(program).execImpl();
    }

    private ArrayNormalizer(JProgram program) {
        this.program = program;
        this.setCheckMethod = program.getIndexedMethod("Array.setCheck");
        this.initializeUnidimensionalArrayMethod = program.getIndexedMethod("Array.initUnidimensionalArray");
        this.initializeMultidimensionalArrayMethod = program.getIndexedMethod("Array.initMultidimensionalArray");
        this.stampJavaTypeInfoMethod = program.getIndexedMethod("Array.stampJavaTypeInfo");
    }

    private void execImpl() {
        new ArrayVisitor().accept(this.program);
    }

    private class ArrayVisitor
    extends JModVisitor {
        private ArrayVisitor() {
        }

        @Override
        public void endVisit(JBinaryOperation x, Context ctx) {
            JArrayRef arrayRef = ArrayNormalizer.this.needsSetCheck(x);
            if (arrayRef == null) {
                return;
            }
            JMethodCall call = new JMethodCall(x.getSourceInfo(), null, ArrayNormalizer.this.setCheckMethod, new JExpression[0]);
            call.addArgs(arrayRef.getInstance(), arrayRef.getIndexExpr(), x.getRhs());
            ctx.replaceMe(call);
        }

        @Override
        public void endVisit(JNewArray x, Context ctx) {
            JArrayType type = x.getArrayType();
            List<JExpression> initializers = x.getInitializers();
            if (initializers != null) {
                JsonArray initializerArray = ArrayNormalizer.getInitializerArray(x);
                if (ArrayNormalizer.this.program.isUntypedArrayType(type)) {
                    ctx.replaceMe(initializerArray);
                    return;
                }
                ctx.replaceMe(this.createArrayFromInitializers(x, type));
                return;
            }
            if (ArrayNormalizer.this.program.isUntypedArrayType(type) && type.getDims() == 1) {
                ctx.replaceMe(new JMethodCall(x.getSourceInfo(), null, ArrayNormalizer.this.program.getIndexedMethod("Array.newArray"), x.getDimensionExpressions().get(0)));
                return;
            }
            int suppliedDimensions = x.getDimensionExpressions().size();
            assert (suppliedDimensions >= 1);
            if (suppliedDimensions == 1) {
                ctx.replaceMe(this.initializeUnidimensionalArray(x, type));
                return;
            }
            ctx.replaceMe(this.initializeMultidimensionalArray(x, type));
        }

        private JRuntimeTypeReference getElementRuntimeTypeReference(SourceInfo sourceInfo, JArrayType arrayType) {
            JType elementType = arrayType.getElementType();
            if (!(elementType instanceof JReferenceType)) {
                elementType = JReferenceType.NULL_TYPE;
            }
            elementType = ((ArrayNormalizer)ArrayNormalizer.this).program.typeOracle.isEffectivelyJavaScriptObject(elementType) ? ArrayNormalizer.this.program.getJavaScriptObject() : elementType.getUnderlyingType();
            elementType = ArrayNormalizer.this.program.normalizeJsoType(elementType);
            return new JRuntimeTypeReference(sourceInfo, ArrayNormalizer.this.program.getTypeJavaLangObject(), (JReferenceType)elementType);
        }

        private JExpression getOrCreateCastMap(SourceInfo sourceInfo, JArrayType arrayType) {
            JCastMap castableTypeMap = ArrayNormalizer.this.program.getCastMap(arrayType);
            if (castableTypeMap == null) {
                return new JCastMap(sourceInfo, ArrayNormalizer.this.program.getTypeJavaLangObject(), Collections.emptyList());
            }
            return castableTypeMap;
        }

        private JExpression initializeUnidimensionalArray(JNewArray x, JArrayType arrayType) {
            SourceInfo sourceInfo = x.getSourceInfo();
            JClassLiteral classLit = x.getLeafTypeClassLiteral();
            JExpression castableTypeMap = this.getOrCreateCastMap(sourceInfo, arrayType);
            JRuntimeTypeReference arrayElementRuntimeTypeReference = this.getElementRuntimeTypeReference(sourceInfo, arrayType);
            JType elementType = arrayType.getElementType();
            JIntLiteral elementTypeCategory = this.getTypeCategoryLiteral(elementType);
            JExpression dim = x.getDimensionExpressions().get(0);
            JMethodCall call = new JMethodCall(sourceInfo, null, ArrayNormalizer.this.initializeUnidimensionalArrayMethod, new JExpression[0]);
            call.overrideReturnType(arrayType);
            call.addArgs(classLit, castableTypeMap, arrayElementRuntimeTypeReference, dim, elementTypeCategory, ArrayNormalizer.this.program.getLiteralInt(arrayType.getDims()));
            return call;
        }

        private JExpression initializeMultidimensionalArray(JNewArray x, JArrayType arrayType) {
            SourceInfo sourceInfo = x.getSourceInfo();
            JsonArray castableTypeMaps = new JsonArray(sourceInfo, (JType)ArrayNormalizer.this.program.getJavaScriptObject(), new JExpression[0]);
            JsonArray elementTypeReferences = new JsonArray(sourceInfo, (JType)ArrayNormalizer.this.program.getJavaScriptObject(), new JExpression[0]);
            JsonArray dimList = new JsonArray(sourceInfo, (JType)ArrayNormalizer.this.program.getJavaScriptObject(), new JExpression[0]);
            JType currentElementType = arrayType;
            JClassLiteral classLit = x.getLeafTypeClassLiteral();
            for (int i = 0; i < x.getDimensionExpressions().size(); ++i) {
                JArrayType curArrayType = currentElementType;
                JExpression castableTypeMap = this.getOrCreateCastMap(sourceInfo, curArrayType);
                castableTypeMaps.getExpressions().add(castableTypeMap);
                JRuntimeTypeReference elementTypeIdLit = this.getElementRuntimeTypeReference(sourceInfo, curArrayType);
                elementTypeReferences.getExpressions().add(elementTypeIdLit);
                dimList.getExpressions().add(x.getDimensionExpressions().get(i));
                currentElementType = curArrayType.getElementType();
            }
            JArrayType leafElementType = currentElementType;
            JIntLiteral leafElementTypeCategory = this.getTypeCategoryLiteral(leafElementType);
            JMethodCall call = new JMethodCall(sourceInfo, null, ArrayNormalizer.this.initializeMultidimensionalArrayMethod, new JExpression[0]);
            call.overrideReturnType(arrayType);
            call.addArgs(classLit, castableTypeMaps, elementTypeReferences, leafElementTypeCategory, dimList, ArrayNormalizer.this.program.getLiteralInt(x.getDimensionExpressions().size()));
            return call;
        }

        private JExpression createArrayFromInitializers(JNewArray x, JArrayType arrayType) {
            SourceInfo sourceInfo = x.getSourceInfo();
            JExpression classLitExpression = ArrayNormalizer.this.program.createArrayClassLiteralExpression(x.getSourceInfo(), x.getLeafTypeClassLiteral(), arrayType.getDims());
            JExpression castableTypeMap = this.getOrCreateCastMap(sourceInfo, arrayType);
            JRuntimeTypeReference elementTypeIds = this.getElementRuntimeTypeReference(sourceInfo, arrayType);
            JsonArray initializers = new JsonArray(sourceInfo, (JType)ArrayNormalizer.this.program.getJavaScriptObject(), x.getInitializers());
            JIntLiteral leafElementTypeCategory = this.getTypeCategoryLiteral(arrayType.getElementType());
            JMethodCall call = new JMethodCall(sourceInfo, null, ArrayNormalizer.this.stampJavaTypeInfoMethod, new JExpression[0]);
            call.overrideReturnType(arrayType);
            call.addArgs(classLitExpression, castableTypeMap, elementTypeIds, leafElementTypeCategory, initializers);
            return call;
        }

        private JIntLiteral getTypeCategoryLiteral(JType type) {
            return JIntLiteral.get(TypeCategory.typeCategoryForType(type, ArrayNormalizer.this.program).ordinal());
        }
    }
}

