/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.impl;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.jjs.HasSourceInfo;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMember;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.util.log.AbstractTreeLogger;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Ordering;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import com.google.gwt.thirdparty.guava.common.collect.TreeMultimap;
import java.util.Set;
import java.util.TreeSet;

public abstract class AbstractRestrictionChecker {
    private Multimap<String, String> errorsByFilename = TreeMultimap.create(Ordering.natural(), AbstractTreeLogger.LOG_LINE_COMPARATOR);
    private Multimap<String, String> warningsByFilename = TreeMultimap.create(Ordering.natural(), AbstractTreeLogger.LOG_LINE_COMPARATOR);
    private Set<String> suggestionMessages = Sets.newLinkedHashSet();

    protected static String getDescription(HasSourceInfo hasSourceInfo) {
        if (hasSourceInfo instanceof JDeclaredType) {
            return AbstractRestrictionChecker.getTypeDescription((JDeclaredType)hasSourceInfo);
        }
        return AbstractRestrictionChecker.getMemberDescription((JMember)hasSourceInfo);
    }

    protected static String getMemberDescription(JMember member) {
        if (member instanceof JField) {
            return String.format("'%s'", JjsUtils.getReadableDescription(member));
        }
        JMethod method = (JMethod)member;
        if ((method.isSyntheticAccidentalOverride() || method.isSynthetic()) && !method.getOverriddenMethods().isEmpty()) {
            JMethod overridenMethod = Iterables.getFirst(method.getOverriddenMethods(), null);
            return String.format("'%s' (exposed by '%s')", JjsUtils.getReadableDescription(overridenMethod), JjsUtils.getReadableDescription(method.getEnclosingType()));
        }
        return String.format("'%s'", JjsUtils.getReadableDescription(method));
    }

    private static String getTypeDescription(JDeclaredType type) {
        return String.format("'%s'", JjsUtils.getReadableDescription(type));
    }

    protected void logError(String format, JType type) {
        this.logError(type, format, JjsUtils.getReadableDescription(type));
    }

    protected void logError(HasSourceInfo hasSourceInfo, String format, Object ... args) {
        this.errorsByFilename.put(hasSourceInfo.getSourceInfo().getFileName(), String.format("Line %d: ", hasSourceInfo.getSourceInfo().getStartLine()) + String.format(format, args));
    }

    protected void logWarning(HasSourceInfo hasSourceInfo, String format, Object ... args) {
        this.warningsByFilename.put(hasSourceInfo.getSourceInfo().getFileName(), String.format("Line %d: ", hasSourceInfo.getSourceInfo().getStartLine()) + String.format(format, args));
    }

    protected void logSuggestion(String format, Object ... args) {
        this.suggestionMessages.add(String.format(format, args));
    }

    protected boolean reportErrorsAndWarnings(TreeLogger logger) {
        TreeSet<String> filenamesToReport = Sets.newTreeSet(Iterables.concat(this.errorsByFilename.keySet(), this.warningsByFilename.keySet()));
        for (String fileName : filenamesToReport) {
            boolean hasErrors = !this.errorsByFilename.get(fileName).isEmpty();
            TreeLogger branch = logger.branch(TreeLogger.Type.INFO, (hasErrors ? "Errors" : "Warnings") + " in " + fileName);
            for (String message : this.errorsByFilename.get(fileName)) {
                branch.log(TreeLogger.Type.ERROR, message);
            }
            for (String message : this.warningsByFilename.get(fileName)) {
                branch.log(TreeLogger.Type.WARN, message);
            }
        }
        for (String message : this.suggestionMessages) {
            logger.log(TreeLogger.Type.WARN, message);
        }
        return !this.errorsByFilename.isEmpty();
    }
}

