/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast.js;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.Arrays;
import java.util.List;

public class JsonArray
extends JExpression {
    private final List<JExpression> expressions = Lists.newArrayList();
    private JType arrayType;

    public JsonArray(SourceInfo sourceInfo, JType arrayType, List<JExpression> expressions) {
        super(sourceInfo);
        this.arrayType = arrayType;
        this.expressions.addAll(expressions);
    }

    public JsonArray(SourceInfo sourceInfo, JType arrayType, JExpression ... expressions) {
        this(sourceInfo, arrayType, Arrays.asList(expressions));
    }

    public List<JExpression> getExpressions() {
        return this.expressions;
    }

    @Override
    public JType getType() {
        return this.arrayType;
    }

    @Override
    public boolean hasSideEffects() {
        for (JExpression expression : this.expressions) {
            if (!expression.hasSideEffects()) continue;
            return true;
        }
        return false;
    }

    public void resolve(JType arrayType) {
        assert (arrayType.replaces(this.arrayType));
        this.arrayType = arrayType;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            visitor.accept(this.expressions);
        }
        visitor.endVisit(this, ctx);
    }
}

