/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast.js;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JAbstractMethodBody;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JsniClassLiteral;
import com.google.gwt.dev.jjs.ast.js.JsniFieldRef;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.dev.js.ast.JsContext;
import com.google.gwt.dev.js.ast.JsFunction;
import com.google.gwt.dev.js.ast.JsStringLiteral;
import com.google.gwt.dev.js.ast.JsVisitor;
import com.google.gwt.dev.util.collect.HashSet;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.dev.util.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class JsniMethodBody
extends JAbstractMethodBody {
    private List<JsniClassLiteral> classRefs = Collections.emptyList();
    private JsFunction jsFunction = null;
    private List<JsniFieldRef> jsniFieldRefs = Collections.emptyList();
    private List<JsniMethodRef> jsniMethodRefs = Collections.emptyList();
    private Set<String> stringLiterals = Collections.emptySet();

    public JsniMethodBody(SourceInfo info) {
        super(info);
    }

    public JsniMethodBody(SourceInfo info, JsFunction function, List<JsniClassLiteral> classRefs, List<JsniFieldRef> jsniFieldRefs, List<JsniMethodRef> jsniMethodRefs, Set<String> stringLiterals) {
        super(info);
        this.jsFunction = function;
        this.classRefs = classRefs;
        this.jsniFieldRefs = jsniFieldRefs;
        this.jsniMethodRefs = jsniMethodRefs;
        this.stringLiterals = stringLiterals;
    }

    public void addClassRef(JsniClassLiteral ref) {
        this.classRefs = Lists.add(this.classRefs, ref);
    }

    public void addJsniRef(JsniFieldRef ref) {
        this.jsniFieldRefs = Lists.add(this.jsniFieldRefs, ref);
    }

    public void addJsniRef(JsniMethodRef ref) {
        this.jsniMethodRefs = Lists.add(this.jsniMethodRefs, ref);
    }

    public List<JsniClassLiteral> getClassRefs() {
        return this.classRefs;
    }

    public JsFunction getFunc() {
        assert (this.jsFunction != null);
        return this.jsFunction;
    }

    public List<JsniFieldRef> getJsniFieldRefs() {
        return this.jsniFieldRefs;
    }

    public List<JsniMethodRef> getJsniMethodRefs() {
        return this.jsniMethodRefs;
    }

    public Set<String> getUsedStrings() {
        return this.stringLiterals;
    }

    @Override
    public boolean isJsniMethodBody() {
        return true;
    }

    public void setFunc(JsFunction jsFunction) {
        assert (this.jsFunction == null);
        this.jsFunction = jsFunction;
        final HashSet result = new HashSet();
        class RecordStrings
        extends JsVisitor {
            RecordStrings() {
            }

            @Override
            public void endVisit(JsStringLiteral lit, JsContext ctx) {
                result.add(lit.getValue());
            }
        }
        new RecordStrings().accept(jsFunction);
        this.stringLiterals = Sets.normalize(result);
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            this.classRefs = visitor.acceptImmutable(this.classRefs);
            this.jsniFieldRefs = visitor.acceptImmutable(this.jsniFieldRefs);
            this.jsniMethodRefs = visitor.acceptImmutable(this.jsniMethodRefs);
        }
        visitor.endVisit(this, ctx);
    }
}

