/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast.js;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class JMultiExpression
extends JExpression {
    private List<JExpression> expressions = Lists.newArrayList();

    public JMultiExpression(SourceInfo info, JExpression ... expressions) {
        super(info);
        this.addExpressions(expressions);
    }

    public JMultiExpression(SourceInfo info, Collection<JExpression> expressions) {
        super(info);
        this.expressions.addAll(expressions);
    }

    public void addExpressions(JExpression ... expressions) {
        this.expressions.addAll(Arrays.asList(expressions));
    }

    public void addExpressions(List<JExpression> expressions) {
        this.expressions.addAll(expressions);
    }

    public void addExpressions(int index, JExpression ... expressions) {
        this.expressions.addAll(index, Arrays.asList(expressions));
    }

    public void addExpressions(int index, List<JExpression> expressions) {
        this.expressions.addAll(index, expressions);
    }

    public JExpression getExpression(int index) {
        return this.expressions.get(index);
    }

    public List<JExpression> getExpressions() {
        return Collections.unmodifiableList(this.expressions);
    }

    public int getNumberOfExpressions() {
        return this.expressions.size();
    }

    @Override
    public JType getType() {
        int size = this.expressions.size();
        if (size == 0) {
            return JPrimitiveType.VOID;
        }
        return this.expressions.get(size - 1).getType();
    }

    @Override
    public boolean hasSideEffects() {
        for (JExpression expression : this.expressions) {
            if (!expression.hasSideEffects()) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.expressions.isEmpty();
    }

    public JExpression removeExpression(int index) {
        return this.expressions.remove(index);
    }

    public void setExpression(int index, JExpression expression) {
        this.expressions.set(index, expression);
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            visitor.acceptWithInsertRemove(this.expressions);
        }
        visitor.endVisit(this, ctx);
    }
}

