/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.CanBeSetFinal;
import com.google.gwt.dev.jjs.ast.CanHaveInitializer;
import com.google.gwt.dev.jjs.ast.CanHaveSuppressedWarnings;
import com.google.gwt.dev.jjs.ast.HasName;
import com.google.gwt.dev.jjs.ast.HasType;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JLiteral;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVariableRef;
import com.google.gwt.dev.util.StringInterner;
import java.util.Set;

public abstract class JVariable
extends JNode
implements CanBeSetFinal,
CanHaveInitializer,
HasName,
HasType,
CanHaveSuppressedWarnings {
    protected JDeclarationStatement declStmt = null;
    private boolean isFinal;
    private String name;
    private JType type;
    private Set<String> suppressedWarnings;

    JVariable(SourceInfo info, String name, JType type, boolean isFinal) {
        super(info);
        assert (type != null);
        this.name = StringInterner.get().intern(name);
        this.type = type;
        this.isFinal = isFinal;
    }

    @Override
    public JLiteral getConstInitializer() {
        JExpression initializer = this.getInitializer();
        if (this.isFinal() && initializer instanceof JLiteral) {
            return (JLiteral)initializer;
        }
        return null;
    }

    public JDeclarationStatement getDeclarationStatement() {
        return this.declStmt;
    }

    public JExpression getInitializer() {
        if (this.declStmt != null) {
            return this.declStmt.getInitializer();
        }
        return null;
    }

    public abstract JVariableRef makeRef(SourceInfo var1);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public JType getType() {
        return this.type;
    }

    @Override
    public boolean hasInitializer() {
        return this.declStmt != null;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public void setFinal() {
        this.isFinal = true;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setType(JType newType) {
        assert (newType != null);
        this.type = newType;
    }

    @Override
    public Set<String> getSuppressedWarnings() {
        return this.suppressedWarnings;
    }

    @Override
    public void setSuppressedWarnings(Set<String> suppressedWarnings) {
        this.suppressedWarnings = suppressedWarnings;
    }
}

