/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.MinimalRebuildCache;
import com.google.gwt.dev.jjs.ast.ArrayTypeCreator;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.HasName;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JExpressionStatement;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JMultiExpression;
import com.google.gwt.thirdparty.guava.common.annotations.VisibleForTesting;
import com.google.gwt.thirdparty.guava.common.base.Function;
import com.google.gwt.thirdparty.guava.common.base.Objects;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.collect.HashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSetMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.LinkedHashMultimap;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Multimap;
import com.google.gwt.thirdparty.guava.common.collect.Multimaps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JTypeOracle
implements Serializable {
    public static final Function<JType, String> TYPE_TO_NAME = new Function<JType, String>(){

        @Override
        public String apply(JType type) {
            return type.getName();
        }
    };
    private Set<String> allClasses = Sets.newLinkedHashSet();
    private Multimap<String, String> potentialInterfaceByClass;
    private final Set<String> dualImplInterfaces = Sets.newLinkedHashSet();
    private Multimap<String, String> implementedInterfacesByClass;
    private Set<JReferenceType> instantiatedTypes = null;
    private Multimap<String, String> classesByImplementingInterface;
    private final Map<String, String> jsoByInterface = Maps.newLinkedHashMap();
    private Map<String, JReferenceType> referenceTypesByName = Maps.newHashMap();
    private Multimap<String, String> subclassesByClass;
    private Multimap<String, String> subInterfacesByInterface;
    private Multimap<String, String> superclassesByClass;
    private Multimap<String, String> superInterfacesByInterface;
    private final Map<JClassType, Map<String, JMethod>> methodsBySignatureForType = Maps.newIdentityHashMap();
    private boolean optimize = true;
    private ImmediateTypeRelations immediateTypeRelations;
    private ArrayTypeCreator arrayTypeCreator;
    private StandardTypes standardTypes;

    public void setOptimize(boolean optimize) {
        this.optimize = optimize;
    }

    public static boolean methodsDoMatch(JMethod method1, JMethod method2) {
        if (method1.isStatic() || method2.isStatic()) {
            return false;
        }
        if (!method1.getName().equals(method2.getName())) {
            return false;
        }
        if (method1.getOriginalReturnType() != method2.getOriginalReturnType()) {
            return false;
        }
        List<JType> params1 = method1.getOriginalParamTypes();
        List<JType> params2 = method2.getOriginalParamTypes();
        int params1size = params1.size();
        if (params1size != params2.size()) {
            return false;
        }
        for (int i = 0; i < params1size; ++i) {
            if (params1.get(i) == params2.get(i)) continue;
            return false;
        }
        return true;
    }

    public JTypeOracle(ArrayTypeCreator arrayTypeCreator, MinimalRebuildCache minimalRebuildCache) {
        this.immediateTypeRelations = minimalRebuildCache.getImmediateTypeRelations();
        this.arrayTypeCreator = arrayTypeCreator;
        this.computeExtendedTypeRelations();
    }

    public boolean canBeJavaScriptObject(JType type) {
        return (type = type.getUnderlyingType()).isJsoType() || this.isSingleJsoImpl(type);
    }

    public static boolean isNoOpCast(JType type) {
        return type instanceof JInterfaceType && type.isJsNative();
    }

    private boolean isJsInteropCrossCastTarget(JType type) {
        return type.isJsNative() || type.isJsFunction();
    }

    public boolean castFailsTrivially(JReferenceType fromType, JReferenceType toType) {
        if (!fromType.canBeNull() && toType.isNullType()) {
            return true;
        }
        if (this.isJsInteropCrossCastTarget(toType.getUnderlyingType()) || this.isJsInteropCrossCastTarget(fromType.getUnderlyingType())) {
            return false;
        }
        if (!fromType.canBeSubclass() && fromType.getUnderlyingType() instanceof JClassType && fromType.getUnderlyingType() != toType.getUnderlyingType() && !this.isSuperClass(fromType, toType) && !this.implementsInterface(fromType, toType)) {
            return true;
        }
        if ((fromType = fromType.getUnderlyingType()) == (toType = toType.getUnderlyingType()) || this.isJavaLangObject(fromType)) {
            return false;
        }
        if (this.canBeJavaScriptObject(fromType) && this.canBeJavaScriptObject(toType)) {
            return false;
        }
        if (this.castSucceedsTrivially(fromType, toType)) {
            return false;
        }
        if (fromType instanceof JArrayType) {
            JArrayType fromArrayType = (JArrayType)fromType;
            if (toType instanceof JArrayType) {
                int toDims;
                JArrayType toArrayType = (JArrayType)toType;
                JType fromLeafType = fromArrayType.getLeafType();
                JType toLeafType = toArrayType.getLeafType();
                int fromDims = fromArrayType.getDims();
                if (fromDims < (toDims = toArrayType.getDims()) && !this.isJavaLangObject(fromLeafType) && !fromLeafType.isNullType()) {
                    return true;
                }
                if (fromDims == toDims && fromLeafType instanceof JReferenceType && toLeafType instanceof JReferenceType) {
                    return this.castFailsTrivially((JReferenceType)fromLeafType, (JReferenceType)toLeafType);
                }
            }
        } else if (fromType instanceof JClassType) {
            JClassType cType = (JClassType)fromType;
            if (toType instanceof JClassType) {
                return !this.isSubClass(cType, (JClassType)toType);
            }
            if (toType instanceof JInterfaceType) {
                return !this.potentialInterfaceByClass.containsEntry(cType.getName(), toType.getName());
            }
        } else if (fromType instanceof JInterfaceType) {
            JInterfaceType fromInterfaceType = (JInterfaceType)fromType;
            if (toType instanceof JClassType) {
                return !this.potentialInterfaceByClass.containsEntry(toType.getName(), fromInterfaceType.getName());
            }
        }
        return false;
    }

    public boolean castSucceedsTrivially(JReferenceType fromType, JReferenceType toType) {
        if (fromType.canBeNull() && !toType.canBeNull()) {
            return false;
        }
        if (fromType.isNullType()) {
            assert (toType.canBeNull());
            return true;
        }
        if (toType.weakenToNullable() == fromType.weakenToNullable()) {
            return true;
        }
        if (!toType.canBeSubclass()) {
            return false;
        }
        if ((fromType = fromType.getUnderlyingType()) == (toType = toType.getUnderlyingType())) {
            return true;
        }
        if (this.isJavaLangObject(toType)) {
            return true;
        }
        if (fromType instanceof JArrayType) {
            return this.castSucceedsTrivially((JArrayType)fromType, toType);
        }
        return this.isSuperClassOrInterface(fromType, toType);
    }

    private boolean castSucceedsTrivially(JArrayType fromArrayType, JReferenceType toType) {
        int toDims;
        assert (!this.isJavaLangObject(toType));
        if (this.isArrayInterface(toType)) {
            return true;
        }
        if (!(toType instanceof JArrayType)) {
            return false;
        }
        JArrayType toArrayType = (JArrayType)toType;
        JType fromLeafType = fromArrayType.getLeafType();
        JType toLeafType = toArrayType.getLeafType();
        int fromDims = fromArrayType.getDims();
        if (fromDims > (toDims = toArrayType.getDims()) && (this.isJavaLangObject(toLeafType) || this.isArrayInterface(toLeafType) || toLeafType.isNullType())) {
            return true;
        }
        if (fromDims != toDims) {
            return false;
        }
        if (fromLeafType instanceof JReferenceType && toLeafType instanceof JReferenceType) {
            return this.castSucceedsTrivially((JReferenceType)fromLeafType, (JReferenceType)toLeafType);
        }
        return false;
    }

    public boolean castSucceedsTrivially(JType fromType, JType toType) {
        if (fromType.isPrimitiveType() && toType.isPrimitiveType()) {
            return fromType == toType;
        }
        if (fromType instanceof JReferenceType && toType instanceof JReferenceType) {
            return this.castSucceedsTrivially((JReferenceType)fromType, (JReferenceType)toType);
        }
        return false;
    }

    public void computeBeforeAST(StandardTypes standardTypes, Collection<JDeclaredType> declaredTypes, List<JDeclaredType> moduleDeclaredTypes) {
        this.computeBeforeAST(standardTypes, declaredTypes, moduleDeclaredTypes, ImmutableList.of());
    }

    public void computeBeforeAST(StandardTypes standardTypes, Collection<JDeclaredType> declaredTypes, Collection<JDeclaredType> moduleDeclaredTypes, Collection<String> deletedTypeNames) {
        this.standardTypes = standardTypes;
        this.recordReferenceTypeByName(declaredTypes);
        this.deleteImmediateTypeRelations(deletedTypeNames);
        this.deleteImmediateTypeRelations(JTypeOracle.getNamesOf(moduleDeclaredTypes));
        this.recordImmediateTypeRelations(moduleDeclaredTypes);
        this.computeExtendedTypeRelations();
    }

    private static Collection<String> getNamesOf(Collection<JDeclaredType> types) {
        ArrayList<String> typeNames = Lists.newArrayList();
        for (JDeclaredType type : types) {
            typeNames.add(type.getName());
        }
        return typeNames;
    }

    private void recordReferenceTypeByName(Collection<JDeclaredType> types) {
        this.referenceTypesByName.clear();
        for (JReferenceType jReferenceType : types) {
            this.referenceTypesByName.put(jReferenceType.getName(), jReferenceType);
        }
    }

    public JMethod getInstanceMethodBySignature(JClassType type, String signature) {
        return this.getOrCreateInstanceMethodsBySignatureForType(type).get(signature);
    }

    public JMethod findMostSpecificOverride(JClassType type, JMethod baseMethod) {
        JMethod foundMethod = this.getInstanceMethodBySignature(type, baseMethod.getSignature());
        if (foundMethod == baseMethod) {
            return foundMethod;
        }
        if (foundMethod != null && foundMethod.getOverriddenMethods().contains(baseMethod)) {
            return foundMethod;
        }
        if (foundMethod != null && baseMethod.isPackagePrivate() && type.getSuperClass() != null) {
            return this.findMostSpecificOverride(type.getSuperClass(), baseMethod);
        }
        assert (baseMethod.isAbstract());
        return baseMethod;
    }

    public JClassType getSingleJsoImpl(JReferenceType maybeSingleJsoIntf) {
        String className = this.jsoByInterface.get(maybeSingleJsoIntf.getName());
        if (className == null) {
            return null;
        }
        return (JClassType)this.referenceTypesByName.get(className);
    }

    public String getSuperTypeName(String className) {
        return (String)this.immediateTypeRelations.immediateSuperclassesByClass.get(className);
    }

    public Set<JReferenceType> getCastableDestinationTypes(JReferenceType type) {
        if (type instanceof JArrayType) {
            JArrayType arrayType = (JArrayType)type;
            ArrayList<JReferenceType> castableDestinationTypes = Lists.newArrayList();
            ImmutableList<JReferenceType> arrayBaseTypes = ImmutableList.of(this.ensureTypeExistsAndAppend(this.standardTypes.javaLangObject, castableDestinationTypes), this.ensureTypeExistsAndAppend(this.standardTypes.javaIoSerializable, castableDestinationTypes), this.ensureTypeExistsAndAppend(this.standardTypes.javaLangCloneable, castableDestinationTypes));
            for (int lowerDimension = 1; lowerDimension < arrayType.getDims(); ++lowerDimension) {
                for (JReferenceType arrayBaseType : arrayBaseTypes) {
                    castableDestinationTypes.add(this.arrayTypeCreator.getOrCreateArrayType(arrayBaseType, lowerDimension));
                }
            }
            if (arrayType.getLeafType().isPrimitiveType()) {
                castableDestinationTypes.add(arrayType);
            } else {
                JDeclaredType leafType = (JDeclaredType)arrayType.getLeafType();
                for (JReferenceType castableDestinationType : this.getCastableDestinationTypes(leafType)) {
                    JArrayType superArrayType = this.arrayTypeCreator.getOrCreateArrayType(castableDestinationType, arrayType.getDims());
                    castableDestinationTypes.add(superArrayType);
                }
            }
            Collections.sort(castableDestinationTypes, HasName.BY_NAME_COMPARATOR);
            return Sets.newLinkedHashSet(castableDestinationTypes);
        }
        ArrayList<JReferenceType> castableDestinationTypes = Lists.newArrayList();
        if (this.superclassesByClass.containsKey(type.getName())) {
            Iterables.addAll(castableDestinationTypes, this.getTypes(this.superclassesByClass.get(type.getName())));
        }
        if (this.superInterfacesByInterface.containsKey(type.getName())) {
            Iterables.addAll(castableDestinationTypes, this.getTypes(this.superInterfacesByInterface.get(type.getName())));
        }
        if (this.implementedInterfacesByClass.containsKey(type.getName())) {
            Iterables.addAll(castableDestinationTypes, this.getTypes(this.implementedInterfacesByClass.get(type.getName())));
        }
        if (type.isJsoType()) {
            this.ensureTypeExistsAndAppend("com.google.gwt.core.client.JavaScriptObject", castableDestinationTypes);
        } else {
            castableDestinationTypes.add(type);
        }
        JReferenceType javaLangObjectType = this.referenceTypesByName.get(this.standardTypes.javaLangObject);
        assert (javaLangObjectType != null);
        castableDestinationTypes.add(javaLangObjectType);
        Collections.sort(castableDestinationTypes, HasName.BY_NAME_COMPARATOR);
        return Sets.newLinkedHashSet(castableDestinationTypes);
    }

    public boolean isDualJsoInterface(JType maybeDualImpl) {
        return this.dualImplInterfaces.contains(maybeDualImpl.getName());
    }

    public boolean isEffectivelyJavaScriptObject(JType type) {
        return type.isJsoType() || this.isSingleJsoImpl(type) && !this.isDualJsoInterface(type);
    }

    private boolean isJavaScriptObject(String typeName) {
        if (typeName.equals("com.google.gwt.core.client.JavaScriptObject")) {
            return true;
        }
        return this.isSuperClass(typeName, "com.google.gwt.core.client.JavaScriptObject");
    }

    public boolean isInstantiatedType(JDeclaredType type) {
        return this.instantiatedTypes == null || this.instantiatedTypes.contains(type);
    }

    public boolean isInstantiatedType(JReferenceType type) {
        JArrayType arrayType;
        type = type.getUnderlyingType();
        if (this.instantiatedTypes == null || this.instantiatedTypes.contains(type)) {
            return true;
        }
        if (type.isExternal()) {
            return true;
        }
        if (type.isNullType()) {
            return true;
        }
        return type instanceof JArrayType && (arrayType = (JArrayType)type).getLeafType().isNullType();
    }

    private boolean isArrayInterface(JType type) {
        return type.getName().equals(this.standardTypes.javaIoSerializable) || type.getName().equals(this.standardTypes.javaLangCloneable);
    }

    private boolean isJavaLangObject(JType type) {
        if (!(type instanceof JClassType)) {
            return false;
        }
        JClassType classType = (JClassType)type;
        assert (classType.getSuperClass() == null == classType.getName().equals(this.standardTypes.javaLangObject));
        return classType.getSuperClass() == null;
    }

    public boolean isSingleJsoImpl(JType type) {
        return type instanceof JReferenceType && this.getSingleJsoImpl((JReferenceType)type) != null;
    }

    public boolean isSubClass(JClassType type, JClassType possibleSubType) {
        return this.subclassesByClass.containsEntry(type.getName(), possibleSubType.getName());
    }

    public boolean isSubType(JDeclaredType type, JDeclaredType possibleSubType) {
        return this.subclassesByClass.containsEntry(type.getName(), possibleSubType.getName()) || this.classesByImplementingInterface.containsEntry(type.getName(), possibleSubType.getName()) || this.subInterfacesByInterface.containsEntry(type.getName(), possibleSubType.getName());
    }

    public Iterable<String> getSubTypeNames(String typeName) {
        return Iterables.concat(this.classesByImplementingInterface.get(typeName), this.subclassesByClass.get(typeName), this.subInterfacesByInterface.get(typeName));
    }

    public Set<String> getSubClassNames(String typeName) {
        return (Set)this.subclassesByClass.get(typeName);
    }

    public Set<String> getSubInterfaceNames(String typeName) {
        return (Set)this.subInterfacesByInterface.get(typeName);
    }

    public boolean isSuperClass(JReferenceType type, JReferenceType possibleSuperClass) {
        return this.isSuperClass(type.getName(), possibleSuperClass.getName());
    }

    public boolean isSuperClassOrInterface(JReferenceType fromType, JReferenceType toType) {
        return this.isSuperClass(fromType, toType) || this.implementsInterface(fromType, toType) || this.extendsInterface(fromType, toType);
    }

    public void recomputeAfterOptimizations(Collection<JDeclaredType> declaredTypes) {
        Set<JDeclaredType> computed = Sets.newIdentityHashSet();
        assert (this.optimize);
        for (JDeclaredType type : declaredTypes) {
            this.computeClinitTarget(type, computed);
        }
        Iterator<String> it = this.dualImplInterfaces.iterator();
        block1: while (it.hasNext()) {
            String dualIntf = it.next();
            for (String implementorName : this.classesByImplementingInterface.get(dualIntf)) {
                JClassType implementor = (JClassType)this.referenceTypesByName.get(implementorName);
                assert (implementor != null);
                if (!this.isInstantiatedType(implementor) || implementor.isJsoType()) continue;
                continue block1;
            }
            it.remove();
        }
        Iterator<Map.Entry<String, String>> jit = this.jsoByInterface.entrySet().iterator();
        while (jit.hasNext()) {
            Map.Entry<String, String> jsoSingleImplEntry = jit.next();
            JClassType clazz = (JClassType)this.referenceTypesByName.get(jsoSingleImplEntry.getValue());
            if (this.isInstantiatedType(clazz)) continue;
            this.dualImplInterfaces.remove(jsoSingleImplEntry.getKey());
            jit.remove();
        }
    }

    public void setInstantiatedTypes(Set<JReferenceType> instantiatedTypes) {
        this.instantiatedTypes = instantiatedTypes;
        this.methodsBySignatureForType.keySet().retainAll(instantiatedTypes);
    }

    private void deleteImmediateTypeRelations(final Collection<String> typeNames) {
        Predicate<Map.Entry<String, String>> inToDeleteSet = new Predicate<Map.Entry<String, String>>(){

            @Override
            public boolean apply(Map.Entry<String, String> typeTypeEntry) {
                return typeNames.contains(typeTypeEntry.getKey());
            }
        };
        Maps.filterEntries(this.immediateTypeRelations.immediateSuperclassesByClass, inToDeleteSet).clear();
        Multimaps.filterEntries(this.immediateTypeRelations.immediateImplementedInterfacesByClass, inToDeleteSet).clear();
        Multimaps.filterEntries(this.immediateTypeRelations.immediateSuperInterfacesByInterface, inToDeleteSet).clear();
    }

    private void recordImmediateTypeRelations(Iterable<JDeclaredType> types) {
        for (JReferenceType jReferenceType : types) {
            if (jReferenceType instanceof JClassType) {
                JClassType jClassType = (JClassType)jReferenceType;
                JClassType superClass = jClassType.getSuperClass();
                if (superClass != null) {
                    this.immediateTypeRelations.immediateSuperclassesByClass.put(jClassType.getName(), superClass.getName());
                }
                this.immediateTypeRelations.immediateImplementedInterfacesByClass.putAll(jReferenceType.getName(), Iterables.transform(jClassType.getImplements(), TYPE_TO_NAME));
                continue;
            }
            if (!(jReferenceType instanceof JInterfaceType)) continue;
            JInterfaceType currentIntf = (JInterfaceType)jReferenceType;
            this.immediateTypeRelations.immediateSuperInterfacesByInterface.putAll(jReferenceType.getName(), Iterables.transform(currentIntf.getImplements(), TYPE_TO_NAME));
        }
    }

    private void computeExtendedTypeRelations() {
        this.computeAllClasses();
        this.computeClassMaps();
        this.computeInterfaceMaps();
        this.computeImplementsMaps();
        this.computePotentialImplementMap();
        this.computeSingleJSO();
        this.computeDualJSO();
    }

    private void computeAllClasses() {
        this.allClasses.clear();
        this.allClasses.addAll(this.immediateTypeRelations.immediateSuperclassesByClass.values());
        this.allClasses.addAll(this.immediateTypeRelations.immediateSuperclassesByClass.keySet());
    }

    private void computePotentialImplementMap() {
        HashMultimap<String, String> reflexiveSubtypes = HashMultimap.create();
        reflexiveSubtypes.putAll(this.subclassesByClass);
        this.reflexiveClosure(reflexiveSubtypes, this.allClasses);
        this.potentialInterfaceByClass = ImmutableSetMultimap.copyOf(this.compose(reflexiveSubtypes, this.implementedInterfacesByClass));
    }

    private void computeDualJSO() {
        this.dualImplInterfaces.clear();
        block0: for (String jsoIntfName : this.jsoByInterface.keySet()) {
            for (String implementor : this.classesByImplementingInterface.get(jsoIntfName)) {
                if (this.isJavaScriptObject(implementor)) continue;
                this.dualImplInterfaces.add(jsoIntfName);
                continue block0;
            }
        }
    }

    private void computeImplementsMaps() {
        HashMultimap<String, String> superTypesByType = HashMultimap.create();
        superTypesByType.putAll(this.immediateTypeRelations.immediateImplementedInterfacesByClass);
        superTypesByType.putAll(Multimaps.forMap(this.immediateTypeRelations.immediateSuperclassesByClass));
        superTypesByType.putAll(this.immediateTypeRelations.immediateSuperInterfacesByInterface);
        Multimap<String, String> superTypesByTypeClosure = this.transitiveClosure(superTypesByType);
        this.implementedInterfacesByClass = ImmutableSetMultimap.copyOf(Multimaps.filterEntries(superTypesByTypeClosure, new Predicate<Map.Entry<String, String>>(){

            @Override
            public boolean apply(Map.Entry<String, String> typeTypeEntry) {
                return JTypeOracle.this.allClasses.contains(typeTypeEntry.getKey()) && !JTypeOracle.this.allClasses.contains(typeTypeEntry.getValue());
            }
        }));
        this.classesByImplementingInterface = ImmutableSetMultimap.copyOf(this.inverse(this.implementedInterfacesByClass));
    }

    private void computeSingleJSO() {
        this.jsoByInterface.clear();
        for (String jsoSubType : this.subclassesByClass.get("com.google.gwt.core.client.JavaScriptObject")) {
            for (String intf : this.immediateTypeRelations.immediateImplementedInterfacesByClass.get(jsoSubType)) {
                this.jsoByInterface.put(intf, jsoSubType);
                for (String superIntf : this.superInterfacesByInterface.get(intf)) {
                    if (this.jsoByInterface.containsKey(superIntf)) continue;
                    this.jsoByInterface.put(superIntf, jsoSubType);
                }
            }
        }
    }

    private void computeClassMaps() {
        this.superclassesByClass = ImmutableSetMultimap.copyOf(this.transitiveClosure(Multimaps.forMap(this.immediateTypeRelations.immediateSuperclassesByClass)));
        this.subclassesByClass = ImmutableSetMultimap.copyOf(this.inverse(this.superclassesByClass));
    }

    private void computeInterfaceMaps() {
        this.superInterfacesByInterface = ImmutableSetMultimap.copyOf(this.transitiveClosure(this.immediateTypeRelations.immediateSuperInterfacesByInterface));
        this.subInterfacesByInterface = ImmutableSetMultimap.copyOf(this.inverse(this.superInterfacesByInterface));
    }

    private void computeClinitTarget(JDeclaredType type, Set<JDeclaredType> computed) {
        if (type.isExternal() || !type.hasClinit() || computed.contains(type)) {
            return;
        }
        JClassType superClass = null;
        if (type instanceof JClassType) {
            superClass = ((JClassType)type).getSuperClass();
        }
        if (superClass != null) {
            this.computeClinitTarget(superClass, computed);
        }
        if (type.getClinitTarget() != type) {
            type.setClinitTarget(superClass.getClinitTarget());
        } else {
            JDeclaredType target = this.computeClinitTargetRecursive(type, computed, Sets.newIdentityHashSet());
            type.setClinitTarget(target);
        }
        computed.add(type);
    }

    private JDeclaredType computeClinitTargetRecursive(JDeclaredType type, Set<JDeclaredType> computed, Set<JDeclaredType> alreadySeen) {
        JDeclaredType singleTarget;
        alreadySeen.add(type);
        JMethod method = type.getClinitMethod();
        assert (JProgram.isClinit(method));
        CheckClinitVisitor v = new CheckClinitVisitor();
        v.accept(method);
        if (v.hasLiveCode()) {
            return type;
        }
        Set<JDeclaredType> clinitTargets = v.getClinitTargets();
        if (clinitTargets.size() == 1 && this.isSuperClass(type, singleTarget = (JDeclaredType)clinitTargets.iterator().next())) {
            return singleTarget.getClinitTarget();
        }
        for (JDeclaredType target : clinitTargets) {
            if (!target.hasClinit()) continue;
            if (target.hasClinit() && computed.contains(target)) {
                return type;
            }
            if (alreadySeen.contains(target) || this.computeClinitTargetRecursive(target, computed, alreadySeen) == null) continue;
            return type;
        }
        return null;
    }

    private JReferenceType ensureTypeExistsAndAppend(String typeName, List<JReferenceType> types) {
        JReferenceType type = this.referenceTypesByName.get(typeName);
        assert (type != null);
        types.add(type);
        return type;
    }

    private Iterable<JReferenceType> getTypes(Iterable<String> typeNameSet) {
        return Iterables.transform(typeNameSet, new Function<String, JReferenceType>(){

            @Override
            public JReferenceType apply(String typeName) {
                JReferenceType referenceType = (JReferenceType)JTypeOracle.this.referenceTypesByName.get(typeName);
                assert (referenceType != null);
                return referenceType;
            }
        });
    }

    private Map<String, JMethod> getOrCreateInstanceMethodsBySignatureForType(JClassType type) {
        Map<String, JMethod> methodsBySignature = this.methodsBySignatureForType.get(type);
        if (methodsBySignature == null) {
            methodsBySignature = Maps.newLinkedHashMap();
            JClassType superClass = type.getSuperClass();
            Map parentMethods = superClass == null ? Collections.emptyMap() : this.getOrCreateInstanceMethodsBySignatureForType(type.getSuperClass());
            for (JMethod method : parentMethods.values()) {
                if (!method.canBePolymorphic()) continue;
                methodsBySignature.put(method.getSignature(), method);
            }
            for (JMethod method : type.getMethods()) {
                if (method.isStatic()) continue;
                methodsBySignature.put(method.getSignature(), method);
            }
            this.methodsBySignatureForType.put(type, methodsBySignature);
        }
        return methodsBySignature;
    }

    private void reflexiveClosure(Multimap<String, String> relation, Iterable<String> domain) {
        for (String element : domain) {
            relation.put(element, element);
        }
    }

    private Multimap<String, String> transitiveClosure(Multimap<String, String> relation) {
        LinkedHashMultimap<String, String> transitiveClosure = LinkedHashMultimap.create();
        LinkedHashSet<String> domain = Sets.newLinkedHashSet(relation.keySet());
        domain.addAll(relation.values());
        for (String element : domain) {
            this.expandTransitiveClosureForElement(relation, element, transitiveClosure);
        }
        return transitiveClosure;
    }

    private Collection<String> expandTransitiveClosureForElement(Multimap<String, String> relation, String element, Multimap<String, String> transitiveClosure) {
        Collection<String> preComputedExpansion = transitiveClosure.get(element);
        if (!preComputedExpansion.isEmpty()) {
            return preComputedExpansion;
        }
        HashSet<String> transitiveExpansion = Sets.newHashSet();
        Collection<String> immediateSuccessors = relation.get(element);
        transitiveExpansion.addAll(immediateSuccessors);
        for (String child : immediateSuccessors) {
            transitiveExpansion.addAll(this.expandTransitiveClosureForElement(relation, child, transitiveClosure));
        }
        transitiveClosure.putAll(element, transitiveExpansion);
        return transitiveExpansion;
    }

    private <A, B, C> Multimap<A, C> compose(Multimap<A, B> f, Multimap<B, C> g) {
        HashMultimap<A, C> composition = HashMultimap.create();
        for (A a : f.keySet()) {
            for (B b : f.get(a)) {
                composition.putAll(a, g.get(b));
            }
        }
        return composition;
    }

    private <K, V> Multimap<V, K> inverse(Multimap<K, V> relation) {
        HashMultimap inverse = HashMultimap.create();
        Multimaps.invertFrom(relation, inverse);
        return inverse;
    }

    private boolean extendsInterface(JReferenceType type, JReferenceType qType) {
        return this.superInterfacesByInterface.containsEntry(type.getName(), qType.getName());
    }

    private boolean implementsInterface(JReferenceType type, JReferenceType interfaceType) {
        return this.implementedInterfacesByClass.containsEntry(type.getName(), interfaceType.getName());
    }

    private boolean isSuperClass(String type, String potentialSuperClass) {
        return this.subclassesByClass.containsEntry(potentialSuperClass, type);
    }

    private static final class CheckClinitVisitor
    extends JVisitor {
        private final Set<JDeclaredType> clinitTargets = Sets.newLinkedHashSet();
        private boolean hasLiveCode = false;

        private CheckClinitVisitor() {
        }

        public Set<JDeclaredType> getClinitTargets() {
            return this.clinitTargets;
        }

        public boolean hasLiveCode() {
            return this.hasLiveCode;
        }

        @Override
        public boolean visit(JBlock x, Context ctx) {
            for (JStatement stmt : x.getStatements()) {
                if (this.mightContainOnlyClinitCallsOrDeclarationStatements(stmt)) {
                    this.accept(stmt);
                    continue;
                }
                this.hasLiveCode = true;
            }
            return false;
        }

        @Override
        public boolean visit(JDeclarationStatement x, Context ctx) {
            JVariable target = x.getVariableRef().getTarget();
            if (target instanceof JField) {
                JField field = (JField)target;
                assert (field.isStatic());
                if (field.getLiteralInitializer() != null) {
                    return false;
                }
            }
            this.hasLiveCode = true;
            return false;
        }

        @Override
        public boolean visit(JExpressionStatement x, Context ctx) {
            JExpression expr = x.getExpr();
            if (this.mightContainOnlyClinitCalls(expr)) {
                this.accept(expr);
            } else {
                this.hasLiveCode = true;
            }
            return false;
        }

        @Override
        public boolean visit(JMethodCall x, Context ctx) {
            JMethod target = x.getTarget();
            if (JProgram.isClinit(target)) {
                this.clinitTargets.add(target.getEnclosingType());
            } else {
                this.hasLiveCode = true;
            }
            return false;
        }

        @Override
        public boolean visit(JMultiExpression x, Context ctx) {
            for (JExpression expr : x.getExpressions()) {
                if (this.mightContainOnlyClinitCalls(expr)) {
                    this.accept(expr);
                    continue;
                }
                this.hasLiveCode = true;
            }
            return false;
        }

        private boolean mightContainOnlyClinitCalls(JExpression expr) {
            return expr instanceof JMultiExpression || expr instanceof JMethodCall;
        }

        private boolean mightContainOnlyClinitCallsOrDeclarationStatements(JStatement stmt) {
            return stmt instanceof JBlock || stmt instanceof JExpressionStatement || stmt instanceof JDeclarationStatement;
        }
    }

    public static class StandardTypes
    implements Serializable {
        private String javaIoSerializable;
        private String javaLangCloneable;
        private String javaLangObject;

        public static StandardTypes createFrom(JProgram program) {
            StandardTypes requiredTypes = new StandardTypes();
            requiredTypes.javaLangObject = program.getTypeJavaLangObject().getName();
            JDeclaredType javaIoSerializableType = program.getFromTypeMap(Serializable.class.getName());
            requiredTypes.javaIoSerializable = javaIoSerializableType == null ? null : javaIoSerializableType.getName();
            JDeclaredType javaLangConeableType = program.getFromTypeMap(Cloneable.class.getName());
            requiredTypes.javaLangCloneable = javaLangConeableType == null ? null : javaLangConeableType.getName();
            return requiredTypes;
        }
    }

    public static class ImmediateTypeRelations
    implements Serializable {
        private Map<String, String> immediateSuperclassesByClass = Maps.newHashMap();
        private Multimap<String, String> immediateSuperInterfacesByInterface = HashMultimap.create();
        private Multimap<String, String> immediateImplementedInterfacesByClass = HashMultimap.create();

        public void copyFrom(ImmediateTypeRelations that) {
            this.immediateImplementedInterfacesByClass.clear();
            this.immediateSuperclassesByClass.clear();
            this.immediateSuperInterfacesByInterface.clear();
            this.immediateImplementedInterfacesByClass.putAll(that.immediateImplementedInterfacesByClass);
            this.immediateSuperclassesByClass.putAll(that.immediateSuperclassesByClass);
            this.immediateSuperInterfacesByInterface.putAll(that.immediateSuperInterfacesByInterface);
        }

        @VisibleForTesting
        public boolean hasSameContent(ImmediateTypeRelations that) {
            return Objects.equal(this.immediateImplementedInterfacesByClass, that.immediateImplementedInterfacesByClass) && Objects.equal(this.immediateSuperclassesByClass, that.immediateSuperclassesByClass) && Objects.equal(this.immediateSuperInterfacesByInterface, that.immediateSuperInterfacesByInterface);
        }

        @VisibleForTesting
        public Map<String, String> getImmediateSuperclassesByClass() {
            return this.immediateSuperclassesByClass;
        }

        public boolean isEmpty() {
            return this.immediateSuperclassesByClass.isEmpty() && this.immediateSuperInterfacesByInterface.isEmpty() && this.immediateImplementedInterfacesByClass.isEmpty();
        }
    }
}

