/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.CanBeFinal;
import com.google.gwt.dev.jjs.ast.HasName;
import com.google.gwt.dev.jjs.ast.JEnumType;
import com.google.gwt.dev.jjs.ast.JLiteral;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.util.StringInterner;
import java.util.List;

public abstract class JType
extends JNode
implements HasName,
CanBeFinal {
    protected final String name;
    private String shortName = null;
    private String packageName = null;

    static boolean replaces(List<? extends JType> newTypes, List<? extends JType> oldTypes) {
        if (newTypes.size() != oldTypes.size()) {
            return false;
        }
        int c = newTypes.size();
        for (int i = 0; i < c; ++i) {
            if (newTypes.get(i).replaces(oldTypes.get(i))) continue;
            return false;
        }
        return true;
    }

    public JType(SourceInfo info, String name) {
        super(info);
        this.name = StringInterner.get().intern(name);
    }

    public abstract boolean canBeNull();

    public abstract boolean isArrayType();

    public abstract boolean isPrimitiveType();

    public boolean isNullType() {
        return false;
    }

    public abstract boolean isJsType();

    public abstract boolean isJsFunction();

    public abstract boolean isJsFunctionImplementation();

    public abstract boolean isJsNative();

    public abstract boolean canBeImplementedExternally();

    public abstract boolean canBeReferencedExternally();

    public abstract boolean isJavaLangObject();

    public abstract boolean isJsoType();

    public abstract boolean canBeSubclass();

    public abstract JType strengthenToNonNull();

    public abstract JLiteral getDefaultValue();

    public abstract String getJavahSignatureName();

    public abstract String getJsniSignatureName();

    public String getShortName() {
        if (this.shortName == null) {
            this.shortName = StringInterner.get().intern(this.name.substring(this.name.lastIndexOf(46) + 1));
        }
        return this.shortName;
    }

    public String[] getCompoundName() {
        return new String[]{this.getShortName()};
    }

    public String getDescription() {
        return this.getName();
    }

    public JType getUnderlyingType() {
        return this;
    }

    public String getPackageName() {
        if (this.packageName == null) {
            int dotpos = this.name.lastIndexOf(46);
            this.packageName = StringInterner.get().intern(this.name.substring(0, dotpos < 0 ? 0 : dotpos));
        }
        return this.packageName;
    }

    public abstract JEnumType isEnumOrSubclass();

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isExternal() {
        return false;
    }

    public boolean replaces(JType originalType) {
        if (this == originalType) {
            return true;
        }
        return originalType.isExternal() && originalType.getName().equals(this.getName());
    }
}

