/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JLocalRef;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;
import java.io.Serializable;
import java.util.List;

public class JTryStatement
extends JStatement {
    private final List<CatchClause> catchClauses;
    private final JBlock finallyBlock;
    private final JBlock tryBlock;

    public JTryStatement(SourceInfo info, JBlock tryBlock, List<CatchClause> catchClauses, JBlock finallyBlock) {
        super(info);
        this.tryBlock = tryBlock;
        this.catchClauses = catchClauses;
        this.finallyBlock = finallyBlock;
    }

    public List<CatchClause> getCatchClauses() {
        return this.catchClauses;
    }

    public JBlock getFinallyBlock() {
        return this.finallyBlock;
    }

    public JBlock getTryBlock() {
        return this.tryBlock;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            visitor.accept(this.tryBlock);
            for (CatchClause clause : this.catchClauses) {
                visitor.accept(clause.getArg());
                visitor.accept(clause.getBlock());
            }
            if (this.finallyBlock != null) {
                visitor.accept(this.finallyBlock);
            }
        }
        visitor.endVisit(this, ctx);
    }

    public static class CatchClause
    implements Serializable {
        private final List<JType> catchTypes;
        private final JLocalRef arg;
        private final JBlock block;

        public CatchClause(List<JType> catchTypes, JLocalRef arg, JBlock block) {
            this.catchTypes = catchTypes;
            this.arg = arg;
            this.block = block;
        }

        public List<JType> getTypes() {
            return this.catchTypes;
        }

        public JLocalRef getArg() {
            return this.arg;
        }

        public JBlock getBlock() {
            return this.block;
        }
    }
}

