/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JAbstractMethodBody;
import com.google.gwt.dev.jjs.ast.JArrayLength;
import com.google.gwt.dev.jjs.ast.JArrayRef;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JAssertStatement;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JBooleanLiteral;
import com.google.gwt.dev.jjs.ast.JBreakStatement;
import com.google.gwt.dev.jjs.ast.JCaseStatement;
import com.google.gwt.dev.jjs.ast.JCastMap;
import com.google.gwt.dev.jjs.ast.JCastOperation;
import com.google.gwt.dev.jjs.ast.JCharLiteral;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConditional;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JContinueStatement;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JDoStatement;
import com.google.gwt.dev.jjs.ast.JDoubleLiteral;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JExpressionStatement;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JFloatLiteral;
import com.google.gwt.dev.jjs.ast.JForStatement;
import com.google.gwt.dev.jjs.ast.JIfStatement;
import com.google.gwt.dev.jjs.ast.JInstanceOf;
import com.google.gwt.dev.jjs.ast.JIntLiteral;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JLabel;
import com.google.gwt.dev.jjs.ast.JLabeledStatement;
import com.google.gwt.dev.jjs.ast.JLiteral;
import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JLocalRef;
import com.google.gwt.dev.jjs.ast.JLongLiteral;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNameOf;
import com.google.gwt.dev.jjs.ast.JNewArray;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JNullLiteral;
import com.google.gwt.dev.jjs.ast.JNumericEntry;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JParameterRef;
import com.google.gwt.dev.jjs.ast.JPermutationDependentValue;
import com.google.gwt.dev.jjs.ast.JPostfixOperation;
import com.google.gwt.dev.jjs.ast.JPrefixOperation;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JReturnStatement;
import com.google.gwt.dev.jjs.ast.JRunAsync;
import com.google.gwt.dev.jjs.ast.JRuntimeTypeReference;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JStringLiteral;
import com.google.gwt.dev.jjs.ast.JSwitchExpression;
import com.google.gwt.dev.jjs.ast.JSwitchStatement;
import com.google.gwt.dev.jjs.ast.JThisRef;
import com.google.gwt.dev.jjs.ast.JThrowStatement;
import com.google.gwt.dev.jjs.ast.JTryStatement;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JUnaryOperation;
import com.google.gwt.dev.jjs.ast.JUnsafeTypeCoercion;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.ast.JVariableRef;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.JWhileStatement;
import com.google.gwt.dev.jjs.ast.JYieldStatement;
import com.google.gwt.dev.jjs.ast.js.JDebuggerStatement;
import com.google.gwt.dev.jjs.ast.js.JMultiExpression;
import com.google.gwt.dev.jjs.ast.js.JsniClassLiteral;
import com.google.gwt.dev.jjs.ast.js.JsniFieldRef;
import com.google.gwt.dev.jjs.ast.js.JsniMethodBody;
import com.google.gwt.dev.jjs.ast.js.JsniMethodRef;
import com.google.gwt.dev.jjs.ast.js.JsonArray;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class JTransformer<T> {
    public T transformAbstractMethodBody(JAbstractMethodBody x) {
        return this.missing(x);
    }

    public T transformArrayLength(JArrayLength x) {
        return this.transformExpression(x);
    }

    public T transformArrayRef(JArrayRef x) {
        return this.transformExpression(x);
    }

    public T transformArrayType(JArrayType x) {
        return this.transformReferenceType(x);
    }

    public T transformAssertStatement(JAssertStatement x) {
        return this.transformStatement(x);
    }

    public T transformBinaryOperation(JBinaryOperation x) {
        return this.transformExpression(x);
    }

    public T transformBlock(JBlock x) {
        return this.transformStatement(x);
    }

    public T transformBooleanLiteral(JBooleanLiteral x) {
        return this.transformValueLiteral(x);
    }

    public T transformBreakStatement(JBreakStatement x) {
        return this.transformStatement(x);
    }

    public T transformCaseStatement(JCaseStatement x) {
        return this.transformStatement(x);
    }

    public T transformCastMap(JCastMap x) {
        return this.transformExpression(x);
    }

    public T transformCastOperation(JCastOperation x) {
        return this.transformExpression(x);
    }

    public T transformCharLiteral(JCharLiteral x) {
        return this.transformValueLiteral(x);
    }

    public T transformClassLiteral(JClassLiteral x) {
        return this.transformLiteral(x);
    }

    public T transformClassType(JClassType x) {
        return this.transformDeclaredType(x);
    }

    public T transformConditional(JConditional x) {
        return this.transformExpression(x);
    }

    public T transformConstructor(JConstructor x) {
        return this.transformMethod(x);
    }

    public T transformContinueStatement(JContinueStatement x) {
        return this.transformStatement(x);
    }

    public T transformDebuggerStatement(JDebuggerStatement x) {
        return this.transformStatement(x);
    }

    public T transformDeclarationStatement(JDeclarationStatement x) {
        return this.transformStatement(x);
    }

    public T transformDeclaredType(JDeclaredType x) {
        return this.transformReferenceType(x);
    }

    public T transformDoStatement(JDoStatement x) {
        return this.transformStatement(x);
    }

    public T transformDoubleLiteral(JDoubleLiteral x) {
        return this.transformValueLiteral(x);
    }

    public T transformExpression(JExpression x) {
        return this.missing(x);
    }

    public T transformExpressionStatement(JExpressionStatement x) {
        return this.transformStatement(x);
    }

    public T transformField(JField x) {
        return this.transformVariable(x);
    }

    public T transformFieldRef(JFieldRef x) {
        return this.transformVariableRef(x);
    }

    public T transformFloatLiteral(JFloatLiteral x) {
        return this.transformValueLiteral(x);
    }

    public T transformForStatement(JForStatement x) {
        return this.transformStatement(x);
    }

    public T transformIfStatement(JIfStatement x) {
        return this.transformStatement(x);
    }

    public T transformInstanceOf(JInstanceOf x) {
        return this.transformExpression(x);
    }

    public T transformInterfaceType(JInterfaceType x) {
        return this.transformDeclaredType(x);
    }

    public T transformIntLiteral(JIntLiteral x) {
        return this.transformValueLiteral(x);
    }

    public T transformLabel(JLabel x) {
        return this.missing(x);
    }

    public T transformLabeledStatement(JLabeledStatement x) {
        return this.transformStatement(x);
    }

    public T transformLiteral(JLiteral x) {
        return this.transformExpression(x);
    }

    public T transformLocal(JLocal x) {
        return this.transformVariable(x);
    }

    public T transformLocalRef(JLocalRef x) {
        return this.transformVariableRef(x);
    }

    public T transformLongLiteral(JLongLiteral x) {
        return this.transformValueLiteral(x);
    }

    public T transformMethod(JMethod x) {
        return this.missing(x);
    }

    public T transformMethodBody(JMethodBody x) {
        return this.transformAbstractMethodBody(x);
    }

    public T transformMethodCall(JMethodCall x) {
        return this.transformExpression(x);
    }

    public T transformMultiExpression(JMultiExpression x) {
        return this.transformExpression(x);
    }

    public T transformNameOf(JNameOf x) {
        return this.transformExpression(x);
    }

    public T transformNewArray(JNewArray x) {
        return this.transformExpression(x);
    }

    public T transformNewInstance(JNewInstance x) {
        return this.transformMethodCall(x);
    }

    public T missing(JNode x) {
        throw new InternalCompilerException("Missing transform for " + x + " (" + x.getClass().getSimpleName() + ")");
    }

    public T transformNullLiteral(JNullLiteral x) {
        return this.transformValueLiteral(x);
    }

    public T transformNumericEntry(JNumericEntry x) {
        return this.transformExpression(x);
    }

    public T transformParameter(JParameter x) {
        return this.transformVariable(x);
    }

    public T transformParameterRef(JParameterRef x) {
        return this.transformVariableRef(x);
    }

    public T transformPermutationDependentValue(JPermutationDependentValue x) {
        return this.transformExpression(x);
    }

    public T transformPostfixOperation(JPostfixOperation x) {
        return this.transformUnaryOperation(x);
    }

    public T transformPrefixOperation(JPrefixOperation x) {
        return this.transformUnaryOperation(x);
    }

    public T transformPrimitiveType(JPrimitiveType x) {
        return this.transformType(x);
    }

    public T transformProgram(JProgram x) {
        return this.missing(x);
    }

    public T transformReferenceType(JReferenceType x) {
        return this.transformType(x);
    }

    public T transformReturnStatement(JReturnStatement x) {
        return this.transformStatement(x);
    }

    public T transformRunAsync(JRunAsync x) {
        return this.transformExpression(x);
    }

    public T transformRuntimeTypeReference(JRuntimeTypeReference x) {
        return this.transformExpression(x);
    }

    public T transformJsniClassLiteral(JsniClassLiteral x) {
        return this.transformClassLiteral(x);
    }

    public T transformJsniFieldRef(JsniFieldRef x) {
        return this.transformFieldRef(x);
    }

    public T transformJsniMethodBody(JsniMethodBody x) {
        return this.transformAbstractMethodBody(x);
    }

    public T transformJsniMethodRef(JsniMethodRef x) {
        return this.transformMethodCall(x);
    }

    public T transformJsonArray(JsonArray x) {
        return this.transformExpression(x);
    }

    public T transformStatement(JStatement x) {
        return this.missing(x);
    }

    public T transformStringLiteral(JStringLiteral x) {
        return this.transformValueLiteral(x);
    }

    public T transformSwitchExpression(JSwitchExpression x) {
        return this.transformExpression(x);
    }

    public T transformSwitchStatement(JSwitchStatement x) {
        return this.transformStatement(x);
    }

    public T transformThisRef(JThisRef x) {
        return this.transformExpression(x);
    }

    public T transformThrowStatement(JThrowStatement x) {
        return this.transformStatement(x);
    }

    public T transformTryStatement(JTryStatement x) {
        return this.transformStatement(x);
    }

    public T transformType(JType x) {
        return this.missing(x);
    }

    public T transformUnaryOperation(JUnaryOperation x) {
        return this.transformExpression(x);
    }

    public T transformValueLiteral(JValueLiteral x) {
        return this.transformLiteral(x);
    }

    public T transformVariable(JVariable x) {
        return this.missing(x);
    }

    public T transformVariableRef(JVariableRef x) {
        return this.transformExpression(x);
    }

    public T transformUnsafeTypeCoercion(JUnsafeTypeCoercion x) {
        return this.transformExpression(x);
    }

    public T transformWhileStatement(JWhileStatement x) {
        return this.transformStatement(x);
    }

    public T transformYieldStatement(JYieldStatement x) {
        return this.transformStatement(x);
    }

    public final <T> T transform(JNode node) {
        if (node == null) {
            return null;
        }
        JRewriterVisitor visitor = new JRewriterVisitor();
        visitor.accept(node);
        return visitor.result;
    }

    public final <T, U extends JNode> List<T> transform(List<U> nodes) {
        ArrayList result = Lists.newArrayListWithCapacity(nodes.size());
        this.transformInto(nodes, result);
        return result;
    }

    public final <T, U extends JNode> void transformInto(List<U> nodes, List<T> transformedNodes) {
        for (JNode node : nodes) {
            transformedNodes.add(this.transform(node));
        }
    }

    public final <T, U extends JNode> void transformIntoExcludingNulls(List<U> nodes, List<T> transformedNodes) {
        for (JNode node : nodes) {
            T transformed = this.transform(node);
            if (transformed == null) continue;
            transformedNodes.add(transformed);
        }
    }

    private class JRewriterVisitor
    extends JVisitor {
        T result = null;

        private JRewriterVisitor() {
        }

        @Override
        public boolean didChange() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final void endVisit(JAbstractMethodBody x, Context ctx) {
        }

        @Override
        public final void endVisit(JArrayLength x, Context ctx) {
        }

        @Override
        public final void endVisit(JArrayRef x, Context ctx) {
        }

        @Override
        public final void endVisit(JArrayType x, Context ctx) {
        }

        @Override
        public final void endVisit(JAssertStatement x, Context ctx) {
        }

        @Override
        public final void endVisit(JBinaryOperation x, Context ctx) {
        }

        @Override
        public final void endVisit(JBlock x, Context ctx) {
        }

        @Override
        public final void endVisit(JBooleanLiteral x, Context ctx) {
        }

        @Override
        public final void endVisit(JBreakStatement x, Context ctx) {
        }

        @Override
        public final void endVisit(JCaseStatement x, Context ctx) {
        }

        @Override
        public final void endVisit(JCastMap x, Context ctx) {
        }

        @Override
        public final void endVisit(JCastOperation x, Context ctx) {
        }

        @Override
        public final void endVisit(JCharLiteral x, Context ctx) {
        }

        @Override
        public final void endVisit(JClassLiteral x, Context ctx) {
        }

        @Override
        public final void endVisit(JClassType x, Context ctx) {
        }

        @Override
        public final void endVisit(JConditional x, Context ctx) {
        }

        @Override
        public final void endVisit(JConstructor x, Context ctx) {
        }

        @Override
        public final void endVisit(JContinueStatement x, Context ctx) {
        }

        @Override
        public final void endVisit(JDebuggerStatement x, Context ctx) {
        }

        @Override
        public final void endVisit(JDeclarationStatement x, Context ctx) {
        }

        @Override
        public final void endVisit(JDeclaredType x, Context ctx) {
        }

        @Override
        public final void endVisit(JDoStatement x, Context ctx) {
        }

        @Override
        public final void endVisit(JDoubleLiteral x, Context ctx) {
        }

        @Override
        public final void endVisit(JExpression x, Context ctx) {
        }

        @Override
        public final void endVisit(JExpressionStatement x, Context ctx) {
        }

        @Override
        public final void endVisit(JField x, Context ctx) {
        }

        @Override
        public final void endVisit(JFieldRef x, Context ctx) {
        }

        @Override
        public final void endVisit(JFloatLiteral x, Context ctx) {
        }

        @Override
        public final void endVisit(JForStatement x, Context ctx) {
        }

        @Override
        public final void endVisit(JIfStatement x, Context ctx) {
        }

        @Override
        public final void endVisit(JInstanceOf x, Context ctx) {
        }

        @Override
        public final void endVisit(JInterfaceType x, Context ctx) {
        }

        @Override
        public final void endVisit(JIntLiteral x, Context ctx) {
        }

        @Override
        public final void endVisit(JLabel x, Context ctx) {
        }

        @Override
        public final void endVisit(JLabeledStatement x, Context ctx) {
        }

        @Override
        public final void endVisit(JLiteral x, Context ctx) {
        }

        @Override
        public final void endVisit(JLocal x, Context ctx) {
        }

        @Override
        public final void endVisit(JLocalRef x, Context ctx) {
        }

        @Override
        public final void endVisit(JLongLiteral x, Context ctx) {
        }

        @Override
        public final void endVisit(JMethod x, Context ctx) {
        }

        @Override
        public final void endVisit(JMethodBody x, Context ctx) {
        }

        @Override
        public final void endVisit(JMethodCall x, Context ctx) {
        }

        @Override
        public final void endVisit(JMultiExpression x, Context ctx) {
        }

        @Override
        public final void endVisit(JNameOf x, Context ctx) {
        }

        @Override
        public final void endVisit(JNewArray x, Context ctx) {
        }

        @Override
        public final void endVisit(JNewInstance x, Context ctx) {
        }

        @Override
        public final void endVisit(JNode x, Context ctx) {
        }

        @Override
        public final void endVisit(JNullLiteral x, Context ctx) {
        }

        @Override
        public final void endVisit(JNumericEntry x, Context ctx) {
        }

        @Override
        public final void endVisit(JParameter x, Context ctx) {
        }

        @Override
        public final void endVisit(JParameterRef x, Context ctx) {
        }

        @Override
        public final void endVisit(JPermutationDependentValue x, Context ctx) {
        }

        @Override
        public final void endVisit(JPostfixOperation x, Context ctx) {
        }

        @Override
        public final void endVisit(JPrefixOperation x, Context ctx) {
        }

        @Override
        public final void endVisit(JPrimitiveType x, Context ctx) {
        }

        @Override
        public final void endVisit(JProgram x, Context ctx) {
        }

        @Override
        public final void endVisit(JReferenceType x, Context ctx) {
        }

        @Override
        public final void endVisit(JReturnStatement x, Context ctx) {
        }

        @Override
        public final void endVisit(JRunAsync x, Context ctx) {
        }

        @Override
        public final void endVisit(JRuntimeTypeReference x, Context ctx) {
        }

        @Override
        public final void endVisit(JsniClassLiteral x, Context ctx) {
        }

        @Override
        public final void endVisit(JsniFieldRef x, Context ctx) {
        }

        @Override
        public final void endVisit(JsniMethodBody x, Context ctx) {
        }

        @Override
        public final void endVisit(JsniMethodRef x, Context ctx) {
        }

        @Override
        public final void endVisit(JsonArray x, Context ctx) {
        }

        @Override
        public final void endVisit(JStatement x, Context ctx) {
        }

        @Override
        public final void endVisit(JStringLiteral x, Context ctx) {
        }

        @Override
        public void endVisit(JSwitchExpression x, Context ctx) {
        }

        @Override
        public final void endVisit(JSwitchStatement x, Context ctx) {
        }

        @Override
        public final void endVisit(JThisRef x, Context ctx) {
        }

        @Override
        public final void endVisit(JThrowStatement x, Context ctx) {
        }

        @Override
        public final void endVisit(JTryStatement x, Context ctx) {
        }

        @Override
        public final void endVisit(JType x, Context ctx) {
        }

        @Override
        public final void endVisit(JUnaryOperation x, Context ctx) {
        }

        @Override
        public void endVisit(JUnsafeTypeCoercion x, Context ctx) {
        }

        @Override
        public final void endVisit(JValueLiteral x, Context ctx) {
        }

        @Override
        public final void endVisit(JVariable x, Context ctx) {
        }

        @Override
        public final void endVisit(JVariableRef x, Context ctx) {
        }

        @Override
        public final void endVisit(JWhileStatement x, Context ctx) {
        }

        @Override
        public void endVisit(JYieldStatement x, Context ctx) {
        }

        @Override
        public final boolean visit(JAbstractMethodBody x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformAbstractMethodBody(x);
            return false;
        }

        @Override
        public final boolean visit(JArrayLength x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformArrayLength(x);
            return false;
        }

        @Override
        public final boolean visit(JArrayRef x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformArrayRef(x);
            return false;
        }

        @Override
        public final boolean visit(JArrayType x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformArrayType(x);
            return false;
        }

        @Override
        public final boolean visit(JAssertStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformAssertStatement(x);
            return false;
        }

        @Override
        public final boolean visit(JBinaryOperation x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformBinaryOperation(x);
            return false;
        }

        @Override
        public final boolean visit(JBlock x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformBlock(x);
            return false;
        }

        @Override
        public final boolean visit(JBooleanLiteral x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformBooleanLiteral(x);
            return false;
        }

        @Override
        public final boolean visit(JBreakStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformBreakStatement(x);
            return false;
        }

        @Override
        public final boolean visit(JCaseStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformCaseStatement(x);
            return false;
        }

        @Override
        public final boolean visit(JCastMap x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformCastMap(x);
            return false;
        }

        @Override
        public final boolean visit(JCastOperation x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformCastOperation(x);
            return false;
        }

        @Override
        public final boolean visit(JCharLiteral x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformCharLiteral(x);
            return false;
        }

        @Override
        public final boolean visit(JClassLiteral x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformClassLiteral(x);
            return false;
        }

        @Override
        public final boolean visit(JClassType x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformClassType(x);
            return false;
        }

        @Override
        public final boolean visit(JConditional x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformConditional(x);
            return false;
        }

        @Override
        public final boolean visit(JConstructor x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformConstructor(x);
            return false;
        }

        @Override
        public final boolean visit(JContinueStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformContinueStatement(x);
            return false;
        }

        @Override
        public final boolean visit(JDebuggerStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformDebuggerStatement(x);
            return false;
        }

        @Override
        public final boolean visit(JDeclarationStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformDeclarationStatement(x);
            return false;
        }

        @Override
        public final boolean visit(JDeclaredType x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformDeclaredType(x);
            return false;
        }

        @Override
        public final boolean visit(JDoStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformDoStatement(x);
            return false;
        }

        @Override
        public final boolean visit(JDoubleLiteral x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformDoubleLiteral(x);
            return false;
        }

        @Override
        public final boolean visit(JExpression x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformExpression(x);
            return false;
        }

        @Override
        public final boolean visit(JExpressionStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformExpressionStatement(x);
            return false;
        }

        @Override
        public final boolean visit(JField x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformField(x);
            return false;
        }

        @Override
        public final boolean visit(JFieldRef x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformFieldRef(x);
            return false;
        }

        @Override
        public final boolean visit(JFloatLiteral x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformFloatLiteral(x);
            return false;
        }

        @Override
        public final boolean visit(JForStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformForStatement(x);
            return false;
        }

        @Override
        public final boolean visit(JIfStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformIfStatement(x);
            return false;
        }

        @Override
        public final boolean visit(JInstanceOf x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformInstanceOf(x);
            return false;
        }

        @Override
        public final boolean visit(JInterfaceType x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformInterfaceType(x);
            return false;
        }

        @Override
        public final boolean visit(JIntLiteral x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformIntLiteral(x);
            return false;
        }

        @Override
        public final boolean visit(JLabel x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformLabel(x);
            return false;
        }

        @Override
        public final boolean visit(JLabeledStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformLabeledStatement(x);
            return false;
        }

        @Override
        public final boolean visit(JLiteral x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformLiteral(x);
            return false;
        }

        @Override
        public final boolean visit(JLocal x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformLocal(x);
            return false;
        }

        @Override
        public final boolean visit(JLocalRef x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformLocalRef(x);
            return false;
        }

        @Override
        public final boolean visit(JLongLiteral x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformLongLiteral(x);
            return false;
        }

        @Override
        public final boolean visit(JMethod x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformMethod(x);
            return false;
        }

        @Override
        public final boolean visit(JMethodBody x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformMethodBody(x);
            return false;
        }

        @Override
        public final boolean visit(JMethodCall x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformMethodCall(x);
            return false;
        }

        @Override
        public final boolean visit(JMultiExpression x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformMultiExpression(x);
            return false;
        }

        @Override
        public final boolean visit(JNameOf x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformNameOf(x);
            return false;
        }

        @Override
        public final boolean visit(JNewArray x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformNewArray(x);
            return false;
        }

        @Override
        public final boolean visit(JNewInstance x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformNewInstance(x);
            return false;
        }

        @Override
        public final boolean visit(JNode x, Context ctx) {
            JTransformer.this.missing(x);
            return false;
        }

        @Override
        public final boolean visit(JNullLiteral x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformNullLiteral(x);
            return false;
        }

        @Override
        public final boolean visit(JNumericEntry x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformNumericEntry(x);
            return false;
        }

        @Override
        public final boolean visit(JParameter x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformParameter(x);
            return false;
        }

        @Override
        public final boolean visit(JParameterRef x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformParameterRef(x);
            return false;
        }

        @Override
        public final boolean visit(JPermutationDependentValue x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformPermutationDependentValue(x);
            return false;
        }

        @Override
        public final boolean visit(JPostfixOperation x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformPostfixOperation(x);
            return false;
        }

        @Override
        public final boolean visit(JPrefixOperation x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformPrefixOperation(x);
            return false;
        }

        @Override
        public final boolean visit(JPrimitiveType x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformPrimitiveType(x);
            return false;
        }

        @Override
        public final boolean visit(JProgram x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformProgram(x);
            return false;
        }

        @Override
        public final boolean visit(JReferenceType x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformReferenceType(x);
            return false;
        }

        @Override
        public final boolean visit(JReturnStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformReturnStatement(x);
            return false;
        }

        @Override
        public final boolean visit(JRunAsync x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformRunAsync(x);
            return false;
        }

        @Override
        public final boolean visit(JRuntimeTypeReference x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformRuntimeTypeReference(x);
            return false;
        }

        @Override
        public final boolean visit(JsniClassLiteral x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformJsniClassLiteral(x);
            return false;
        }

        @Override
        public final boolean visit(JsniFieldRef x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformJsniFieldRef(x);
            return false;
        }

        @Override
        public final boolean visit(JsniMethodBody x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformJsniMethodBody(x);
            return false;
        }

        @Override
        public final boolean visit(JsniMethodRef x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformJsniMethodRef(x);
            return false;
        }

        @Override
        public final boolean visit(JsonArray x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformJsonArray(x);
            return false;
        }

        @Override
        public final boolean visit(JStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformStatement(x);
            return false;
        }

        @Override
        public final boolean visit(JStringLiteral x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformStringLiteral(x);
            return false;
        }

        @Override
        public final boolean visit(JSwitchExpression x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformSwitchExpression(x);
            return false;
        }

        @Override
        public final boolean visit(JSwitchStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformSwitchStatement(x);
            return false;
        }

        @Override
        public final boolean visit(JThisRef x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformThisRef(x);
            return false;
        }

        @Override
        public final boolean visit(JThrowStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformThrowStatement(x);
            return false;
        }

        @Override
        public final boolean visit(JTryStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformTryStatement(x);
            return false;
        }

        @Override
        public final boolean visit(JType x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformType(x);
            return false;
        }

        @Override
        public final boolean visit(JUnaryOperation x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformUnaryOperation(x);
            return false;
        }

        @Override
        public final boolean visit(JUnsafeTypeCoercion x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformUnsafeTypeCoercion(x);
            return false;
        }

        @Override
        public final boolean visit(JValueLiteral x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformValueLiteral(x);
            return false;
        }

        @Override
        public final boolean visit(JVariable x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformVariable(x);
            return false;
        }

        @Override
        public final boolean visit(JVariableRef x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformVariableRef(x);
            return false;
        }

        @Override
        public final boolean visit(JWhileStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformWhileStatement(x);
            return false;
        }

        @Override
        public boolean visit(JYieldStatement x, Context ctx) {
            assert (this.result == null);
            this.result = JTransformer.this.transformYieldStatement(x);
            return false;
        }
    }
}

