/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JStringLiteral
extends JValueLiteral {
    private JClassType stringType;
    private final String value;

    public JStringLiteral(SourceInfo sourceInfo, String value, JClassType stringType) {
        super(sourceInfo);
        this.value = value;
        this.stringType = stringType;
        assert (stringType.getName().equals("java.lang.String"));
    }

    @Override
    public JReferenceType getType() {
        return this.stringType.strengthenToNonNull();
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public Object getValueObj() {
        return this.value;
    }

    public void resolve(JClassType stringType) {
        assert (stringType.replaces(this.stringType));
        this.stringType = stringType;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            // empty if block
        }
        visitor.endVisit(this, ctx);
    }
}

