/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JRunAsync
extends JExpression {
    private final String name;
    private final boolean explicitClassLiteral;
    private JExpression onSuccessCall;
    private JExpression runAsyncCall;
    private final int runAsyncId;

    public JRunAsync(SourceInfo info, int runAsyncId, String name, boolean explicitClassLiteral, JExpression runAsyncCall, JExpression onSuccessCall) {
        super(info);
        this.runAsyncId = runAsyncId;
        assert (name != null);
        this.name = name;
        this.explicitClassLiteral = explicitClassLiteral;
        this.runAsyncCall = runAsyncCall;
        this.onSuccessCall = onSuccessCall;
    }

    public String getName() {
        return this.name;
    }

    public JExpression getOnSuccessCall() {
        return this.onSuccessCall;
    }

    public JExpression getRunAsyncCall() {
        return this.runAsyncCall;
    }

    public int getRunAsyncId() {
        return this.runAsyncId;
    }

    @Override
    public JType getType() {
        return JPrimitiveType.VOID;
    }

    @Override
    public boolean hasSideEffects() {
        return true;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            this.runAsyncCall = visitor.accept(this.runAsyncCall);
        }
        visitor.endVisit(this, ctx);
    }

    public void traverseOnSuccess(JVisitor visitor) {
        this.onSuccessCall = visitor.accept(this.onSuccessCall);
    }

    public boolean hasExplicitClassLiteral() {
        return this.explicitClassLiteral;
    }
}

