/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.CanBeAbstract;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JEnumType;
import com.google.gwt.dev.jjs.ast.JLiteral;
import com.google.gwt.dev.jjs.ast.JNullLiteral;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;

public abstract class JReferenceType
extends JType
implements CanBeAbstract {
    public static final JReferenceType NULL_TYPE = new JReferenceType(SourceOrigin.UNKNOWN, "null"){

        @Override
        AnalysisResult getAnalysisResult() {
            return AnalysisResult.NULLABLE_EXACT;
        }

        @Override
        public String getJavahSignatureName() {
            return "N";
        }

        @Override
        public String getJsniSignatureName() {
            return "N";
        }

        @Override
        public JEnumType isEnumOrSubclass() {
            return null;
        }

        @Override
        public boolean isAbstract() {
            return false;
        }

        @Override
        public boolean isFinal() {
            return true;
        }

        @Override
        public boolean isJsoType() {
            return false;
        }

        @Override
        public boolean isArrayType() {
            return false;
        }

        @Override
        public boolean isNullType() {
            return true;
        }

        @Override
        public boolean isJsType() {
            return false;
        }

        @Override
        public boolean isJsFunction() {
            return false;
        }

        @Override
        public boolean isJsFunctionImplementation() {
            return false;
        }

        @Override
        public boolean isJsNative() {
            return false;
        }

        @Override
        public boolean canBeImplementedExternally() {
            return false;
        }

        @Override
        public boolean canBeReferencedExternally() {
            return false;
        }

        @Override
        public boolean isJavaLangObject() {
            return false;
        }

        @Override
        public void traverse(JVisitor visitor, Context ctx) {
            if (visitor.visit(this, ctx)) {
                // empty if block
            }
            visitor.endVisit(this, ctx);
        }

        private Object readResolve() {
            return NULL_TYPE;
        }

        @Override
        public JReferenceType strengthenToNonNull() {
            throw new UnsupportedOperationException();
        }
    };
    private transient AnalysisDecoratedTypePool analysisDecoratedTypePool = null;

    public JReferenceType(SourceInfo info, String name) {
        super(info, name);
    }

    @Override
    public final boolean canBeNull() {
        return this.getAnalysisResult().isNullable();
    }

    @Override
    public final boolean canBeSubclass() {
        boolean exact = this.getAnalysisResult().isExact();
        assert (!exact || this.canBeStrengthenedToExactType()) : "A JSO or native type can never be EXACT but " + this.name + " is.";
        return !exact;
    }

    @Override
    public final JLiteral getDefaultValue() {
        return JNullLiteral.INSTANCE;
    }

    @Override
    public String getJavahSignatureName() {
        return "L" + this.name.replaceAll("_", "_1").replace('.', '_') + "_2";
    }

    @Override
    public String getJsniSignatureName() {
        return "L" + this.name.replace('.', '/') + ';';
    }

    @Override
    public boolean isPrimitiveType() {
        return false;
    }

    public JReferenceType weakenToNullable() {
        if (this.getUnderlyingType() == this) {
            return this;
        }
        switch (this.getAnalysisResult()) {
            case NOT_NULLABLE_NOT_EXACT: {
                return this.getAnalysisDecoratedTypePool().getAnalysisDecoratedType(this, AnalysisResult.NULLABLE_NOT_EXACT);
            }
            case NOT_NULLABLE_EXACT: {
                return this.getAnalysisDecoratedTypePool().getAnalysisDecoratedType(this, AnalysisResult.NULLABLE_EXACT);
            }
            case NULLABLE_EXACT: 
            case NULLABLE_NOT_EXACT: {
                return this;
            }
        }
        throw new AssertionError((Object)("Unknown AnalysisResult " + this.getAnalysisResult().toString()));
    }

    public JReferenceType weakenToNonExact() {
        if (this.getUnderlyingType() == this) {
            return this;
        }
        switch (this.getAnalysisResult()) {
            case NULLABLE_EXACT: {
                return this.getAnalysisDecoratedTypePool().getAnalysisDecoratedType(this, AnalysisResult.NULLABLE_NOT_EXACT);
            }
            case NOT_NULLABLE_EXACT: {
                return this.getAnalysisDecoratedTypePool().getAnalysisDecoratedType(this, AnalysisResult.NOT_NULLABLE_NOT_EXACT);
            }
            case NOT_NULLABLE_NOT_EXACT: 
            case NULLABLE_NOT_EXACT: {
                return this;
            }
        }
        throw new AssertionError((Object)("Unknown AnalysisResult " + this.getAnalysisResult().toString()));
    }

    private boolean canBeStrengthenedToExactType() {
        return !this.isJsoType() && !this.canBeImplementedExternally();
    }

    private boolean canBeStrengthenedToNonNull() {
        return !this.isJsoType();
    }

    @Override
    public JReferenceType strengthenToNonNull() {
        if (!this.canBeStrengthenedToNonNull()) {
            return this;
        }
        switch (this.getAnalysisResult()) {
            case NULLABLE_NOT_EXACT: {
                return this.getAnalysisDecoratedTypePool().getAnalysisDecoratedType(this, AnalysisResult.NOT_NULLABLE_NOT_EXACT);
            }
            case NULLABLE_EXACT: {
                return this.getAnalysisDecoratedTypePool().getAnalysisDecoratedType(this, AnalysisResult.NOT_NULLABLE_EXACT);
            }
            case NOT_NULLABLE_NOT_EXACT: 
            case NOT_NULLABLE_EXACT: {
                return this;
            }
        }
        throw new AssertionError((Object)("Unknown AnalysisResult " + this.getAnalysisResult().toString()));
    }

    public JReferenceType strengthenToExact() {
        if (!this.canBeStrengthenedToExactType()) {
            return this;
        }
        switch (this.getAnalysisResult()) {
            case NOT_NULLABLE_NOT_EXACT: {
                return this.getAnalysisDecoratedTypePool().getAnalysisDecoratedType(this, AnalysisResult.NOT_NULLABLE_EXACT);
            }
            case NULLABLE_NOT_EXACT: {
                return this.getAnalysisDecoratedTypePool().getAnalysisDecoratedType(this, AnalysisResult.NULLABLE_EXACT);
            }
            case NOT_NULLABLE_EXACT: 
            case NULLABLE_EXACT: {
                return this;
            }
        }
        throw new AssertionError((Object)("Unknown AnalysisResult " + this.getAnalysisResult().toString()));
    }

    @Override
    public JReferenceType getUnderlyingType() {
        return this;
    }

    @Override
    public boolean replaces(JType originalType) {
        return super.replaces(originalType) && this.canBeNull() == originalType.canBeNull();
    }

    AnalysisDecoratedTypePool getAnalysisDecoratedTypePool() {
        assert (!(this instanceof JAnalysisDecoratedType));
        if (this.analysisDecoratedTypePool == null) {
            this.analysisDecoratedTypePool = new AnalysisDecoratedTypePool();
        }
        return this.analysisDecoratedTypePool;
    }

    AnalysisResult getAnalysisResult() {
        if (this.isFinal() && this.canBeStrengthenedToExactType()) {
            return AnalysisResult.NULLABLE_EXACT;
        }
        return AnalysisResult.NULLABLE_NOT_EXACT;
    }

    private static class AnalysisDecoratedTypePool {
        private final JAnalysisDecoratedType[] decoratedAnalysisTypePool = new JAnalysisDecoratedType[AnalysisResult.values().length - 1];

        private AnalysisDecoratedTypePool() {
        }

        public JReferenceType getAnalysisDecoratedType(JReferenceType type, AnalysisResult request) {
            JReferenceType underlyingType = type.getUnderlyingType();
            if (underlyingType.getAnalysisResult() == request) {
                return underlyingType;
            }
            assert (request != AnalysisResult.NULLABLE_NOT_EXACT);
            int poolIndex = request.ordinal() - 1;
            JAnalysisDecoratedType result = this.decoratedAnalysisTypePool[poolIndex];
            if (result == null) {
                result = this.decoratedAnalysisTypePool[poolIndex] = new JAnalysisDecoratedType(underlyingType, request);
            }
            return result;
        }
    }

    private static class JAnalysisDecoratedType
    extends JReferenceType {
        private final AnalysisResult analysisResult;
        private final JReferenceType ref;

        private JAnalysisDecoratedType(JReferenceType ref, AnalysisResult analysisResult) {
            super(ref.getSourceInfo(), ref.getName());
            this.analysisResult = analysisResult;
            assert (ref.getUnderlyingType().getAnalysisResult() != analysisResult) : "An analysis type for " + ref + " should not have been constructed as it is equivalent to the original type";
            assert (!ref.isNullType());
            assert (!(ref instanceof JAnalysisDecoratedType));
            this.ref = ref;
        }

        @Override
        AnalysisDecoratedTypePool getAnalysisDecoratedTypePool() {
            return this.ref.getAnalysisDecoratedTypePool();
        }

        @Override
        AnalysisResult getAnalysisResult() {
            return this.analysisResult;
        }

        @Override
        public String getJavahSignatureName() {
            return this.ref.getJavahSignatureName();
        }

        @Override
        public String getJsniSignatureName() {
            return this.ref.getJsniSignatureName();
        }

        @Override
        public JEnumType isEnumOrSubclass() {
            return this.ref.isEnumOrSubclass();
        }

        @Override
        public JReferenceType getUnderlyingType() {
            return this.ref;
        }

        @Override
        public boolean isAbstract() {
            return this.ref.isAbstract();
        }

        @Override
        public boolean isArrayType() {
            return this.ref.isArrayType();
        }

        @Override
        public boolean isJsType() {
            return this.ref.isJsType();
        }

        @Override
        public boolean isJsFunction() {
            return this.ref.isJsFunction();
        }

        @Override
        public boolean isJsFunctionImplementation() {
            return this.ref.isJsFunctionImplementation();
        }

        @Override
        public boolean isJsoType() {
            return this.ref.isJsoType();
        }

        @Override
        public boolean isJsNative() {
            return this.ref.isJsNative();
        }

        @Override
        public boolean canBeImplementedExternally() {
            return this.ref.canBeImplementedExternally();
        }

        @Override
        public boolean canBeReferencedExternally() {
            return this.ref.canBeReferencedExternally();
        }

        @Override
        public boolean isJavaLangObject() {
            return this.ref.isJavaLangObject();
        }

        @Override
        public boolean isExternal() {
            return this.ref.isExternal();
        }

        @Override
        public boolean isFinal() {
            return this.ref.isFinal();
        }

        @Override
        public void traverse(JVisitor visitor, Context ctx) {
            visitor.accept(this.ref);
        }

        private Object readResolve() {
            return this.getAnalysisDecoratedTypePool().getAnalysisDecoratedType(this.ref, this.analysisResult);
        }

        @Override
        public String getDescription() {
            return super.getDescription() + (!this.canBeNull() ? " (non-null)" : "") + (!this.canBeSubclass() ? "(exact) " : "");
        }
    }

    static enum AnalysisResult {
        NULLABLE_NOT_EXACT(true, false),
        NOT_NULLABLE_NOT_EXACT(false, false),
        NULLABLE_EXACT(true, true),
        NOT_NULLABLE_EXACT(false, true);

        private final boolean isNullable;
        private final boolean isExact;

        private AnalysisResult(boolean isNullable, boolean isExact) {
            this.isNullable = isNullable;
            this.isExact = isExact;
        }

        private boolean isNullable() {
            return this.isNullable;
        }

        private boolean isExact() {
            return this.isExact;
        }
    }
}

