/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.MinimalRebuildCache;
import com.google.gwt.dev.common.InliningMode;
import com.google.gwt.dev.jjs.Correlation;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.ArrayTypeCreator;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JBinaryOperation;
import com.google.gwt.dev.jjs.ast.JBinaryOperator;
import com.google.gwt.dev.jjs.ast.JBooleanLiteral;
import com.google.gwt.dev.jjs.ast.JCastMap;
import com.google.gwt.dev.jjs.ast.JCharLiteral;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JDoubleLiteral;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JExpressionStatement;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JFloatLiteral;
import com.google.gwt.dev.jjs.ast.JIntLiteral;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JLiteral;
import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JLongLiteral;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JNullLiteral;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JRunAsync;
import com.google.gwt.dev.jjs.ast.JStringLiteral;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JTypeOracle;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.jjs.impl.TypeCategory;
import com.google.gwt.dev.jjs.impl.codesplitter.FragmentPartitioningResult;
import com.google.gwt.dev.js.CoverageInstrumentor;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.dev.util.log.speedtracer.CompilerEventType;
import com.google.gwt.dev.util.log.speedtracer.SpeedTracerLogger;
import com.google.gwt.thirdparty.guava.common.base.CaseFormat;
import com.google.gwt.thirdparty.guava.common.base.Function;
import com.google.gwt.thirdparty.guava.common.base.Predicate;
import com.google.gwt.thirdparty.guava.common.collect.BiMap;
import com.google.gwt.thirdparty.guava.common.collect.Collections2;
import com.google.gwt.thirdparty.guava.common.collect.HashBiMap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableList;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableMap;
import com.google.gwt.thirdparty.guava.common.collect.ImmutableSet;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Maps;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JProgram
extends JNode
implements ArrayTypeCreator {
    public static final Set<String> CODEGEN_TYPES_SET = Sets.newLinkedHashSet(Arrays.asList("com.google.gwt.lang.Array", "com.google.gwt.lang.Cast", "com.google.gwt.lang.Exceptions", "com.google.gwt.lang.LongLib", "com.google.gwt.lang.Stats", "com.google.gwt.lang.Util", "java.lang.Object"));
    public static final Set<String> IMMORTAL_CODEGEN_TYPES_SET = Sets.newLinkedHashSet(Arrays.asList("com.google.gwt.lang.CollapsedPropertyHolder", "com.google.gwt.lang.Runtime", "com.google.gwt.lang.ModuleUtils"));
    public static final String JAVASCRIPTOBJECT = "com.google.gwt.core.client.JavaScriptObject";
    public static final String CLASS_LITERAL_HOLDER = "com.google.gwt.lang.ClassLiteralHolder";
    public static final Set<String> SYNTHETIC_TYPE_NAMES = Sets.newHashSet("com.google.gwt.lang.ClassLiteralHolder");
    private static final Comparator<JArrayType> ARRAYTYPE_COMPARATOR = new Comparator<JArrayType>(){

        @Override
        public int compare(JArrayType o1, JArrayType o2) {
            int comp = o1.getDims() - o2.getDims();
            if (comp != 0) {
                return comp;
            }
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final Map<String, JPrimitiveType> primitiveTypes = Maps.newHashMap();
    @Deprecated
    private static final Map<String, JPrimitiveType> primitiveTypesDeprecated = Maps.newHashMap();
    public final List<JClassType> codeGenTypes = Lists.newArrayList();
    public final List<JClassType> immortalCodeGenTypes = Lists.newArrayList();
    public final JTypeOracle typeOracle;
    private transient List<JDeclaredType> allTypes = Lists.newArrayList();
    private final Map<JType, JArrayType> arrayTypes = Maps.newHashMap();
    private Map<JReferenceType, JCastMap> castMaps;
    private BiMap<JType, JField> classLiteralFieldsByType;
    private final List<JMethod> entryMethods = Lists.newArrayList();
    private final Map<String, JField> indexedFields = Maps.newHashMap();
    private final Map<String, JMethod> indexedMethods = Maps.newHashMap();
    private final Map<String, JDeclaredType> indexedTypes = Maps.newHashMap();
    private final Set<String> typeNamesToIndex = JProgram.buildInitialTypeNamesToIndex();
    private final Map<JMethod, JMethod> instanceToStaticMap = Maps.newIdentityHashMap();
    private Set<String> referenceOnlyTypeNames = Sets.newHashSet();
    private List<JRunAsync> runAsyncs = Lists.newArrayList();
    private LinkedHashSet<JRunAsync> initialAsyncSequence = Sets.newLinkedHashSet();
    private List<Integer> initialFragmentIdSequence = Lists.newArrayList();
    private final Map<JMethod, JMethod> staticToInstanceMap = Maps.newIdentityHashMap();
    private final Map<String, JDeclaredType> typeNameMap = Maps.newHashMap();
    private Map<JField, JType> typesByClassLiteralField;
    private JClassType typeClass;
    private JClassType typeJavaLangObject;
    private JArrayType typeJavaLangObjectArray;
    private JClassType typeSpecialClassLiteralHolder;
    private JClassType typeSpecialJavaScriptObject;
    private JClassType typeString;
    private FragmentPartitioningResult fragmentPartitioningResult;
    private Map<JClassType, DispatchType> dispatchTypeByNativeType;

    public static JExpressionStatement createAssignmentStmt(SourceInfo info, JExpression lhs, JExpression rhs) {
        return JProgram.createAssignment(info, lhs, rhs).makeStatement();
    }

    public static JBinaryOperation createAssignment(SourceInfo info, JExpression lhs, JExpression rhs) {
        return new JBinaryOperation(info, lhs.getType(), JBinaryOperator.ASG, lhs, rhs);
    }

    public static JLocal createLocal(SourceInfo info, String name, JType type, boolean isFinal, JMethodBody enclosingMethodBody) {
        assert (name != null);
        assert (type != null);
        assert (enclosingMethodBody != null);
        JLocal x = new JLocal(info, name, type, isFinal);
        enclosingMethodBody.addLocal(x);
        return x;
    }

    public static List<JDeclaredType> deserializeTypes(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        List types = (List)stream.readObject();
        for (JDeclaredType type : types) {
            type.readMembers(stream);
        }
        for (JDeclaredType type : types) {
            type.readMethodBodies(stream);
        }
        return types;
    }

    public static String getFullName(JMethod method) {
        return method.getEnclosingType().getName() + "." + method.getJsniSignature(false, true);
    }

    public static boolean isClinit(JMethod method) {
        boolean isClinit;
        JDeclaredType enclosingType = method.getEnclosingType();
        boolean bl = isClinit = enclosingType != JClassType.NULL_CLASS && method == enclosingType.getClinitMethod();
        assert (!isClinit || method.getName().equals("$clinit"));
        return isClinit;
    }

    public static boolean isInit(JMethod method) {
        boolean isInit;
        JDeclaredType enclosingType = method.getEnclosingType();
        if (method.isStatic()) {
            return method.getName().equals("$$init");
        }
        boolean bl = isInit = enclosingType != null && method == enclosingType.getInitMethod();
        assert (!isInit || method.getName().equals("$init"));
        return isInit;
    }

    public static void serializeTypes(List<JDeclaredType> types, ObjectOutputStream stream) throws IOException {
        stream.writeObject(types);
        for (JDeclaredType type : types) {
            type.writeMembers(stream);
        }
        for (JDeclaredType type : types) {
            type.writeMethodBodies(stream);
        }
    }

    public void addPinnedMethod(JMethod method) {
        method.setInliningMode(InliningMode.DO_NOT_INLINE);
        method.disallowDevirtualization();
    }

    public JProgram(MinimalRebuildCache minimalRebuildCache) {
        super(SourceOrigin.UNKNOWN);
        this.typeOracle = new JTypeOracle(this, minimalRebuildCache);
    }

    public void addEntryMethod(JMethod entryPoint) {
        assert (!this.entryMethods.contains(entryPoint));
        this.entryMethods.add(entryPoint);
    }

    public void addIndexedTypeName(String typeName) {
        this.typeNamesToIndex.add(typeName);
    }

    public void addReferenceOnlyType(JDeclaredType type) {
        this.referenceOnlyTypeNames.add(type.getName());
    }

    public void addType(JDeclaredType type) {
        this.allTypes.add(type);
        String name = type.getName();
        this.putIntoTypeMap(name, type);
        if (CODEGEN_TYPES_SET.contains(name)) {
            this.codeGenTypes.add((JClassType)type);
        }
        if (IMMORTAL_CODEGEN_TYPES_SET.contains(name)) {
            type.setClinitTarget(null);
            this.immortalCodeGenTypes.add((JClassType)type);
        }
        if (!this.typeNamesToIndex.contains(name)) {
            return;
        }
        this.indexedTypes.put(type.getShortName(), type);
        for (JMethod method : type.getMethods()) {
            if (method.isPrivate()) continue;
            this.indexedMethods.put(JjsUtils.getIndexedName(method), method);
        }
        for (JField field : type.getFields()) {
            this.indexedFields.put(JjsUtils.getIndexedName(field), field);
        }
        switch (name) {
            case "java.lang.Object": {
                this.typeJavaLangObject = (JClassType)type;
                this.typeJavaLangObjectArray = this.getOrCreateArrayType(type, 1);
                break;
            }
            case "java.lang.String": {
                this.typeString = (JClassType)type;
                break;
            }
            case "java.lang.Class": {
                this.typeClass = (JClassType)type;
                break;
            }
            case "com.google.gwt.core.client.JavaScriptObject": {
                this.typeSpecialJavaScriptObject = (JClassType)type;
                break;
            }
            case "com.google.gwt.lang.ClassLiteralHolder": {
                this.typeSpecialClassLiteralHolder = (JClassType)type;
            }
        }
    }

    public static boolean isRepresentedAsNative(final String className) {
        return Iterables.any(Arrays.asList(DispatchType.values()), new Predicate<DispatchType>(){

            @Override
            public boolean apply(DispatchType dispatchType) {
                return className.equals(dispatchType.getClassName());
            }
        });
    }

    public boolean isRepresentedAsNativeJsPrimitive(JType type) {
        return this.getRepresentedAsNativeTypes().contains(type);
    }

    public Set<JClassType> getRepresentedAsNativeTypes() {
        return this.getRepresentedAsNativeTypesDispatchMap().keySet();
    }

    public Map<JClassType, DispatchType> getRepresentedAsNativeTypesDispatchMap() {
        if (this.dispatchTypeByNativeType == null) {
            ImmutableMap.Builder<JClassType, DispatchType> builder = new ImmutableMap.Builder<JClassType, DispatchType>();
            for (DispatchType dispatchType : DispatchType.values()) {
                if (dispatchType.getClassName() == null) continue;
                JClassType classType = (JClassType)this.getFromTypeMap(dispatchType.getClassName());
                assert (classType != null) : "Class " + dispatchType.getClassName() + " has not been loaded";
                builder.put(classType, dispatchType);
            }
            this.dispatchTypeByNativeType = builder.build();
        }
        return this.dispatchTypeByNativeType;
    }

    public EnumSet<DispatchType> getDispatchType(JReferenceType type) {
        if (!this.typeOracle.isInstantiatedType(type)) {
            return EnumSet.noneOf(DispatchType.class);
        }
        if (type == this.getTypeJavaLangObject()) {
            return EnumSet.allOf(DispatchType.class);
        }
        if (type.isArrayType()) {
            return EnumSet.of(DispatchType.JSO, DispatchType.JAVA_ARRAY);
        }
        EnumSet<DispatchType> dispatchSet = EnumSet.noneOf(DispatchType.class);
        DispatchType dispatchType = this.getRepresentedAsNativeTypesDispatchMap().get(type);
        if (dispatchType != null) {
            dispatchSet = EnumSet.of(dispatchType);
        } else if (this.typeOracle.isDualJsoInterface(type) || type.isJsNative()) {
            dispatchSet = EnumSet.of(DispatchType.HAS_JAVA_VIRTUAL_DISPATCH, DispatchType.JSO);
        } else if (this.typeOracle.isSingleJsoImpl(type) || type.isJsoType()) {
            dispatchSet = EnumSet.of(DispatchType.JSO);
        }
        for (JDeclaredType jDeclaredType : this.getRepresentedAsNativeTypes()) {
            if (jDeclaredType == type || !this.typeOracle.isInstantiatedType(jDeclaredType) || !this.typeOracle.isSuperClassOrInterface(jDeclaredType, type)) continue;
            dispatchSet.add(this.getRepresentedAsNativeTypesDispatchMap().get(jDeclaredType));
            dispatchSet.add(DispatchType.HAS_JAVA_VIRTUAL_DISPATCH);
        }
        return dispatchSet;
    }

    public JReferenceType strengthenType(JReferenceType thisType, JReferenceType thatType) {
        if (thisType == thatType) {
            return thisType;
        }
        if (thisType.isNullType() || thatType.isNullType()) {
            return JReferenceType.NULL_TYPE;
        }
        if (!thisType.canBeNull() || !thatType.canBeNull()) {
            JReferenceType thisTypeNonNull = thisType.strengthenToNonNull();
            JReferenceType thatTypeNonNull = thatType.strengthenToNonNull();
            if (thisType != thisTypeNonNull || thatType != thatTypeNonNull) {
                return this.strengthenType(thisTypeNonNull, thatTypeNonNull);
            }
        }
        if (this.typeOracle.castSucceedsTrivially(thisType, thatType)) {
            return thisType;
        }
        if (this.typeOracle.castSucceedsTrivially(thatType, thisType)) {
            return thatType;
        }
        return thisType;
    }

    public JReferenceType generalizeTypes(Iterable<JReferenceType> types) {
        Iterator<JReferenceType> it = types.iterator();
        if (!it.hasNext()) {
            return JReferenceType.NULL_TYPE;
        }
        JReferenceType curType = it.next();
        while (it.hasNext() && (curType = this.generalizeTypes(curType, it.next())) != this.typeJavaLangObject) {
        }
        return curType;
    }

    private JReferenceType generalizeTypes(JReferenceType thisType, JReferenceType thatType) {
        if (!thisType.canBeNull() && !thatType.canBeNull()) {
            JReferenceType nulllableGeneralizer = this.generalizeTypes(thisType.weakenToNullable(), thatType.weakenToNullable());
            return nulllableGeneralizer.strengthenToNonNull();
        }
        thisType = thisType.weakenToNullable();
        if ((thatType = thatType.weakenToNullable()).isNullType()) {
            return thisType;
        }
        if (thisType.isNullType()) {
            return thatType;
        }
        if (thisType == thatType) {
            return thisType;
        }
        return this.generalizeUnderlyingTypes(thisType.getUnderlyingType(), thatType.getUnderlyingType());
    }

    private JReferenceType generalizeUnderlyingTypes(JReferenceType thisType, JReferenceType thatType) {
        JReferenceType nonInterfaceType;
        assert (thisType == thisType.getUnderlyingType() && thatType == thatType.getUnderlyingType());
        if (thisType == thatType) {
            return thisType;
        }
        if (thisType instanceof JInterfaceType && thatType instanceof JInterfaceType) {
            return this.generalizeInterfaces((JInterfaceType)thisType, (JInterfaceType)thatType);
        }
        if (thisType instanceof JArrayType && thatType instanceof JArrayType) {
            return this.generalizeArrayTypes((JArrayType)thisType, (JArrayType)thatType);
        }
        if (thisType instanceof JClassType && thatType instanceof JClassType) {
            return this.generalizeClasses((JClassType)thisType, (JClassType)thatType);
        }
        JInterfaceType interfaceType = thisType instanceof JInterfaceType ? (JInterfaceType)thisType : (thatType instanceof JInterfaceType ? (JInterfaceType)thatType : null);
        JReferenceType jReferenceType = nonInterfaceType = interfaceType == thisType ? thatType : thisType;
        if (interfaceType != null && this.typeOracle.castSucceedsTrivially(nonInterfaceType, (JReferenceType)interfaceType)) {
            return interfaceType;
        }
        return this.typeJavaLangObject;
    }

    private JReferenceType generalizeArrayTypes(JArrayType thisArrayType, JArrayType thatArrayType) {
        JClassType minimalGeneralType;
        int thatDims;
        assert (thisArrayType != thatArrayType);
        int thisDims = thisArrayType.getDims();
        int minDims = Math.min(thisDims, thatDims = thatArrayType.getDims());
        JReferenceType jReferenceType = minimalGeneralType = minDims == 1 ? this.typeJavaLangObject : this.getOrCreateArrayType(this.typeJavaLangObject, minDims - 1);
        if (thisDims == thatDims) {
            JType thisLeafType = thisArrayType.getLeafType();
            JType thatLeafType = thatArrayType.getLeafType();
            if (!(thisLeafType instanceof JReferenceType) || !(thatLeafType instanceof JReferenceType)) {
                return minimalGeneralType;
            }
            JReferenceType leafGeneralization = this.generalizeTypes((JReferenceType)thisLeafType, (JReferenceType)thatLeafType).getUnderlyingType();
            return this.getOrCreateArrayType(leafGeneralization, thisDims);
        }
        if (this.typeOracle.castSucceedsTrivially((JReferenceType)thatArrayType, (JReferenceType)thisArrayType)) {
            return thisArrayType;
        }
        if (this.typeOracle.castSucceedsTrivially((JReferenceType)thisArrayType, (JReferenceType)thatArrayType)) {
            return thatArrayType;
        }
        return minimalGeneralType;
    }

    private JReferenceType generalizeInterfaces(JInterfaceType thisInterface, JInterfaceType thatInterface) {
        if (this.typeOracle.castSucceedsTrivially(thisInterface, (JReferenceType)thatInterface)) {
            return thatInterface;
        }
        if (this.typeOracle.castSucceedsTrivially(thatInterface, (JReferenceType)thisInterface)) {
            return thisInterface;
        }
        return this.typeJavaLangObject;
    }

    private JReferenceType generalizeClasses(JClassType thisClass, JClassType thatClass) {
        int distance1;
        int distance2 = this.countSuperTypes(thatClass);
        for (distance1 = this.countSuperTypes(thisClass); distance1 > distance2; --distance1) {
            thisClass = thisClass.getSuperClass();
        }
        while (distance1 < distance2) {
            thatClass = thatClass.getSuperClass();
            --distance2;
        }
        while (thisClass != thatClass) {
            thisClass = thisClass.getSuperClass();
            thatClass = thatClass.getSuperClass();
        }
        return thisClass;
    }

    public List<JArrayType> getAllArrayTypes() {
        ArrayList<JArrayType> result = Lists.newArrayList(this.arrayTypes.values());
        Collections.sort(result, ARRAYTYPE_COMPARATOR);
        return result;
    }

    public JExpression createArrayClassLiteralExpression(SourceInfo sourceInfo, JClassLiteral leafTypeClassLiteral, int dimensions) {
        JField leafTypeClassLiteralField = leafTypeClassLiteral.getField();
        assert (leafTypeClassLiteralField != null) : "Array leaf type must have a class literal field; either ImplementClassLiteralsAsField has not run yet or or there is an error computinglive class literals.";
        return new JMethodCall(sourceInfo, null, this.getIndexedMethod("Array.getClassLiteralForArray"), new JFieldRef(sourceInfo, null, leafTypeClassLiteralField, leafTypeClassLiteralField.getEnclosingType()), this.getLiteralInt(dimensions));
    }

    public Map<JReferenceType, JCastMap> getCastMap() {
        return Collections.unmodifiableMap(this.castMaps);
    }

    public JCastMap getCastMap(JReferenceType referenceType) {
        if (this.castMaps == null) {
            this.initTypeInfo(null);
        }
        return this.castMaps.get(referenceType);
    }

    public JField getClassLiteralField(JType type) {
        return (JField)this.classLiteralFieldsByType.get(type.isJsNative() || type.isJsoType() ? this.getJavaScriptObject() : type);
    }

    public List<JDeclaredType> getDeclaredTypes() {
        return this.allTypes;
    }

    public List<JMethod> getEntryMethods() {
        return this.entryMethods;
    }

    public int getFragmentCount() {
        return this.runAsyncs.size() + 1;
    }

    public FragmentPartitioningResult getFragmentPartitioningResult() {
        return this.fragmentPartitioningResult;
    }

    public JDeclaredType getFromTypeMap(String qualifiedBinaryOrSourceName) {
        String srcTypeName = qualifiedBinaryOrSourceName.replace('$', '.');
        return this.typeNameMap.get(srcTypeName);
    }

    public JField getIndexedField(String string) {
        JField field = this.indexedFields.get(string);
        if (field == null) {
            throw new InternalCompilerException("Unable to locate index field: " + string);
        }
        return field;
    }

    public Set<JField> getIndexedFields() {
        return ImmutableSet.copyOf(this.indexedFields.values());
    }

    public JMethod getIndexedMethod(String string) {
        JMethod method = this.indexedMethods.get(string);
        if (method == null) {
            throw new InternalCompilerException("Unable to locate index method: " + string);
        }
        return method;
    }

    public Set<JMethod> getIndexedMethods() {
        return ImmutableSet.copyOf(this.indexedMethods.values());
    }

    public JMethod getIndexedMethodOrNull(String string) {
        return this.indexedMethods.get(string);
    }

    public JDeclaredType getIndexedType(String string) {
        JDeclaredType type = this.indexedTypes.get(string);
        if (type == null) {
            throw new InternalCompilerException("Unable to locate index type: " + string);
        }
        return type;
    }

    public Collection<JDeclaredType> getIndexedTypes() {
        return Collections.unmodifiableCollection(this.indexedTypes.values());
    }

    public LinkedHashSet<JRunAsync> getInitialAsyncSequence() {
        return this.initialAsyncSequence;
    }

    public List<Integer> getInitialFragmentIdSequence() {
        return this.initialFragmentIdSequence;
    }

    public JClassType getJavaScriptObject() {
        return this.typeSpecialJavaScriptObject;
    }

    public JLiteral getLiteral(Object value) {
        return this.getLiteral(SourceOrigin.UNKNOWN, value);
    }

    public JLiteral getLiteral(SourceInfo info, Object value) {
        if (value == null) {
            return this.getLiteralNull();
        }
        if (value instanceof String) {
            return this.getStringLiteral(info, (String)value);
        }
        if (value instanceof Integer) {
            return this.getLiteralInt((Integer)value);
        }
        if (value instanceof Long) {
            return this.getLiteralLong((Long)value);
        }
        if (value instanceof Character) {
            return this.getLiteralChar(((Character)value).charValue());
        }
        if (value instanceof Boolean) {
            return this.getLiteralBoolean((Boolean)value);
        }
        if (value instanceof Double) {
            return this.getLiteralDouble((Double)value);
        }
        if (value instanceof Float) {
            return this.getLiteralFloat(((Float)value).floatValue());
        }
        throw new IllegalArgumentException("Unknown literal type for " + value);
    }

    public JBooleanLiteral getLiteralBoolean(boolean value) {
        return JBooleanLiteral.get(value);
    }

    public JCharLiteral getLiteralChar(char value) {
        return JCharLiteral.get(value);
    }

    public JDoubleLiteral getLiteralDouble(double d) {
        return JDoubleLiteral.get(d);
    }

    public JFloatLiteral getLiteralFloat(double f) {
        return JFloatLiteral.get(f);
    }

    public JIntLiteral getLiteralInt(int value) {
        return JIntLiteral.get(value);
    }

    public JLongLiteral getLiteralLong(long value) {
        return JLongLiteral.get(value);
    }

    public JNullLiteral getLiteralNull() {
        return JNullLiteral.INSTANCE;
    }

    public JStringLiteral getStringLiteral(SourceInfo sourceInfo, String s) {
        sourceInfo.addCorrelation(sourceInfo.getCorrelator().by(Correlation.Literal.STRING));
        return new JStringLiteral(sourceInfo, StringInterner.get().intern(s), this.typeString);
    }

    public List<JDeclaredType> getModuleDeclaredTypes() {
        ArrayList<JDeclaredType> moduleDeclaredTypes = Lists.newArrayList();
        for (JDeclaredType type : this.allTypes) {
            if (this.isReferenceOnly(type)) continue;
            moduleDeclaredTypes.add(type);
        }
        return moduleDeclaredTypes;
    }

    public int getNodeCount() {
        SpeedTracerLogger.Event countEvent = SpeedTracerLogger.start(CompilerEventType.OPTIMIZE, "phase", "countNodes");
        TreeStatistics treeStats = new TreeStatistics();
        treeStats.accept(this);
        int numNodes = treeStats.getNodeCount();
        countEvent.end(new String[0]);
        return numNodes;
    }

    public JField getNullField() {
        return JField.NULL_FIELD;
    }

    public JMethod getNullMethod() {
        return JMethod.NULL_METHOD;
    }

    public List<JRunAsync> getRunAsyncs() {
        return this.runAsyncs;
    }

    public int getCommonAncestorFragmentId(int thisFragmentId, int thatFragmentId) {
        return this.fragmentPartitioningResult.getCommonAncestorFragmentId(thisFragmentId, thatFragmentId);
    }

    public Collection<JType> getSubclasses(JType type) {
        return Collections2.transform(this.typeOracle.getSubClassNames(type.getName()), new Function<String, JType>(){

            @Override
            public JType apply(String typeName) {
                return JProgram.this.getFromTypeMap(typeName);
            }
        });
    }

    public JMethod getStaticImpl(JMethod method) {
        JMethod staticImpl = this.instanceToStaticMap.get(method);
        assert (staticImpl == null || staticImpl.getEnclosingType().getMethods().contains(staticImpl));
        return staticImpl;
    }

    public JArrayType getTypeArray(JType elementType) {
        JArrayType arrayType = this.arrayTypes.get(elementType);
        if (arrayType == null) {
            arrayType = new JArrayType(elementType);
            this.arrayTypes.put(elementType, arrayType);
        }
        return arrayType;
    }

    @Override
    public JArrayType getOrCreateArrayType(JType leafType, int dimensions) {
        assert (dimensions > 0);
        assert (!(leafType instanceof JArrayType));
        JArrayType result = this.getTypeArray(leafType);
        while (dimensions > 1) {
            result = this.getTypeArray(result);
            --dimensions;
        }
        return result;
    }

    public JType getTypeByClassLiteralField(JField field) {
        return this.typesByClassLiteralField.get(field);
    }

    public JClassType getTypeClassLiteralHolder() {
        return this.typeSpecialClassLiteralHolder;
    }

    public JType getTypeFromJsniRef(String className) {
        int dim = 0;
        while (className.endsWith("[]")) {
            ++dim;
            className = className.substring(0, className.length() - 2);
        }
        JType type = primitiveTypes.get(className);
        if (type == null) {
            type = this.getFromTypeMap(className);
        }
        if (type == null) {
            type = primitiveTypesDeprecated.get(className);
        }
        if (type == null || dim == 0) {
            return type;
        }
        return this.getOrCreateArrayType(type, dim);
    }

    public JClassType getTypeJavaLangClass() {
        return this.typeClass;
    }

    public JClassType getTypeJavaLangObject() {
        return this.typeJavaLangObject;
    }

    public JArrayType getTypeJavaLangObjectArray() {
        return this.typeJavaLangObjectArray;
    }

    public JClassType getTypeJavaLangString() {
        return this.typeString;
    }

    public Set<String> getTypeNamesToIndex() {
        return this.typeNamesToIndex;
    }

    public JPrimitiveType getTypePrimitiveBoolean() {
        return JPrimitiveType.BOOLEAN;
    }

    public JPrimitiveType getTypePrimitiveByte() {
        return JPrimitiveType.BYTE;
    }

    public JPrimitiveType getTypePrimitiveChar() {
        return JPrimitiveType.CHAR;
    }

    public JPrimitiveType getTypePrimitiveDouble() {
        return JPrimitiveType.DOUBLE;
    }

    public JPrimitiveType getTypePrimitiveFloat() {
        return JPrimitiveType.FLOAT;
    }

    public JPrimitiveType getTypePrimitiveInt() {
        return JPrimitiveType.INT;
    }

    public JPrimitiveType getTypePrimitiveLong() {
        return JPrimitiveType.LONG;
    }

    public JPrimitiveType getTypePrimitiveShort() {
        return JPrimitiveType.SHORT;
    }

    public JPrimitiveType getTypeVoid() {
        return JPrimitiveType.VOID;
    }

    public void initTypeInfo(Map<JReferenceType, JCastMap> castMapForType) {
        this.castMaps = castMapForType;
        if (this.castMaps == null) {
            this.castMaps = Maps.newIdentityHashMap();
        }
    }

    public boolean isUntypedArrayType(JType type) {
        if (!type.isArrayType()) {
            return false;
        }
        JArrayType arrayType = (JArrayType)type;
        return arrayType.getLeafType().isJsNative();
    }

    public boolean isJavaLangString(JType type) {
        assert (type != null);
        return type.getUnderlyingType() == this.typeString;
    }

    public boolean isJavaLangObject(JType type) {
        assert (type != null);
        return type.getUnderlyingType() == this.typeJavaLangObject;
    }

    public boolean isReferenceOnly(JDeclaredType type) {
        if (type != null) {
            return this.referenceOnlyTypeNames.contains(type.getName());
        }
        return false;
    }

    public boolean isStaticImpl(JMethod method) {
        return this.staticToInstanceMap.containsKey(method);
    }

    public JType normalizeJsoType(JType type) {
        if ((type = type.getUnderlyingType()) instanceof JArrayType) {
            return this.getOrCreateArrayType(this.normalizeJsoType(((JArrayType)type).getLeafType()), ((JArrayType)type).getDims());
        }
        if (type.isJsoType()) {
            return this.getJavaScriptObject();
        }
        return type;
    }

    public void putIntoTypeMap(String qualifiedBinaryName, JDeclaredType type) {
        String srcTypeName = qualifiedBinaryName.replace('$', '.');
        this.typeNameMap.put(srcTypeName, type);
    }

    public void putStaticImpl(JMethod method, JMethod staticImpl) {
        this.instanceToStaticMap.put(method, staticImpl);
        this.staticToInstanceMap.put(staticImpl, method);
    }

    public void recordClassLiteralFields(Map<JType, JField> classLiteralFields) {
        this.classLiteralFieldsByType = HashBiMap.create(classLiteralFields);
        this.typesByClassLiteralField = this.classLiteralFieldsByType.inverse();
    }

    public void removeStaticImplMapping(JMethod staticImpl) {
        JMethod instanceMethod = this.staticToInstanceMap.remove(staticImpl);
        if (instanceMethod != null) {
            this.instanceToStaticMap.remove(instanceMethod);
        }
    }

    public void removeReferenceOnlyType(JDeclaredType type) {
        this.referenceOnlyTypeNames.remove(type.getName());
    }

    public void setFragmentPartitioningResult(FragmentPartitioningResult result) {
        this.fragmentPartitioningResult = result;
    }

    public void setInitialFragmentIdSequence(List<Integer> initialFragmentIdSequence) {
        this.initialFragmentIdSequence = initialFragmentIdSequence;
    }

    public void setRunAsyncs(List<JRunAsync> runAsyncs) {
        this.runAsyncs = ImmutableList.copyOf(runAsyncs);
    }

    public void setInitialAsyncSequence(LinkedHashSet<JRunAsync> initialAsyncSequence) {
        assert (this.initialAsyncSequence.isEmpty());
        this.initialFragmentIdSequence = Lists.newArrayList();
        this.initialFragmentIdSequence.addAll(Collections2.transform(initialAsyncSequence, new Function<JRunAsync, Integer>(){

            @Override
            public Integer apply(JRunAsync runAsync) {
                return runAsync.getRunAsyncId();
            }
        }));
        this.initialAsyncSequence = initialAsyncSequence;
    }

    public JMethod instanceMethodForStaticImpl(JMethod method) {
        return this.staticToInstanceMap.get(method);
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            this.visitModuleTypes(visitor);
        }
        visitor.endVisit(this, ctx);
    }

    private static Set<String> buildInitialTypeNamesToIndex() {
        HashSet<String> typeNamesToIndex = Sets.newHashSet();
        typeNamesToIndex.addAll(ImmutableList.of("java.io.Serializable", "java.lang.Object", "java.lang.String", "java.lang.Class", "java.lang.CharSequence", "java.lang.Cloneable", "java.lang.Comparable", "java.lang.Enum", "java.lang.Iterable", "java.util.Iterator", "java.lang.AssertionError", "java.lang.Boolean", new String[]{"java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Throwable", "com.google.gwt.core.client.GWT", JAVASCRIPTOBJECT, CLASS_LITERAL_HOLDER, "com.google.gwt.core.client.RunAsyncCallback", "com.google.gwt.core.client.impl.AsyncFragmentLoader", "com.google.gwt.core.client.impl.Impl", "com.google.gwt.core.client.prefetch.RunAsyncCode", "java.util.Objects"}));
        typeNamesToIndex.addAll(CODEGEN_TYPES_SET);
        return typeNamesToIndex;
    }

    public void visitAllTypes(JVisitor visitor) {
        visitor.accept(this.allTypes);
    }

    public void visitModuleTypes(JVisitor visitor) {
        for (JDeclaredType type : this.allTypes) {
            if (this.isReferenceOnly(type)) continue;
            visitor.accept(type);
        }
    }

    private int countSuperTypes(JClassType type) {
        int count = 0;
        while ((type = type.getSuperClass()) != null) {
            ++count;
        }
        return count;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.allTypes = JProgram.deserializeTypes(stream);
        stream.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        JProgram.serializeTypes(this.allTypes, stream);
        stream.defaultWriteObject();
    }

    static {
        if (CoverageInstrumentor.isCoverageEnabled()) {
            IMMORTAL_CODEGEN_TYPES_SET.add("com.google.gwt.lang.CoverageUtil");
        }
        CODEGEN_TYPES_SET.addAll(IMMORTAL_CODEGEN_TYPES_SET);
        primitiveTypes.put(JPrimitiveType.BOOLEAN.getName(), JPrimitiveType.BOOLEAN);
        primitiveTypes.put(JPrimitiveType.BYTE.getName(), JPrimitiveType.BYTE);
        primitiveTypes.put(JPrimitiveType.CHAR.getName(), JPrimitiveType.CHAR);
        primitiveTypes.put(JPrimitiveType.DOUBLE.getName(), JPrimitiveType.DOUBLE);
        primitiveTypes.put(JPrimitiveType.FLOAT.getName(), JPrimitiveType.FLOAT);
        primitiveTypes.put(JPrimitiveType.INT.getName(), JPrimitiveType.INT);
        primitiveTypes.put(JPrimitiveType.LONG.getName(), JPrimitiveType.LONG);
        primitiveTypes.put(JPrimitiveType.SHORT.getName(), JPrimitiveType.SHORT);
        primitiveTypes.put(JPrimitiveType.VOID.getName(), JPrimitiveType.VOID);
        primitiveTypesDeprecated.put(JPrimitiveType.BOOLEAN.getJsniSignatureName(), JPrimitiveType.BOOLEAN);
        primitiveTypesDeprecated.put(JPrimitiveType.BYTE.getJsniSignatureName(), JPrimitiveType.BYTE);
        primitiveTypesDeprecated.put(JPrimitiveType.CHAR.getJsniSignatureName(), JPrimitiveType.CHAR);
        primitiveTypesDeprecated.put(JPrimitiveType.DOUBLE.getJsniSignatureName(), JPrimitiveType.DOUBLE);
        primitiveTypesDeprecated.put(JPrimitiveType.FLOAT.getJsniSignatureName(), JPrimitiveType.FLOAT);
        primitiveTypesDeprecated.put(JPrimitiveType.INT.getJsniSignatureName(), JPrimitiveType.INT);
        primitiveTypesDeprecated.put(JPrimitiveType.LONG.getJsniSignatureName(), JPrimitiveType.LONG);
        primitiveTypesDeprecated.put(JPrimitiveType.SHORT.getJsniSignatureName(), JPrimitiveType.SHORT);
        primitiveTypesDeprecated.put(JPrimitiveType.VOID.getJsniSignatureName(), JPrimitiveType.VOID);
    }

    private static final class TreeStatistics
    extends JVisitor {
        private int nodeCount = 0;

        private TreeStatistics() {
        }

        public int getNodeCount() {
            return this.nodeCount;
        }

        @Override
        public boolean visit(JNode x, Context ctx) {
            ++this.nodeCount;
            return true;
        }
    }

    public static enum DispatchType {
        BOOLEAN(true),
        DOUBLE(true),
        STRING(true),
        HAS_JAVA_VIRTUAL_DISPATCH(false),
        JAVA_ARRAY(false),
        JSO(false);

        private final String castMapField;
        private final TypeCategory typeCategory;
        private final String className;

        private DispatchType(boolean nativeType) {
            if (nativeType) {
                String methodName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, this.name());
                this.castMapField = "Cast." + methodName + "CastMap";
                this.typeCategory = TypeCategory.valueOf("TYPE_JAVA_LANG_" + this.name());
                String simpleClassName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, this.name());
                this.className = "java.lang." + simpleClassName;
            } else {
                this.castMapField = null;
                this.typeCategory = null;
                this.className = null;
            }
        }

        public String getCastMapField() {
            return this.castMapField;
        }

        public TypeCategory getTypeCategory() {
            return this.typeCategory;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

