/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;
import java.util.Collections;
import java.util.List;

public class JPermutationDependentValue
extends JExpression {
    private final List<JExpression> resultExpressions;
    private final List<String> resultValues;
    private final JExpression defaultValueExpression;
    private final String requestedValue;
    private final Type valueType;
    private JType type;

    private JPermutationDependentValue(SourceInfo info, Type valueType, String requestedValue, List<String> resultValues, JExpression defaultValueExpression, JType resultType, List<JExpression> resultExpressions) {
        super(info);
        this.requestedValue = requestedValue;
        this.resultValues = resultValues;
        this.type = resultType;
        this.resultExpressions = resultExpressions;
        this.valueType = valueType;
        this.defaultValueExpression = defaultValueExpression;
    }

    public static JPermutationDependentValue createTypeRebind(JProgram program, SourceInfo info, String requestedType, List<String> resultTypes, List<JExpression> instantiationExpressions) {
        return new JPermutationDependentValue(info, Type.TYPE_REBIND, requestedType, resultTypes, null, program.getTypeJavaLangObject(), instantiationExpressions);
    }

    public static JPermutationDependentValue createRuntimeProperty(JProgram program, SourceInfo info, String propertyName, JExpression defaultValueExpression) {
        return new JPermutationDependentValue(info, Type.PROPERTY, propertyName, null, defaultValueExpression, program.getTypeJavaLangString(), Collections.emptyList());
    }

    public JExpression getDefaultValueExpression() {
        return this.defaultValueExpression;
    }

    public List<JExpression> getResultExpressions() {
        return this.resultExpressions;
    }

    public List<String> getResultValues() {
        return this.resultValues;
    }

    public String getRequestedValue() {
        return this.requestedValue;
    }

    @Override
    public JType getType() {
        return this.type;
    }

    public boolean isTypeRebind() {
        return this.valueType == Type.TYPE_REBIND;
    }

    public boolean isProperty() {
        return this.valueType == Type.PROPERTY;
    }

    @Override
    public boolean hasSideEffects() {
        for (JExpression expr : this.resultExpressions) {
            if (!expr.hasSideEffects()) continue;
            return true;
        }
        return false;
    }

    public void setType(JType newType) {
        this.type = newType;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            visitor.accept(this.resultExpressions);
        }
        visitor.endVisit(this, ctx);
    }

    private static enum Type {
        PROPERTY,
        TYPE_REBIND;

    }
}

