/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JParameterRef;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JParameter
extends JVariable {
    private final boolean isThis;
    private final boolean isVarags;
    private boolean isOptional;

    public JParameter(SourceInfo info, String name, JType type, boolean isFinal) {
        this(info, name, type, isFinal, false, false, false);
    }

    JParameter(SourceInfo info, String name, JType type, boolean isFinal, boolean isVarargs, boolean isThis, boolean isOptional) {
        super(info, name, type, isFinal);
        this.isThis = isThis;
        this.isVarags = isVarargs;
        this.isOptional = isOptional;
        assert (!isVarargs || type.isArrayType());
    }

    public JParameterRef createRef(SourceInfo info) {
        return new JParameterRef(info, this);
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    public boolean isThis() {
        return this.isThis;
    }

    public boolean isVarargs() {
        return this.isVarags;
    }

    public void setOptional() {
        this.isOptional = true;
    }

    @Override
    public JParameterRef makeRef(SourceInfo info) {
        return new JParameterRef(info, this);
    }

    @Override
    public void setInitializer(JDeclarationStatement declStmt) {
        throw new UnsupportedOperationException("A JParameter cannot have an initializer");
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            // empty if block
        }
        visitor.endVisit(this, ctx);
    }
}

