/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JArrayType;
import com.google.gwt.dev.jjs.ast.JClassLiteral;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JVisitor;
import java.util.List;

public class JNewArray
extends JExpression {
    private final List<JExpression> dimensionExpressions;
    private final List<JExpression> initializers;
    private JClassLiteral leafTypeClassLiteral;
    private JArrayType type;

    public static JNewArray createArrayWithDimensionExpressions(SourceInfo info, JArrayType arrayType, List<JExpression> dimensionExpressions) {
        assert (dimensionExpressions != null);
        return new JNewArray(info, arrayType, dimensionExpressions, null, new JClassLiteral(info.makeChild(), arrayType.getLeafType()));
    }

    public static JNewArray createArrayWithInitializers(SourceInfo info, JArrayType arrayType, List<JExpression> initializers) {
        assert (initializers != null);
        return new JNewArray(info, arrayType, null, initializers, new JClassLiteral(info.makeChild(), arrayType.getLeafType()));
    }

    public JNewArray(SourceInfo info, JArrayType type, List<JExpression> dimensionExpressions, List<JExpression> initializers, JClassLiteral leafTypeClassLiteral) {
        super(info);
        this.type = type;
        this.dimensionExpressions = dimensionExpressions;
        this.initializers = initializers;
        this.leafTypeClassLiteral = leafTypeClassLiteral;
        assert (!leafTypeClassLiteral.getRefType().isArrayType());
    }

    public JArrayType getArrayType() {
        return this.type;
    }

    public List<JExpression> getDimensionExpressions() {
        return this.dimensionExpressions;
    }

    public List<JExpression> getInitializers() {
        return this.initializers;
    }

    public JClassLiteral getLeafTypeClassLiteral() {
        return this.leafTypeClassLiteral;
    }

    @Override
    public JReferenceType getType() {
        return this.type.strengthenToNonNull().strengthenToExact();
    }

    @Override
    public boolean hasSideEffects() {
        assert (this.dimensionExpressions != null ^ this.initializers != null);
        for (JExpression expression : this.initializers != null ? this.initializers : this.dimensionExpressions) {
            if (!expression.hasSideEffects()) continue;
            return true;
        }
        return false;
    }

    public void setType(JArrayType type) {
        this.type = type;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            assert (this.dimensionExpressions != null ^ this.initializers != null);
            visitor.accept(this.initializers != null ? this.initializers : this.dimensionExpressions);
            this.leafTypeClassLiteral = (JClassLiteral)visitor.accept(this.leafTypeClassLiteral);
        }
        visitor.endVisit(this, ctx);
    }
}

