/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.HasName;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JNameOf
extends JExpression {
    private HasName node;
    private JClassType stringType;

    static boolean replacesNamedElement(JNode newElement, JNode oldElement) {
        if (newElement instanceof JType) {
            if (!((JType)newElement).replaces((JType)oldElement)) {
                return false;
            }
        } else if (newElement instanceof JField) {
            if (!((JField)newElement).replaces((JField)oldElement)) {
                return false;
            }
        } else if (newElement instanceof JMethod) {
            if (!((JMethod)newElement).replaces((JMethod)oldElement)) {
                return false;
            }
        } else {
            throw new InternalCompilerException("Unexpected node type.");
        }
        return true;
    }

    public JNameOf(SourceInfo info, JClassType stringType, HasName node) {
        super(info);
        this.node = node;
        this.stringType = stringType;
        assert (stringType.getName().equals("java.lang.String"));
    }

    public HasName getNode() {
        return this.node;
    }

    @Override
    public JReferenceType getType() {
        return this.stringType.strengthenToNonNull();
    }

    @Override
    public boolean hasSideEffects() {
        return false;
    }

    public void resolve(HasName node, JClassType stringType) {
        assert (JNameOf.replacesNamedElement((JNode)((Object)node), (JNode)((Object)this.node)));
        this.node = node;
        assert (stringType.replaces(this.stringType));
        this.stringType = stringType;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            // empty if block
        }
        visitor.endVisit(this, ctx);
    }
}

