/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.util.collect.Lists;
import java.util.List;

public class JModVisitor
extends JVisitor {
    private int numVisitorChanges = 0;

    protected static void checkReplacement(JNode origNode, JNode newNode) {
        if (newNode == null) {
            throw new InternalCompilerException("Cannot replace with null");
        }
        if (newNode == origNode) {
            throw new InternalCompilerException("The replacement is the same as the original");
        }
    }

    @Override
    public JNode accept(JNode node) {
        return this.accept(node, false);
    }

    @Override
    public JNode accept(JNode node, boolean allowRemove) {
        NodeContext ctx = new NodeContext(allowRemove);
        try {
            ctx.node = node;
            this.traverse(node, ctx);
            return ctx.node;
        }
        catch (Throwable e) {
            throw JModVisitor.translateException(node, e);
        }
    }

    @Override
    public <T extends JNode> void accept(List<T> list) {
        NodeContext ctx = new NodeContext(false);
        try {
            int c = list.size();
            for (int i = 0; i < c; ++i) {
                ctx.node = (JNode)list.get(i);
                this.traverse(ctx.node, ctx);
                if (!ctx.replaced) continue;
                list.set(i, ctx.node);
                ctx.replaced = false;
            }
        }
        catch (Throwable e) {
            throw JModVisitor.translateException(ctx.node, e);
        }
    }

    @Override
    public <T extends JNode> List<T> acceptImmutable(List<T> list) {
        NodeContext ctx = new NodeContext(false);
        try {
            int c = list.size();
            for (int i = 0; i < c; ++i) {
                ctx.node = (JNode)list.get(i);
                this.traverse(ctx.node, ctx);
                if (!ctx.replaced) continue;
                list = Lists.set(list, i, ctx.node);
                ctx.replaced = false;
            }
            return list;
        }
        catch (Throwable e) {
            throw JModVisitor.translateException(ctx.node, e);
        }
    }

    @Override
    public JExpression acceptLvalue(JExpression expr) {
        LvalueContext ctx = new LvalueContext();
        try {
            ctx.node = expr;
            this.traverse(expr, ctx);
            return (JExpression)ctx.node;
        }
        catch (Throwable e) {
            throw JModVisitor.translateException(expr, e);
        }
    }

    @Override
    public <T extends JNode> void acceptWithInsertRemove(List<T> list) {
        new ListContext<T>(list).traverse();
    }

    @Override
    public <T extends JNode> List<T> acceptWithInsertRemoveImmutable(List<T> list) {
        return new ListContextImmutable<T>(list).traverse();
    }

    @Override
    public final boolean didChange() {
        return this.numVisitorChanges > 0;
    }

    public int getNumMods() {
        return this.numVisitorChanges;
    }

    protected void madeChanges() {
        ++this.numVisitorChanges;
    }

    protected void traverse(JNode node, Context context) {
        node.traverse(this, context);
    }

    private class NodeContext
    implements Context {
        boolean canRemove;
        JNode node;
        boolean replaced;

        public NodeContext(boolean canRemove) {
            this.canRemove = canRemove;
        }

        @Override
        public boolean canInsert() {
            return false;
        }

        @Override
        public boolean canRemove() {
            return this.canRemove;
        }

        @Override
        public void insertBefore(JNode node) {
            throw new UnsupportedOperationException("Can't insert before " + node);
        }

        @Override
        public boolean isLvalue() {
            return false;
        }

        @Override
        public void removeMe() {
            if (!this.canRemove) {
                throw new UnsupportedOperationException("Can't remove " + this.node);
            }
            this.node = null;
            JModVisitor.this.madeChanges();
        }

        @Override
        public void replaceMe(JNode node) {
            if (this.replaced) {
                throw new InternalCompilerException("Node was already replaced");
            }
            JModVisitor.checkReplacement(this.node, node);
            this.node = node;
            this.replaced = true;
            JModVisitor.this.madeChanges();
        }
    }

    private class LvalueContext
    extends NodeContext {
        public LvalueContext() {
            super(false);
        }

        @Override
        public boolean isLvalue() {
            return true;
        }
    }

    private class ListContextImmutable<T extends JNode>
    implements Context {
        int index;
        List<T> list;
        boolean removed;
        boolean replaced;

        public ListContextImmutable(List<T> list) {
            this.list = list;
        }

        @Override
        public boolean canInsert() {
            return true;
        }

        @Override
        public boolean canRemove() {
            return true;
        }

        @Override
        public void insertBefore(JNode node) {
            this.checkRemoved();
            this.list = Lists.add(this.list, this.index++, node);
            JModVisitor.this.madeChanges();
        }

        @Override
        public boolean isLvalue() {
            return false;
        }

        @Override
        public void removeMe() {
            this.checkState();
            this.list = Lists.remove(this.list, this.index--);
            this.removed = true;
            JModVisitor.this.madeChanges();
        }

        @Override
        public void replaceMe(JNode node) {
            this.checkState();
            JModVisitor.checkReplacement((JNode)this.list.get(this.index), node);
            this.list = Lists.set(this.list, this.index, node);
            this.replaced = true;
            JModVisitor.this.madeChanges();
        }

        protected List<T> traverse() {
            try {
                this.index = 0;
                while (this.index < this.list.size()) {
                    this.replaced = false;
                    this.removed = false;
                    ((JNode)this.list.get(this.index)).traverse(JModVisitor.this, this);
                    ++this.index;
                }
                return this.list;
            }
            catch (Throwable e) {
                throw JVisitor.translateException((JNode)this.list.get(this.index), e);
            }
        }

        private void checkRemoved() {
            if (this.removed) {
                throw new InternalCompilerException("Node was already removed");
            }
        }

        private void checkState() {
            this.checkRemoved();
            if (this.replaced) {
                throw new InternalCompilerException("Node was already replaced");
            }
        }
    }

    private class ListContext<T extends JNode>
    implements Context {
        int index;
        final List<T> list;
        boolean removed;
        boolean replaced;

        public ListContext(List<T> list) {
            this.list = list;
        }

        @Override
        public boolean canInsert() {
            return true;
        }

        @Override
        public boolean canRemove() {
            return true;
        }

        @Override
        public void insertBefore(JNode node) {
            this.checkRemoved();
            this.list.add(this.index++, node);
            JModVisitor.this.madeChanges();
        }

        @Override
        public boolean isLvalue() {
            return false;
        }

        @Override
        public void removeMe() {
            this.checkState();
            this.list.remove(this.index--);
            this.removed = true;
            JModVisitor.this.madeChanges();
        }

        @Override
        public void replaceMe(JNode node) {
            this.checkState();
            JModVisitor.checkReplacement((JNode)this.list.get(this.index), node);
            this.list.set(this.index, node);
            this.replaced = true;
            JModVisitor.this.madeChanges();
        }

        protected void traverse() {
            try {
                this.index = 0;
                while (this.index < this.list.size()) {
                    this.replaced = false;
                    this.removed = false;
                    ((JNode)this.list.get(this.index)).traverse(JModVisitor.this, this);
                    ++this.index;
                }
            }
            catch (Throwable e) {
                throw JVisitor.translateException((JNode)this.list.get(this.index), e);
            }
        }

        private void checkRemoved() {
            if (this.removed) {
                throw new InternalCompilerException("Node was already removed");
            }
        }

        private void checkState() {
            this.checkRemoved();
            if (this.replaced) {
                throw new InternalCompilerException("Node was already replaced");
            }
        }
    }
}

