/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.util.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class JMethodCall
extends JExpression {
    private List<JExpression> args = Collections.emptyList();
    private JExpression instance;
    private JMethod method;
    private JType overriddenReturnType;
    private Polymorphism polymorphism = Polymorphism.NORMAL;
    private boolean markedAsSideAffectFree;

    public JMethodCall(JMethodCall other, JExpression instance, JExpression ... args) {
        this(other, instance, Arrays.asList(args));
    }

    public JMethodCall(JMethodCall other, JExpression instance, List<JExpression> args) {
        super(other.getSourceInfo());
        this.instance = instance;
        this.method = other.method;
        this.overriddenReturnType = other.overriddenReturnType;
        this.polymorphism = other.polymorphism;
        this.markedAsSideAffectFree = other.markedAsSideAffectFree;
        this.addArgs(args);
    }

    public JMethodCall(SourceInfo info, JExpression instance, JMethod method, List<JExpression> args) {
        super(info);
        assert (method != null);
        assert (instance != null || method.isStatic() || this instanceof JNewInstance);
        this.instance = instance;
        this.method = method;
        this.overriddenReturnType = null;
        this.addArgs(args);
    }

    public JMethodCall(SourceInfo info, JExpression instance, JMethod method, JExpression ... args) {
        this(info, instance, method, Arrays.asList(args));
    }

    public void addArg(int index, JExpression toAdd) {
        this.args = Lists.add(this.args, index, toAdd);
    }

    public void addArg(JExpression toAdd) {
        this.args = Lists.add(this.args, toAdd);
    }

    public void addArgs(JExpression ... toAdd) {
        this.args = Lists.addAll(this.args, toAdd);
    }

    public void addArgs(List<JExpression> toAdd) {
        this.args = Lists.addAll(this.args, toAdd);
    }

    public boolean canBePolymorphic() {
        return this.polymorphism.canBePolymorphic() && !this.method.isFinal() && this.method.canBePolymorphic();
    }

    public JMethodCall cloneWithoutParameters() {
        return new JMethodCall(this, this.instance, new JExpression[0]);
    }

    public List<JExpression> getArgs() {
        return this.args;
    }

    public JExpression getInstance() {
        return this.instance;
    }

    public JMethod getTarget() {
        return this.method;
    }

    @Override
    public JType getType() {
        return this.overriddenReturnType != null ? this.overriddenReturnType : this.method.getType();
    }

    public void markSideEffectFree() {
        this.markedAsSideAffectFree = true;
    }

    @Override
    public boolean hasSideEffects() {
        if (this.markedAsSideAffectFree) {
            return false;
        }
        return this.isStaticDispatchOnly() || this.method.isStatic() ? this.method.hasSideEffects() : true;
    }

    public boolean isStaticDispatchOnly() {
        return this.polymorphism.isStaticDispatchOnly();
    }

    public boolean isVolatile() {
        return this.polymorphism.isVolatile();
    }

    public void overrideReturnType(JType overridenReturnType) {
        assert (this.overriddenReturnType == null);
        this.overriddenReturnType = overridenReturnType;
    }

    public void resolve(JMethod newMethod) {
        assert (newMethod.replaces(this.method));
        this.method = newMethod;
    }

    public void setArg(int index, JExpression arg) {
        this.args = Lists.set(this.args, index, arg);
    }

    public void setCannotBePolymorphic() {
        assert (this.polymorphism == Polymorphism.NORMAL);
        assert (!this.method.isAbstract()) : "Cannot set static dispacth to an abstract method: " + this.method;
        this.polymorphism = Polymorphism.CANNOT_BE_POLYMORPHIC;
    }

    public void setStaticDispatchOnly() {
        assert (this.polymorphism == Polymorphism.NORMAL);
        this.polymorphism = Polymorphism.STATIC_DISPATCH_ONLY;
    }

    public void setVolatile() {
        assert (this.polymorphism == Polymorphism.NORMAL);
        this.polymorphism = Polymorphism.VOLATILE;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            this.visitChildren(visitor);
        }
        visitor.endVisit(this, ctx);
    }

    protected void visitChildren(JVisitor visitor) {
        if (this.instance != null) {
            this.instance = visitor.accept(this.instance);
        }
        this.args = visitor.acceptImmutable(this.args);
    }

    private static enum Polymorphism {
        CANNOT_BE_POLYMORPHIC,
        NORMAL,
        STATIC_DISPATCH_ONLY,
        VOLATILE;


        public boolean canBePolymorphic() {
            return this != CANNOT_BE_POLYMORPHIC && this != STATIC_DISPATCH_ONLY;
        }

        public boolean isStaticDispatchOnly() {
            return this == STATIC_DISPATCH_ONLY;
        }

        public boolean isVolatile() {
            return this == VOLATILE;
        }
    }
}

