/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JAbstractMethodBody;
import com.google.gwt.dev.jjs.ast.JBlock;
import com.google.gwt.dev.jjs.ast.JLocal;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.util.collect.Lists;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class JMethodBody
extends JAbstractMethodBody {
    private JBlock block;
    private List<JLocal> locals = Collections.emptyList();

    public JMethodBody(SourceInfo info) {
        super(info);
        this.block = new JBlock(info, new JStatement[0]);
    }

    public void addLocal(JLocal local) {
        this.locals = Lists.add(this.locals, local);
    }

    public JBlock getBlock() {
        return this.block;
    }

    public List<JLocal> getLocals() {
        return this.locals;
    }

    public List<JStatement> getStatements() {
        return this.block.getStatements();
    }

    @Override
    public boolean isJsniMethodBody() {
        return false;
    }

    public void removeLocal(int index) {
        this.locals = Lists.remove(this.locals, index);
    }

    public void sortLocals(Comparator<? super JLocal> sort) {
        this.locals = Lists.sort(this.locals, sort);
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            this.locals = visitor.acceptImmutable(this.locals);
            this.block = (JBlock)visitor.accept(this.block);
        }
        visitor.endVisit(this, ctx);
    }
}

