/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.common.InliningMode;
import com.google.gwt.dev.javac.JsInteropUtil;
import com.google.gwt.dev.jjs.InternalCompilerException;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.AccessModifier;
import com.google.gwt.dev.jjs.ast.CanBeAbstract;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.HasJsInfo;
import com.google.gwt.dev.jjs.ast.JAbstractMethodBody;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JMember;
import com.google.gwt.dev.jjs.ast.JNode;
import com.google.gwt.dev.jjs.ast.JParameter;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.jjs.ast.js.JsniMethodBody;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import com.google.gwt.thirdparty.guava.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public class JMethod
extends JNode
implements JMember,
CanBeAbstract {
    public static final Comparator<JMethod> BY_SIGNATURE_COMPARATOR = new Comparator<JMethod>(){

        @Override
        public int compare(JMethod m1, JMethod m2) {
            return m1.getSignature().compareTo(m2.getSignature());
        }
    };
    private HasJsInfo.JsMemberType jsMemberType = HasJsInfo.JsMemberType.NONE;
    private String jsName;
    private String jsNamespace;
    private boolean exported;
    private boolean isJsOverlay = false;
    private Specialization specialization;
    private InliningMode inliningMode = InliningMode.NORMAL;
    private boolean preventDevirtualization = false;
    private boolean hasSideEffects = true;
    private boolean defaultMethod = false;
    private boolean syntheticAccidentalOverride = false;
    private Set<String> suppressedWarnings;
    public static final JMethod NULL_METHOD = new JMethod(SourceOrigin.UNKNOWN, "nullMethod", JClassType.NULL_CLASS, JReferenceType.NULL_TYPE, false, false, true, AccessModifier.PUBLIC);
    protected transient String signature;
    private int access;
    private transient JAbstractMethodBody body = null;
    private final JDeclaredType enclosingType;
    private boolean isAbstract;
    private boolean isFinal;
    private final boolean isStatic;
    private boolean isSynthetic = false;
    private boolean isForwarding = false;
    private final String name;
    private List<JType> originalParamTypes;
    private JType originalReturnType;
    private Set<JMethod> overriddenMethods = Sets.newLinkedHashSet();
    private Set<JMethod> overridingMethods = Sets.newLinkedHashSet();
    private List<JParameter> params = Collections.emptyList();
    private JType returnType;
    private List<JClassType> thrownExceptions = Collections.emptyList();

    @Override
    public void setJsMemberInfo(HasJsInfo.JsMemberType type, String namespace, String name, boolean exported) {
        this.jsMemberType = type;
        this.jsName = name;
        this.jsNamespace = namespace;
        this.exported = exported;
    }

    @Override
    public boolean isJsInteropEntryPoint() {
        return this.exported && !this.needsDynamicDispatch() && !this.isJsNative() && !this.isJsOverlay();
    }

    @Override
    public boolean canBeReferencedExternally() {
        if (this.isJsOverlay() || !this.needsDynamicDispatch() && this.isJsNative()) {
            return false;
        }
        for (JMethod method : this.getOverriddenMethodsIncludingSelf()) {
            if (!method.exported && !method.isJsFunctionMethod() && !method.isJsNative()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeImplementedExternally() {
        return this.isJsNative() || this.isJsFunctionMethod();
    }

    public JParameter createFinalParameter(SourceInfo info, String name, JType type) {
        return this.createParameter(info, name, type, true, false, false, false);
    }

    public JParameter createParameter(SourceInfo info, String name, JType type) {
        return this.createParameter(info, name, type, false, false, false, false);
    }

    public JParameter createParameter(SourceInfo info, String name, JType type, boolean isFinal, boolean isVarargs) {
        return this.createParameter(info, name, type, isFinal, isVarargs, false, false);
    }

    public JParameter cloneParameter(JParameter from) {
        return this.createParameter(from.getSourceInfo(), from.getName(), from.getType(), from.isFinal(), from.isVarargs(), from.isThis(), from.isOptional());
    }

    public JParameter createThisParameter(SourceInfo info, JType type) {
        return this.createParameter(info, "this$static", type, true, false, true, false);
    }

    private JParameter createParameter(SourceInfo info, String name, JType type, boolean isFinal, boolean isVarargs, boolean isThis, boolean isOptional) {
        assert (name != null);
        assert (type != null);
        JParameter parameter = new JParameter(info, name, type, isFinal, isVarargs, isThis, isOptional);
        this.addParameter(parameter);
        return parameter;
    }

    private void addParameter(JParameter x) {
        assert (this.params.isEmpty() || !this.params.get(this.params.size() - 1).isVarargs() || this.getEnclosingType().getClassDisposition().isLocalType());
        this.params = Lists.add(this.params, x);
    }

    private boolean isInterfaceMethod() {
        return this.enclosingType instanceof JInterfaceType;
    }

    @Override
    public String getJsNamespace() {
        if (this.jsNamespace == null) {
            this.jsNamespace = this.enclosingType.getQualifiedJsName();
        }
        return this.jsNamespace;
    }

    @Override
    public String getQualifiedJsName() {
        String namespace = this.getJsNamespace();
        String actualJsName = this.getJsName();
        if (actualJsName.isEmpty()) {
            assert (!this.needsDynamicDispatch());
            return namespace;
        }
        if (JsInteropUtil.isGlobal(namespace) || JsInteropUtil.isWindow(namespace)) {
            assert (!this.needsDynamicDispatch());
            return namespace + "." + actualJsName;
        }
        return namespace + (this.isStatic() ? "." : ".prototype.") + actualJsName;
    }

    @Override
    public String getJsName() {
        for (JMethod method : this.getOverriddenMethodsIncludingSelf()) {
            if (method.jsName == null) continue;
            return method.jsName;
        }
        return this.getJsMemberType().computeName(this);
    }

    public boolean isJsConstructor() {
        return this.getJsMemberType() == HasJsInfo.JsMemberType.CONSTRUCTOR;
    }

    public boolean exposesNonJsMember() {
        if (this.isInterfaceMethod() || this.enclosingType.isJsNative() || !JjsUtils.requiresJsName(this)) {
            return false;
        }
        boolean hasNonJsMemberParent = false;
        for (JMethod overriddenMethod : this.overriddenMethods) {
            if (!JjsUtils.requiresJsName(overriddenMethod)) {
                hasNonJsMemberParent = true;
            }
            if (!overriddenMethod.exposesNonJsMember()) continue;
            return false;
        }
        return hasNonJsMemberParent;
    }

    @Override
    public HasJsInfo.JsMemberType getJsMemberType() {
        for (JMethod method : this.getOverriddenMethodsIncludingSelf()) {
            if (method.jsMemberType == HasJsInfo.JsMemberType.NONE) continue;
            return method.jsMemberType;
        }
        return HasJsInfo.JsMemberType.NONE;
    }

    private boolean isJsFunctionMethod() {
        return this.enclosingType.isJsFunction() && this.isAbstract();
    }

    public boolean isOrOverridesJsFunctionMethod() {
        for (JMethod method : this.getOverriddenMethodsIncludingSelf()) {
            if (!method.isJsFunctionMethod()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isJsNative() {
        return this.body == null || !this.isJsOverlay() && this.getEnclosingType().isJsNative() && !JProgram.isClinit(this);
    }

    @Override
    public boolean isJsOverlay() {
        return this.isJsOverlay || this.getEnclosingType().isJsoType();
    }

    public void setSyntheticAccidentalOverride() {
        this.syntheticAccidentalOverride = true;
    }

    public boolean isSyntheticAccidentalOverride() {
        return this.syntheticAccidentalOverride;
    }

    public void setSpecialization(List<JType> paramTypes, JType returnsType, String targetMethod) {
        this.specialization = new Specialization(paramTypes, returnsType == null ? this.getOriginalReturnType() : returnsType, targetMethod);
    }

    public Specialization getSpecialization() {
        return this.specialization;
    }

    public void removeSpecialization() {
        this.specialization = null;
    }

    public boolean isInliningAllowed() {
        return this.inliningMode != InliningMode.DO_NOT_INLINE;
    }

    public InliningMode getInliningMode() {
        return this.inliningMode;
    }

    public void setInliningMode(InliningMode inliningMode) {
        this.inliningMode = inliningMode;
    }

    public boolean hasSideEffects() {
        return this.hasSideEffects;
    }

    public void setHasSideEffects(boolean hasSideEffects) {
        this.hasSideEffects = hasSideEffects;
    }

    public void setDefaultMethod(boolean defaultMethod) {
        this.defaultMethod = defaultMethod;
    }

    @Override
    public void setJsOverlay() {
        this.isJsOverlay = true;
    }

    public boolean isDefaultMethod() {
        return this.defaultMethod;
    }

    public boolean isDevirtualizationAllowed() {
        return !this.preventDevirtualization;
    }

    public void disallowDevirtualization() {
        this.preventDevirtualization = true;
    }

    @Override
    public boolean isJsMethodVarargs() {
        if (this.getParams().isEmpty() || !this.canBeReferencedExternally() && !this.canBeImplementedExternally()) {
            return false;
        }
        JParameter lastParameter = Iterables.getLast(this.getParams());
        return lastParameter.isVarargs();
    }

    public JMethod(SourceInfo info, String name, JDeclaredType enclosingType, JType returnType, boolean isAbstract, boolean isStatic, boolean isFinal, AccessModifier access) {
        super(info);
        this.name = StringInterner.get().intern(name);
        this.enclosingType = enclosingType;
        this.returnType = returnType;
        this.isAbstract = isAbstract;
        this.isStatic = isStatic;
        this.isFinal = isFinal;
        this.access = access.ordinal();
    }

    public static JMethod getExternalizedMethod(String fullClassName, String signature, boolean isStatic) {
        JClassType cls = new JClassType(fullClassName);
        return new JMethod(signature, cls, isStatic);
    }

    private JMethod(String signature, JDeclaredType enclosingType, boolean isStatic) {
        this(SourceOrigin.UNKNOWN, StringInterner.get().intern(signature.substring(0, signature.indexOf(40))), enclosingType, null, false, isStatic, false, AccessModifier.PUBLIC);
        this.signature = signature;
    }

    public void addOverriddenMethod(JMethod overriddenMethod) {
        assert (this.canBePolymorphic()) : this + " is not polymorphic";
        assert (overriddenMethod != this) : this + " cannot override itself";
        this.overriddenMethods.add(overriddenMethod);
    }

    public void addOverridingMethod(JMethod overridingMethod) {
        assert (this.canBePolymorphic()) : this + " is not polymorphic";
        assert (overridingMethod != this) : this + " cannot override itself";
        this.overridingMethods.add(overridingMethod);
    }

    public void addThrownException(JClassType exceptionType) {
        this.thrownExceptions = Lists.add(this.thrownExceptions, exceptionType);
    }

    public void addThrownExceptions(List<JClassType> exceptionTypes) {
        this.thrownExceptions = Lists.addAll(this.thrownExceptions, exceptionTypes);
    }

    public boolean canBePolymorphic() {
        return !this.isStatic() && !this.isPrivate();
    }

    public void freezeParamTypes() {
        ArrayList<JType> paramTypes = new ArrayList<JType>();
        for (JParameter param : this.params) {
            paramTypes.add(param.getType());
        }
        this.setOriginalTypes(this.returnType, paramTypes);
    }

    public boolean exposesPackagePrivateMethod() {
        if (this.isPrivate() || this.isPackagePrivate()) {
            return false;
        }
        boolean hasPackageVisibleParent = false;
        for (JMethod overriddenMethod : this.overriddenMethods) {
            if (overriddenMethod.isInterfaceMethod()) continue;
            if (!overriddenMethod.isPackagePrivate()) {
                return false;
            }
            hasPackageVisibleParent = true;
        }
        return hasPackageVisibleParent;
    }

    public AccessModifier getAccess() {
        return AccessModifier.values()[this.access];
    }

    public JAbstractMethodBody getBody() {
        assert (!this.isExternal()) : "External types do not have method bodies.";
        return this.body;
    }

    @Override
    public JDeclaredType getEnclosingType() {
        return this.enclosingType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return this.enclosingType.getName() + "." + this.getSignature();
    }

    public List<JType> getOriginalParamTypes() {
        return this.originalParamTypes;
    }

    public JType getOriginalReturnType() {
        return this.originalReturnType;
    }

    public Set<JMethod> getOverriddenMethods() {
        return this.overriddenMethods;
    }

    private Iterable<JMethod> getOverriddenMethodsIncludingSelf() {
        return Iterables.concat(Collections.singleton(this), this.overriddenMethods);
    }

    public Set<JMethod> getOverridingMethods() {
        return this.overridingMethods;
    }

    public List<JParameter> getParams() {
        return this.params;
    }

    public String getSignature() {
        if (this.signature == null) {
            this.signature = StringInterner.get().intern(JjsUtils.computeSignature(this.name, this.getOriginalParamTypes(), this.getOriginalReturnType(), this.isConstructor()));
        }
        return this.signature;
    }

    public String getJsniSignature(boolean includeEnclosingClass, boolean includeReturnType) {
        StringBuilder sb = new StringBuilder();
        if (includeEnclosingClass) {
            sb.append(this.getEnclosingType().getName());
            sb.append("::");
        }
        sb.append(this.name);
        sb.append('(');
        for (JType type : this.getOriginalParamTypes()) {
            sb.append(type.getJsniSignatureName());
        }
        sb.append(')');
        if (includeReturnType) {
            sb.append(this.originalReturnType.getJsniSignatureName());
        }
        return sb.toString();
    }

    public List<JClassType> getThrownExceptions() {
        return this.thrownExceptions;
    }

    @Override
    public JType getType() {
        return this.returnType;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isPackagePrivate() {
        return this.access == AccessModifier.DEFAULT.ordinal();
    }

    @Override
    public boolean isExternal() {
        return this.getEnclosingType().isExternal();
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isForwarding() {
        return this.isForwarding;
    }

    public boolean isJsniMethod() {
        if (this.body == null) {
            return false;
        }
        return this.body.isJsniMethodBody();
    }

    @Override
    public boolean isPrivate() {
        return this.access == AccessModifier.PRIVATE.ordinal();
    }

    @Override
    public boolean isPublic() {
        return this.access == AccessModifier.PUBLIC.ordinal();
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    @Override
    public boolean needsDynamicDispatch() {
        return !this.isStatic();
    }

    public void removeParam(int index) {
        this.params = Lists.remove(this.params, index);
        if (this.isJsniMethod()) {
            ((JsniMethodBody)this.getBody()).getFunc().getParameters().remove(index);
        }
    }

    public void resolve(JType originalReturnType, List<JType> originalParamTypes, JType returnType, List<JClassType> thrownExceptions) {
        if (this.getClass().desiredAssertionStatus()) {
            assert (originalReturnType.replaces(this.originalReturnType));
            assert (JType.replaces(originalParamTypes, this.originalParamTypes));
            assert (returnType.replaces(this.returnType));
            assert (JType.replaces(thrownExceptions, this.thrownExceptions));
        }
        this.originalReturnType = originalReturnType;
        this.originalParamTypes = Lists.normalize(originalParamTypes);
        this.returnType = returnType;
        this.thrownExceptions = Lists.normalize(thrownExceptions);
    }

    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    public void setBody(JAbstractMethodBody body) {
        this.body = body;
        if (body != null) {
            body.setMethod(this);
        }
    }

    @Override
    public void setFinal() {
        this.setFinal(true);
    }

    public void setFinal(boolean isFinal) {
        this.isFinal = isFinal;
    }

    public void setForwarding() {
        this.isForwarding = true;
    }

    public void setOriginalTypes(JType returnType, List<JType> paramTypes) {
        if (this.originalParamTypes != null) {
            throw new InternalCompilerException("Param types already frozen");
        }
        this.originalReturnType = returnType;
        this.originalParamTypes = Lists.normalize(paramTypes);
    }

    public void setSynthetic() {
        this.isSynthetic = true;
    }

    public void setType(JType newType) {
        this.returnType = newType;
    }

    @Override
    public Set<String> getSuppressedWarnings() {
        return this.suppressedWarnings;
    }

    @Override
    public void setSuppressedWarnings(Set<String> suppressedWarnings) {
        this.suppressedWarnings = suppressedWarnings;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            this.visitChildren(visitor);
        }
        visitor.endVisit(this, ctx);
    }

    protected void visitChildren(JVisitor visitor) {
        this.params = visitor.acceptImmutable(this.params);
        if (this.body != null) {
            this.body = (JAbstractMethodBody)visitor.accept(this.body);
        }
    }

    protected Object writeReplace() {
        if (this.isExternal()) {
            return new ExternalSerializedForm(this);
        }
        if (this == NULL_METHOD) {
            return ExternalSerializedNullMethod.INSTANCE;
        }
        return this;
    }

    void readBody(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.body = (JAbstractMethodBody)stream.readObject();
    }

    boolean replaces(JMethod originalMethod) {
        if (this == originalMethod) {
            return true;
        }
        return originalMethod.isExternal() && originalMethod.getSignature().equals(this.getSignature()) && this.getEnclosingType().replaces(originalMethod.getEnclosingType());
    }

    void writeBody(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.body);
    }

    static {
        NULL_METHOD.setSynthetic();
        NULL_METHOD.freezeParamTypes();
    }

    private static class ExternalSerializedNullMethod
    implements Serializable {
        public static final ExternalSerializedNullMethod INSTANCE = new ExternalSerializedNullMethod();

        private ExternalSerializedNullMethod() {
        }

        private Object readResolve() {
            return NULL_METHOD;
        }
    }

    private static class ExternalSerializedForm
    implements Serializable {
        private final JDeclaredType enclosingType;
        private final String signature;

        public ExternalSerializedForm(JMethod method) {
            this.enclosingType = method.getEnclosingType();
            this.signature = method.getSignature();
        }

        private Object readResolve() {
            return new JMethod(this.signature, this.enclosingType, false);
        }
    }

    public static class Specialization
    implements Serializable {
        private List<JType> params;
        private JType returns;
        private String target;
        private JMethod targetMethod;

        public Specialization(List<JType> params, JType returns, String target) {
            this.params = params;
            this.returns = returns;
            this.target = target;
        }

        public List<JType> getParams() {
            return this.params;
        }

        public JType getReturns() {
            return this.returns;
        }

        public String getTarget() {
            return this.target;
        }

        public JMethod getTargetMethod() {
            return this.targetMethod;
        }

        public void resolve(List<JType> resolvedParams, JType resolvedReturn, JMethod targetMethod) {
            this.params = resolvedParams;
            this.returns = resolvedReturn;
            this.targetMethod = targetMethod;
        }
    }
}

