/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JLongLiteral
extends JValueLiteral {
    public static final JLongLiteral ZERO = new JLongLiteral(SourceOrigin.UNKNOWN, 0L);
    private final long value;

    public static JLongLiteral get(long value) {
        return value == 0L ? ZERO : new JLongLiteral(SourceOrigin.UNKNOWN, value);
    }

    public JLongLiteral(SourceInfo sourceInfo, long value) {
        super(sourceInfo);
        this.value = value;
    }

    @Override
    public JType getType() {
        return JPrimitiveType.LONG;
    }

    public long getValue() {
        return this.value;
    }

    @Override
    public Object getValueObj() {
        return this.value;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            // empty if block
        }
        visitor.endVisit(this, ctx);
    }

    private Object readResolve() {
        return this.value == 0L ? ZERO : this;
    }
}

