/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JIntLiteral
extends JValueLiteral {
    public static final JIntLiteral ZERO = new JIntLiteral(SourceOrigin.UNKNOWN, 0);
    private final int value;

    public static JIntLiteral get(int value) {
        return value == 0 ? ZERO : new JIntLiteral(SourceOrigin.UNKNOWN, value);
    }

    public JIntLiteral(SourceInfo sourceInfo, int value) {
        super(sourceInfo);
        this.value = value;
    }

    @Override
    public JType getType() {
        return JPrimitiveType.INT;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public Object getValueObj() {
        return this.value;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            // empty if block
        }
        visitor.endVisit(this, ctx);
    }

    private Object readResolve() {
        return this.value == 0 ? ZERO : this;
    }
}

