/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JInstanceOf
extends JExpression {
    private JExpression expr;
    private JReferenceType testType;

    public JInstanceOf(SourceInfo info, JReferenceType testType, JExpression expression) {
        super(info);
        this.testType = testType;
        this.expr = expression;
    }

    public JExpression getExpr() {
        return this.expr;
    }

    public JReferenceType getTestType() {
        return this.testType;
    }

    @Override
    public JType getType() {
        return JPrimitiveType.BOOLEAN;
    }

    @Override
    public boolean hasSideEffects() {
        return this.expr.hasSideEffects();
    }

    public void resolve(JReferenceType newType) {
        assert (newType.replaces(this.testType));
        this.testType = newType;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            this.expr = visitor.accept(this.expr);
        }
        visitor.endVisit(this, ctx);
    }
}

