/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JBooleanLiteral;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JIfStatement
extends JStatement {
    private JStatement elseStmt;
    private JExpression ifExpr;
    private JStatement thenStmt;

    public JIfStatement(SourceInfo info, JExpression ifExpr, JStatement thenStmt, JStatement elseStmt) {
        super(info);
        this.ifExpr = ifExpr;
        this.thenStmt = thenStmt;
        this.elseStmt = elseStmt;
    }

    public JStatement getElseStmt() {
        return this.elseStmt;
    }

    public JExpression getIfExpr() {
        return this.ifExpr;
    }

    public JStatement getThenStmt() {
        return this.thenStmt;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            this.ifExpr = visitor.accept(this.ifExpr);
            if (this.thenStmt != null) {
                this.thenStmt = visitor.accept(this.thenStmt, true);
            }
            if (this.elseStmt != null) {
                this.elseStmt = visitor.accept(this.elseStmt, true);
            }
        }
        visitor.endVisit(this, ctx);
    }

    @Override
    public boolean unconditionalControlBreak() {
        boolean elseBreaks;
        boolean thenBreaks;
        boolean bl = thenBreaks = this.thenStmt != null && this.thenStmt.unconditionalControlBreak();
        if (thenBreaks && this.ifExpr == JBooleanLiteral.get(true)) {
            return true;
        }
        boolean bl2 = elseBreaks = this.elseStmt != null && this.elseStmt.unconditionalControlBreak();
        if (elseBreaks && this.ifExpr == JBooleanLiteral.get(false)) {
            return true;
        }
        return thenBreaks && elseBreaks;
    }
}

