/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.thirdparty.guava.common.collect.Lists;
import java.util.List;

public class JForStatement
extends JStatement {
    private JStatement body;
    private List<JStatement> initializers;
    private JExpression condition;
    private JExpression increments;

    public JForStatement(SourceInfo info, List<JStatement> initializers, JExpression condition, JExpression increments, JStatement body) {
        super(info);
        this.initializers = Lists.newArrayList(initializers);
        this.condition = condition;
        this.increments = increments;
        this.body = body;
    }

    public JStatement getBody() {
        return this.body;
    }

    public JExpression getIncrements() {
        return this.increments;
    }

    public List<JStatement> getInitializers() {
        return this.initializers;
    }

    public JExpression getCondition() {
        return this.condition;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            this.initializers = visitor.acceptWithInsertRemoveImmutable(this.initializers);
            if (this.condition != null) {
                this.condition = visitor.accept(this.condition);
            }
            if (this.increments != null) {
                this.increments = visitor.accept(this.increments);
            }
            if (this.body != null) {
                this.body = visitor.accept(this.body, true);
            }
        }
        visitor.endVisit(this, ctx);
    }
}

