/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JFloatLiteral
extends JValueLiteral {
    public static final JFloatLiteral ZERO = new JFloatLiteral(SourceOrigin.UNKNOWN, Double.longBitsToDouble(0L));
    private final double value;

    public static JFloatLiteral get(double value) {
        return JFloatLiteral.isZero(value) ? ZERO : new JFloatLiteral(SourceOrigin.UNKNOWN, value);
    }

    private static boolean isZero(double value) {
        return Double.doubleToRawLongBits(value) == 0L;
    }

    public JFloatLiteral(SourceInfo sourceInfo, double value) {
        super(sourceInfo);
        this.value = value;
    }

    @Override
    public JType getType() {
        return JPrimitiveType.FLOAT;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public Object getValueObj() {
        return new Double(this.value);
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            // empty if block
        }
        visitor.endVisit(this, ctx);
    }

    private Object readResolve() {
        return JFloatLiteral.isZero(this.value) ? ZERO : this;
    }
}

