/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.HasEnclosingType;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVariableRef;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JFieldRef
extends JVariableRef
implements HasEnclosingType {
    private final JDeclaredType enclosingType;
    private JExpression instance;
    private final JType overriddenType;

    public JFieldRef(SourceInfo info, JExpression instance, JField field, JDeclaredType enclosingType) {
        this(info, instance, field, enclosingType, null);
    }

    public JFieldRef(SourceInfo info, JExpression instance, JField field, JDeclaredType enclosingType, JType overriddenType) {
        super(info, field);
        assert (instance != null || field.isStatic());
        assert (enclosingType != null);
        this.instance = instance;
        this.enclosingType = enclosingType;
        this.overriddenType = overriddenType;
    }

    @Override
    public JDeclaredType getEnclosingType() {
        return this.enclosingType;
    }

    public JField getField() {
        return (JField)this.getTarget();
    }

    public JExpression getInstance() {
        return this.instance;
    }

    @Override
    public JType getType() {
        if (this.overriddenType != null) {
            return this.overriddenType;
        }
        return super.getType();
    }

    public boolean hasClinit() {
        JField field = this.getField();
        if (!field.isStatic()) {
            return false;
        }
        if (field.isFinal() && field.isCompileTimeConstant()) {
            return false;
        }
        return this.getEnclosingType().checkClinitTo(field.getEnclosingType());
    }

    @Override
    public boolean hasSideEffects() {
        if (this.hasClinit()) {
            return true;
        }
        return this.instance != null && this.instance.hasSideEffects();
    }

    public void resolve(JField newField) {
        assert (newField.replaces(this.getField()));
        this.target = newField;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx) && this.instance != null) {
            this.instance = visitor.accept(this.instance);
        }
        visitor.endVisit(this, ctx);
    }
}

