/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.javac.JsInteropUtil;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.AccessModifier;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.HasJsInfo;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JDeclarationStatement;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JFieldRef;
import com.google.gwt.dev.jjs.ast.JMember;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.JVariable;
import com.google.gwt.dev.jjs.ast.JVisitor;
import com.google.gwt.dev.util.StringInterner;
import java.io.Serializable;

public class JField
extends JVariable
implements JMember {
    public static final JField NULL_FIELD = new JField(SourceOrigin.UNKNOWN, "nullField", JClassType.NULL_CLASS, JReferenceType.NULL_TYPE, false, Disposition.FINAL);
    private HasJsInfo.JsMemberType jsMembertype = HasJsInfo.JsMemberType.NONE;
    private String jsName;
    private String jsNamespace;
    private boolean exported;
    private boolean isJsOverlay = false;
    private final JDeclaredType enclosingType;
    private final boolean isCompileTimeConstant;
    private final boolean isStatic;
    private final boolean isThisRef;
    private boolean isVolatile;
    private transient String signature;
    private final int access;

    public JField(SourceInfo info, String name, JDeclaredType enclosingType, JType type, boolean isStatic, Disposition disposition, AccessModifier access) {
        super(info, name, type, disposition.isFinal());
        this.enclosingType = enclosingType;
        this.isStatic = isStatic;
        this.isCompileTimeConstant = disposition.isCompileTimeConstant();
        this.isVolatile = disposition.isVolatile();
        this.isThisRef = disposition.isThisRef();
        this.access = access.ordinal();
    }

    public JField(SourceInfo info, String name, JDeclaredType enclosingType, JType type, boolean isStatic, Disposition disposition) {
        this(info, name, enclosingType, type, isStatic, disposition, AccessModifier.DEFAULT);
    }

    @Override
    public String getQualifiedName() {
        return this.getEnclosingType().getName() + "." + this.getName();
    }

    @Override
    public JDeclaredType getEnclosingType() {
        return this.enclosingType;
    }

    public JValueLiteral getLiteralInitializer() {
        JExpression initializer = this.getInitializer();
        if (initializer instanceof JValueLiteral) {
            return (JValueLiteral)initializer;
        }
        return null;
    }

    @Override
    public JFieldRef makeRef(SourceInfo info) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setJsMemberInfo(HasJsInfo.JsMemberType jsMembertype, String namespace, String name, boolean exported) {
        this.jsMembertype = jsMembertype;
        this.jsName = name != null ? name : jsMembertype.computeName(this);
        this.jsNamespace = namespace;
        this.exported = exported;
    }

    @Override
    public void setJsOverlay() {
        this.isJsOverlay = true;
    }

    @Override
    public HasJsInfo.JsMemberType getJsMemberType() {
        return this.jsMembertype;
    }

    @Override
    public boolean isJsInteropEntryPoint() {
        return this.exported && this.isStatic() && !this.isJsNative() && !this.isJsOverlay();
    }

    @Override
    public boolean canBeReferencedExternally() {
        return this.exported && !this.isJsNative();
    }

    @Override
    public boolean canBeImplementedExternally() {
        return this.isJsNative();
    }

    @Override
    public String getJsNamespace() {
        return this.jsNamespace == null ? this.enclosingType.getQualifiedJsName() : this.jsNamespace;
    }

    @Override
    public String getQualifiedJsName() {
        String namespace = this.getJsNamespace();
        return JsInteropUtil.isGlobal(namespace) ? this.jsName : namespace + "." + this.jsName;
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public boolean isJsNative() {
        return !this.isJsOverlay() && this.enclosingType.isJsNative();
    }

    @Override
    public boolean isJsOverlay() {
        return this.isJsOverlay;
    }

    @Override
    public boolean isJsMethodVarargs() {
        return false;
    }

    @Override
    public String getJsName() {
        return this.jsName;
    }

    public String getSignature() {
        if (this.signature == null) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getName());
            sb.append(':');
            sb.append(this.getType().getJsniSignatureName());
            this.signature = sb.toString();
        }
        return this.signature;
    }

    public boolean isCompileTimeConstant() {
        return this.isCompileTimeConstant;
    }

    @Override
    public boolean isExternal() {
        return this.getEnclosingType().isExternal();
    }

    @Override
    public boolean isPublic() {
        return this.access == AccessModifier.PUBLIC.ordinal();
    }

    @Override
    public boolean isPrivate() {
        return this.access == AccessModifier.PRIVATE.ordinal();
    }

    @Override
    public boolean needsDynamicDispatch() {
        return !this.isStatic;
    }

    @Override
    public boolean isStatic() {
        return this.isStatic;
    }

    @Override
    public boolean isSynthetic() {
        return false;
    }

    public boolean isThisRef() {
        return this.isThisRef;
    }

    public boolean isVolatile() {
        return this.isVolatile;
    }

    @Override
    public void setFinal() {
        if (this.isVolatile()) {
            throw new IllegalStateException("Volatile fields cannot be set final");
        }
        super.setFinal();
    }

    @Override
    public void setInitializer(JDeclarationStatement declStmt) {
        this.declStmt = declStmt;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            // empty if block
        }
        visitor.endVisit(this, ctx);
    }

    protected Object writeReplace() {
        if (this.isExternal()) {
            return new ExternalSerializedForm(this);
        }
        if (this == NULL_FIELD) {
            return ExternalSerializedNullField.INSTANCE;
        }
        return this;
    }

    boolean replaces(JField originalField) {
        if (this == originalField) {
            return true;
        }
        return originalField.isExternal() && originalField.getSignature().equals(this.getSignature()) && this.getEnclosingType().replaces(originalField.getEnclosingType());
    }

    private static class ExternalSerializedNullField
    implements Serializable {
        public static final ExternalSerializedNullField INSTANCE = new ExternalSerializedNullField();

        private ExternalSerializedNullField() {
        }

        private Object readResolve() {
            return NULL_FIELD;
        }
    }

    private static class ExternalSerializedForm
    implements Serializable {
        private final JDeclaredType enclosingType;
        private final String signature;

        public ExternalSerializedForm(JField field) {
            this.enclosingType = field.getEnclosingType();
            this.signature = field.getSignature();
        }

        private Object readResolve() {
            String name = StringInterner.get().intern(this.signature.substring(0, this.signature.indexOf(58)));
            JField result = new JField(SourceOrigin.UNKNOWN, name, this.enclosingType, JReferenceType.NULL_TYPE, false, Disposition.NONE);
            result.signature = this.signature;
            return result;
        }
    }

    public static enum Disposition {
        COMPILE_TIME_CONSTANT,
        FINAL,
        NONE,
        THIS_REF,
        VOLATILE;


        public boolean isFinal() {
            return this == COMPILE_TIME_CONSTANT || this == FINAL || this == THIS_REF;
        }

        public boolean isThisRef() {
            return this == THIS_REF;
        }

        private boolean isCompileTimeConstant() {
            return this == COMPILE_TIME_CONSTANT;
        }

        private boolean isVolatile() {
            return this == VOLATILE;
        }
    }
}

