/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.javac.JsInteropUtil;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.CanBeJsNative;
import com.google.gwt.dev.jjs.ast.CanHaveSuppressedWarnings;
import com.google.gwt.dev.jjs.ast.HasJsName;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JConstructor;
import com.google.gwt.dev.jjs.ast.JEnumType;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JMember;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.impl.JjsUtils;
import com.google.gwt.dev.util.StringInterner;
import com.google.gwt.dev.util.collect.Lists;
import com.google.gwt.thirdparty.guava.common.base.Preconditions;
import com.google.gwt.thirdparty.guava.common.base.Predicates;
import com.google.gwt.thirdparty.guava.common.base.Strings;
import com.google.gwt.thirdparty.guava.common.collect.Iterables;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class JDeclaredType
extends JReferenceType
implements CanHaveSuppressedWarnings,
HasJsName,
CanBeJsNative {
    private boolean isJsFunction;
    private boolean isJsType;
    private boolean isClassWideExport;
    private boolean isJsNative;
    private String jsNamespace = null;
    private String jsName = null;
    private Set<String> suppressedWarnings;
    private NestedClassDisposition nestedClassDisposition = NestedClassDisposition.TOP_LEVEL;
    protected transient List<JField> fields = Lists.create();
    protected transient List<JMethod> methods = Lists.create();
    private JDeclaredType clinitTarget = this;
    private JDeclaredType enclosingType;
    private boolean isExternal;
    private List<JInterfaceType> superInterfaces = Lists.create();

    public JDeclaredType(SourceInfo info, String name) {
        super(info, name);
    }

    public void addField(JField field) {
        assert (field.getEnclosingType() == this);
        this.fields = Lists.add(this.fields, field);
    }

    public void addImplements(JInterfaceType superInterface) {
        this.superInterfaces = Lists.add(this.superInterfaces, superInterface);
    }

    public final void addMethod(int index, JMethod method) {
        assert (method.getEnclosingType() == this);
        assert (!method.getName().equals("$clinit") || this.getMethods().size() == 0) : "Attempted adding $clinit method with index != 0";
        assert (!method.getName().equals("$init") || method.getParams().size() != 0 || this.getMethods().size() == 1) : "Attempted adding $init method with index != 1";
        this.methods = Lists.add(this.methods, index, method);
    }

    public void addMethod(JMethod newMethod) {
        this.addMethod(this.methods.size(), newMethod);
    }

    public boolean checkClinitTo(JDeclaredType targetType) {
        if (this == targetType) {
            return false;
        }
        if (targetType == null || !targetType.hasClinit()) {
            return false;
        }
        return this.getClinitTarget() != targetType.getClinitTarget();
    }

    public JMethod findMethod(String methodSignature, boolean recurse) {
        for (JMethod method : this.getMethods()) {
            if (!method.getSignature().equals(methodSignature)) continue;
            return method;
        }
        if (recurse && this.getSuperClass() != null) {
            return this.getSuperClass().findMethod(methodSignature, true);
        }
        return null;
    }

    public JDeclaredType findSubtype(Iterable<JDeclaredType> types) {
        Iterator<JDeclaredType> iterator = types.iterator();
        while (iterator.hasNext()) {
            JDeclaredType type;
            for (JDeclaredType tp = type = iterator.next(); tp != null; tp = tp.getSuperClass()) {
                if (this != tp) continue;
                return type;
            }
        }
        return null;
    }

    public final JMethod getClinitMethod() {
        assert (this.getMethods().size() != 0);
        JMethod clinit = this.getMethods().get(0);
        assert (clinit != null);
        assert (clinit.getName().equals("$clinit"));
        return clinit;
    }

    public final JDeclaredType getClinitTarget() {
        if (this.isJsFunction()) {
            return null;
        }
        return this.clinitTarget;
    }

    @Override
    public String[] getCompoundName() {
        if (this.enclosingType == null) {
            return new String[]{this.getShortName()};
        }
        assert (this.getShortName().startsWith(this.enclosingType.getShortName())) : "Innerclass name  " + this.getShortName() + " does not start with enclosing class name " + this.enclosingType.getShortName();
        String className = StringInterner.get().intern(this.getShortName().substring(this.enclosingType.getShortName().length() + 1));
        String[] enclosingCompoundName = this.enclosingType.getCompoundName();
        String[] compoundName = new String[enclosingCompoundName.length + 1];
        System.arraycopy(enclosingCompoundName, 0, compoundName, 0, enclosingCompoundName.length);
        compoundName[compoundName.length - 1] = className;
        return compoundName;
    }

    public String getSimpleName() {
        String[] compoundName = this.getCompoundName();
        return compoundName[compoundName.length - 1];
    }

    public Iterable<JConstructor> getConstructors() {
        return Iterables.filter(this.methods, Predicates.instanceOf(JConstructor.class));
    }

    public JDeclaredType getEnclosingType() {
        return this.enclosingType;
    }

    public List<JField> getFields() {
        return this.fields;
    }

    public List<JInterfaceType> getImplements() {
        return this.superInterfaces;
    }

    public abstract JMethod getInitMethod();

    @Override
    public String getJavahSignatureName() {
        return JjsUtils.javahSignatureFromName(this.name);
    }

    @Override
    public String getJsniSignatureName() {
        return "L" + this.name.replace('.', '/') + ';';
    }

    public final List<JMethod> getMethods() {
        return this.methods;
    }

    public Iterable<JMember> getMembers() {
        return Iterables.concat(this.fields, this.methods);
    }

    @Override
    public boolean isArrayType() {
        return false;
    }

    @Override
    public boolean isJsType() {
        return this.isJsType;
    }

    @Override
    public boolean isJsFunction() {
        return this.isJsFunction;
    }

    public boolean isClassWideExport() {
        return this.isClassWideExport;
    }

    public boolean hasJsInteropEntryPoints() {
        for (JMethod method : this.getMethods()) {
            if (!method.isJsInteropEntryPoint()) continue;
            return true;
        }
        for (JField field : this.getFields()) {
            if (!field.isJsInteropEntryPoint()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canBeReferencedExternally() {
        if (this.isJsType()) {
            return true;
        }
        for (JMember member : this.getMembers()) {
            if (!member.canBeReferencedExternally()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isJsNative() {
        return this.isJsNative;
    }

    @Override
    public boolean canBeImplementedExternally() {
        return this.isJsNative() || this.isJsFunction();
    }

    public abstract JClassType getSuperClass();

    public boolean hasClinit() {
        return this.getClinitTarget() != null;
    }

    @Override
    public boolean isExternal() {
        return this.isExternal;
    }

    public boolean isInstantiable() {
        if (this.isAbstract()) {
            return false;
        }
        if (!(this instanceof JClassType) && !(this instanceof JEnumType)) {
            return false;
        }
        return this.getDefaultConstructor() != null;
    }

    public void removeField(int i) {
        assert (!this.isExternal()) : "External types can not be modified.";
        this.fields = Lists.remove(this.fields, i);
    }

    public void removeMethod(int i) {
        assert (!this.isExternal()) : "External types can not be modified.";
        this.methods = Lists.remove(this.methods, i);
    }

    public void resolve(List<JInterfaceType> resolvedInterfaces, JDeclaredType pkgInfo) {
        assert (JType.replaces(resolvedInterfaces, this.superInterfaces));
        this.superInterfaces = Lists.normalize(resolvedInterfaces);
        if (this.jsNamespace == null) {
            this.jsNamespace = this.computeJsNamespace(pkgInfo);
        }
    }

    private String computeJsNamespace(JDeclaredType pkgInfo) {
        if (this.enclosingType != null) {
            return this.enclosingType.getQualifiedJsName();
        }
        return pkgInfo != null && pkgInfo.jsNamespace != null ? pkgInfo.jsNamespace : this.getPackageName();
    }

    public void setEnclosingType(JDeclaredType enclosingType) {
        this.enclosingType = enclosingType;
    }

    public void setExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    public void setJsTypeInfo(boolean isJsType, boolean isJsNative, boolean isJsFunction, String jsNamespace, String jsName, boolean isClassWideExport) {
        this.isJsType = isJsType;
        this.isJsNative = isJsNative;
        this.isJsFunction = isJsFunction;
        this.jsNamespace = jsNamespace;
        this.jsName = jsName;
        this.isClassWideExport = isClassWideExport;
    }

    public void sortFields(Comparator<? super JField> sort) {
        this.fields = Lists.sort(this.fields, sort);
    }

    public void sortMethods(Comparator<? super JMethod> sort) {
        JMethod[] a = this.methods.toArray(new JMethod[this.methods.size()]);
        Arrays.sort(a, 1, a.length, sort);
        this.methods = Lists.create(a);
    }

    protected abstract Object writeReplace();

    void readMembers(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.fields = (List)stream.readObject();
        this.methods = (List)stream.readObject();
    }

    void readMethodBodies(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        for (JMethod method : this.methods) {
            method.readBody(stream);
        }
    }

    void setClinitTarget(JDeclaredType newClinitTarget) {
        if (this.clinitTarget == newClinitTarget) {
            return;
        }
        if (newClinitTarget != null && this.getClass().desiredAssertionStatus()) {
            for (JClassType current = (JClassType)this.clinitTarget; current != newClinitTarget; current = current.getSuperClass()) {
                Preconditions.checkNotNull(current.getSuperClass(), "Null super class for: %s (currentTarget: %s; newTarget: %s) in %s", (Object)current, (Object)this.clinitTarget, (Object)newClinitTarget, (Object)this);
            }
        }
        this.clinitTarget = newClinitTarget;
    }

    void writeMembers(ObjectOutputStream stream) throws IOException {
        stream.writeObject(this.fields);
        stream.writeObject(this.methods);
    }

    void writeMethodBodies(ObjectOutputStream stream) throws IOException {
        for (JMethod method : this.methods) {
            method.writeBody(stream);
        }
    }

    private JMethod getDefaultConstructor() {
        for (JMethod jMethod : this.getConstructors()) {
            if (jMethod.getOriginalParamTypes().size() != 0) continue;
            return jMethod;
        }
        return null;
    }

    @Override
    public String getJsName() {
        return Strings.isNullOrEmpty(this.jsName) ? this.getSimpleName() : this.jsName;
    }

    @Override
    public String getJsNamespace() {
        return this.jsNamespace;
    }

    @Override
    public String getQualifiedJsName() {
        return JsInteropUtil.isGlobal(this.jsNamespace) ? this.getJsName() : this.jsNamespace + "." + this.getJsName();
    }

    public NestedClassDisposition getClassDisposition() {
        return this.nestedClassDisposition;
    }

    public void setClassDisposition(NestedClassDisposition nestedClassDisposition) {
        this.nestedClassDisposition = nestedClassDisposition;
    }

    @Override
    public Set<String> getSuppressedWarnings() {
        return this.suppressedWarnings;
    }

    @Override
    public void setSuppressedWarnings(Set<String> suppressedWarnings) {
        this.suppressedWarnings = suppressedWarnings;
    }

    public static enum NestedClassDisposition {
        STATIC,
        INNER,
        LOCAL(true),
        ANONYMOUS(true),
        LAMBDA(true),
        TOP_LEVEL;

        private final boolean localType;

        private NestedClassDisposition(boolean local) {
            this.localType = local;
        }

        private NestedClassDisposition() {
            this.localType = false;
        }

        public boolean isLocalType() {
            return this.localType;
        }
    }
}

