/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.AccessModifier;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JClassType;
import com.google.gwt.dev.jjs.ast.JExpression;
import com.google.gwt.dev.jjs.ast.JExpressionStatement;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JMethodBody;
import com.google.gwt.dev.jjs.ast.JMethodCall;
import com.google.gwt.dev.jjs.ast.JNewInstance;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JReferenceType;
import com.google.gwt.dev.jjs.ast.JStatement;
import com.google.gwt.dev.jjs.ast.JVisitor;
import java.io.Serializable;
import java.util.List;

public class JConstructor
extends JMethod {
    private boolean isEmpty = false;
    private boolean defaultConstructor;

    public JConstructor(SourceInfo info, JClassType enclosingType, AccessModifier access) {
        super(info, enclosingType.getShortName(), enclosingType, JPrimitiveType.VOID, false, false, true, access);
    }

    public void setDefaultConstructor() {
        this.defaultConstructor = true;
    }

    public boolean isDefaultConstructor() {
        return this.defaultConstructor;
    }

    @Override
    public boolean canBePolymorphic() {
        return false;
    }

    @Override
    public JMethodBody getBody() {
        return (JMethodBody)super.getBody();
    }

    @Override
    public JClassType getEnclosingType() {
        return (JClassType)super.getEnclosingType();
    }

    public JReferenceType getNewType() {
        return this.getEnclosingType().strengthenToNonNull().strengthenToExact();
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    public boolean isEmpty() {
        JMethodCall call;
        JMethod target;
        JExpressionStatement exprStmt;
        JExpression expr;
        if (this.isEmpty) {
            return true;
        }
        JMethodBody body = this.getBody();
        List<JStatement> statements = body.getStatements();
        if (statements.isEmpty()) {
            this.isEmpty = true;
            return true;
        }
        if (statements.size() > 1) {
            return false;
        }
        JStatement stmt = statements.get(0);
        if (stmt instanceof JExpressionStatement && (expr = (exprStmt = (JExpressionStatement)stmt).getExpr()) instanceof JMethodCall && !(expr instanceof JNewInstance) && (target = (call = (JMethodCall)expr).getTarget()) instanceof JConstructor) {
            this.isEmpty = ((JConstructor)target).isEmpty();
            return this.isEmpty;
        }
        return false;
    }

    @Override
    public boolean needsDynamicDispatch() {
        return false;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            this.visitChildren(visitor);
        }
        visitor.endVisit(this, ctx);
    }

    @Override
    protected Object writeReplace() {
        if (this.isExternal()) {
            return new ExternalSerializedForm(this);
        }
        return this;
    }

    private static class ExternalSerializedForm
    implements Serializable {
        private final JClassType enclosingType;
        private final String signature;

        public ExternalSerializedForm(JConstructor ctor) {
            this.enclosingType = ctor.getEnclosingType();
            this.signature = ctor.getSignature();
        }

        private Object readResolve() {
            JConstructor result = new JConstructor(SourceOrigin.UNKNOWN, this.enclosingType, AccessModifier.PUBLIC);
            result.signature = this.signature;
            return result;
        }
    }
}

