/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JDeclaredType;
import com.google.gwt.dev.jjs.ast.JEnumType;
import com.google.gwt.dev.jjs.ast.JInterfaceType;
import com.google.gwt.dev.jjs.ast.JMethod;
import com.google.gwt.dev.jjs.ast.JProgram;
import com.google.gwt.dev.jjs.ast.JVisitor;
import java.io.Serializable;

public class JClassType
extends JDeclaredType {
    public static JClassType NULL_CLASS = new JClassType(SourceOrigin.UNKNOWN, "NullClass", true, true);
    private final boolean isAbstract;
    private final boolean isFinal;
    private boolean isJso;
    private JClassType superClass;

    public JClassType(SourceInfo info, String name, boolean isAbstract, boolean isFinal) {
        super(info, name);
        this.isAbstract = isAbstract;
        this.isFinal = isFinal;
        this.isJso = name.equals("com.google.gwt.core.client.JavaScriptObject");
    }

    JClassType(String name) {
        super(SourceOrigin.UNKNOWN, name);
        this.isAbstract = false;
        this.isFinal = false;
        this.isJso = name.equals("com.google.gwt.core.client.JavaScriptObject");
        this.setExternal(true);
    }

    @Override
    public final JMethod getInitMethod() {
        if (this.getMethods().size() <= 1) {
            return null;
        }
        JMethod init = this.getMethods().get(1);
        if (!init.getName().equals("$init")) {
            return null;
        }
        return init;
    }

    @Override
    public final JClassType getSuperClass() {
        return this.superClass;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public JEnumType isEnumOrSubclass() {
        if (this.getSuperClass() != null) {
            return this.getSuperClass().isEnumOrSubclass();
        }
        return null;
    }

    @Override
    public boolean isFinal() {
        return this.isFinal;
    }

    @Override
    public boolean isJsoType() {
        return this.isJso;
    }

    @Override
    public boolean isJavaLangObject() {
        return this.superClass == null;
    }

    @Override
    public boolean canBeReferencedExternally() {
        return super.canBeReferencedExternally() || this.isJsoType() || JProgram.isRepresentedAsNative(this.getName()) || this.isJavaLangObject();
    }

    @Override
    public boolean isJsFunctionImplementation() {
        for (JInterfaceType superInterface : this.getImplements()) {
            if (!superInterface.isJsFunction()) continue;
            return true;
        }
        return false;
    }

    public final void setSuperClass(JClassType superClass) {
        assert (this.superClass == null || this.superClass == superClass || this.superClass.isExternal());
        this.superClass = superClass;
        if (!this.name.equals("com.google.gwt.core.client.JavaScriptObject") && superClass != null) {
            this.isJso = superClass.isJso;
        }
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            this.fields = visitor.acceptWithInsertRemoveImmutable(this.fields);
            this.methods = visitor.acceptWithInsertRemoveImmutable(this.methods);
        }
        visitor.endVisit(this, ctx);
    }

    @Override
    protected Object writeReplace() {
        if (this.isExternal()) {
            return new ExternalSerializedForm(this);
        }
        if (this == NULL_CLASS) {
            return ExternalSerializedNullClass.INSTANCE;
        }
        return this;
    }

    private static class ExternalSerializedNullClass
    implements Serializable {
        public static final ExternalSerializedNullClass INSTANCE = new ExternalSerializedNullClass();

        private ExternalSerializedNullClass() {
        }

        private Object readResolve() {
            return NULL_CLASS;
        }
    }

    private static class ExternalSerializedForm
    implements Serializable {
        private final String name;

        public ExternalSerializedForm(JClassType classType) {
            this.name = classType.getName();
        }

        private Object readResolve() {
            return new JClassType(this.name);
        }
    }
}

