/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.Correlation;
import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JField;
import com.google.gwt.dev.jjs.ast.JLiteral;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JClassLiteral
extends JLiteral {
    private JField field;
    private JType refType;

    private static SourceInfo addCorrelation(SourceInfo info) {
        info.addCorrelation(info.getCorrelator().by(Correlation.Literal.CLASS));
        return info;
    }

    public JClassLiteral(SourceInfo sourceInfo, JType type) {
        super(JClassLiteral.addCorrelation(sourceInfo));
        this.refType = type;
    }

    public JField getField() {
        return this.field;
    }

    public JType getRefType() {
        return this.refType;
    }

    @Override
    public JType getType() {
        assert (this.field != null);
        return this.field.getType();
    }

    public void resolve(JType newType) {
        assert (newType.replaces(this.refType));
        this.refType = newType;
    }

    public void setField(JField field) {
        assert (field != null);
        this.field = field;
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            // empty if block
        }
        visitor.endVisit(this, ctx);
    }
}

