/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.dev.jjs.ast;

import com.google.gwt.dev.jjs.SourceInfo;
import com.google.gwt.dev.jjs.SourceOrigin;
import com.google.gwt.dev.jjs.ast.Context;
import com.google.gwt.dev.jjs.ast.JPrimitiveType;
import com.google.gwt.dev.jjs.ast.JType;
import com.google.gwt.dev.jjs.ast.JValueLiteral;
import com.google.gwt.dev.jjs.ast.JVisitor;

public class JCharLiteral
extends JValueLiteral {
    public static final JCharLiteral NULL = new JCharLiteral(SourceOrigin.UNKNOWN, '\u0000');
    private final char value;

    public static JCharLiteral get(char value) {
        return value == '\u0000' ? NULL : new JCharLiteral(SourceOrigin.UNKNOWN, value);
    }

    public JCharLiteral(SourceInfo sourceInfo, char value) {
        super(sourceInfo);
        this.value = value;
    }

    @Override
    public JType getType() {
        return JPrimitiveType.CHAR;
    }

    public char getValue() {
        return this.value;
    }

    @Override
    public Object getValueObj() {
        return Character.valueOf(this.value);
    }

    @Override
    public void traverse(JVisitor visitor, Context ctx) {
        if (visitor.visit(this, ctx)) {
            // empty if block
        }
        visitor.endVisit(this, ctx);
    }

    private Object readResolve() {
        return this.value == '\u0000' ? NULL : this;
    }
}

